/*
 * Decompiled with CFR 0.152.
 */
package mill.define;

import mill.api.CompileProblemReporter;
import mill.api.Ctx;
import mill.api.Logger;
import mill.api.Result;
import mill.api.TestReporter;
import mill.define.Applicative;
import mill.define.Task;
import mill.moduledefs.Scaladoc;
import os.Path;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n * The [[mill.define.Target]] companion object, usually aliased as [[T]],\n * provides most of the helper methods and macros used to build task graphs.\n * methods like `Task.`[[apply]], `Task.`[[sources]], `Task.`[[command]] allow you to\n * define the tasks, while methods like `Task.`[[dest]], `Task.`[[log]] or\n * `Task.`[[env]] provide the core APIs that are provided to a task implementation\n */")
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u000b\u0016\u0001iAQA\u000f\u0001\u0005\u0002aDQA\u001f\u0001\u0005\u0002mDq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017Dq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002b\u0002!\t!a9\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!\u0011\u0004\u0001\u0005\u0002\tmq!B\u001c\u0016\u0011\u0003Ad!\u0002\u000b\u0016\u0011\u0003I\u0004\"\u0002\u001e\u0010\t\u0003Yda\u0002\u001f\u0010!\u0003\r\t!\u0010\u0005\u0006}E!\ta\u0010\u0005\u0006\u0007F!\t\u0001\u0012\u0002\t)\u0006\u001c8NQ1tK*\u0011acF\u0001\u0007I\u00164\u0017N\\3\u000b\u0003a\tA!\\5mY\u000e\u00011\u0003\u0002\u0001\u001cCU\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0002\u0012'S%b#G\u0004\u0002$I5\tQ#\u0003\u0002&+\u0005Y\u0011\t\u001d9mS\u000e\fG/\u001b<f\u0013\t9\u0003FA\u0004BaBd\u00170\u001a:\u000b\u0005\u0015*\u0002CA\u0012+\u0013\tYSC\u0001\u0003UCN\\\u0007CA\u00171\u001b\u0005q#BA\u0018\u0018\u0003\r\t\u0007/[\u0005\u0003c9\u0012aAU3tk2$\bCA\u00174\u0013\t!dFA\u0002Dib\u0004\"AN\t\u000f\u0005\rr\u0011\u0001\u0003+bg.\u0014\u0015m]3\u0011\u0005\rz1CA\b\u001c\u0003\u0019a\u0014N\\5u}Q\t\u0001HA\tUe\u00064XM]:f\u0007RD\bj\u001c7eKJ\u001c\"!E\u000e\u0002\r\u0011Jg.\u001b;%)\u0005\u0001\u0005C\u0001\u000fB\u0013\t\u0011UD\u0001\u0003V]&$\u0018a\u0003;sCZ,'o]3Dib,2!R3K)\t1\u0005\u000e\u0006\u0002H'B\u00191E\u000b%\u0011\u0005%SE\u0002\u0001\u0003\u0006\u0017N\u0011\r\u0001\u0014\u0002\u0002%F\u0011Q\n\u0015\t\u000399K!aT\u000f\u0003\u000f9{G\u000f[5oOB\u0011A$U\u0005\u0003%v\u00111!\u00118z\u0011\u0015!6\u00031\u0001V\u0003\u00051\u0007#\u0002\u000fW1J:\u0017BA,\u001e\u0005%1UO\\2uS>t'\u0007E\u0002ZC\u0012t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005uK\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\t\u0001W$A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'AC%oI\u0016DX\rZ*fc*\u0011\u0001-\b\t\u0003\u0013\u0016$QAZ\nC\u00021\u0013\u0011!\u0013\t\u0004[AB\u0005\"B5\u0014\u0001\u0004Q\u0017A\u0001=t!\rI6.\\\u0005\u0003Y\u000e\u00141aU3r!\r\u0019#\u0006\u001a\u0015\u0005'=,h\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002s/\u0005QQn\u001c3vY\u0016$WMZ:\n\u0005Q\f(\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003]\f\u0011o\f\u0016+\u0015\u0001\u0002\u0003\u0005\t\u0011+A\u0005\u0003c/\u0019:jC:$\be\u001c4!7n#(/\u0019<feN,W,\u0018\u0011uQ\u0006$\b%\u00197t_\u0002\u0002(o\u001c<jI\u0016\u001c\b\u0005\u001e5fAm[V.\u001b7m]\u0005\u0004\u0018NL\"uqvk\u0006\u0005^8!i\",'\u0002\t\u0011!A\u0001R\u0003EZ;oGRLwN\u001c\u0011\\7\u001alVL\u0003\u0011!A\u0001\u0002#f\f\u000b\u0002sB\u00111\u0005A\u0001\u0005I\u0016\u001cH\u000fF\u0002}\u0003\u000b\u00012!`A\u0001\u001b\u0005q(\"A@\u0002\u0005=\u001c\u0018bAA\u0002}\n!\u0001+\u0019;i\u0011\u001d\t9A\u0001a\u0002\u0003\u0013\t1a\u0019;y!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\u0019BD\u0002\\\u0003#I\u0011\u0001G\u0005\u0003_]I1!a\u0006/\u0003\r\u0019E\u000f_\u0005\u0005\u00037\tiB\u0001\u0003EKN$(bAA\f]!*!a\\;\u0002\"\u0005\u0012\u00111E\u0001\u0004$>R#F\u0003\u0011!A)\u0002\u0003\rV1tW:\"Wm\u001d;aA%\u001c\b%\u0019\u0011v]&\fX/\u001a\u0011a_Nt\u0003+\u0019;iA\u0002BSML4/A\u0001|W\u000f^\u0018dY\u0006\u001c8OR5mKNtC-Z:u_\u0001\u0004sN\u001d\u0011a_V$xF];o]\u0011,7\u000f^\u0018aS)\u0001\u0003\u0005\t\u0016!i\"\fG\u000fI5tA\u0005\u001c8/[4oK\u0012\u0004Co\u001c\u0011fm\u0016\u0014\u0018\u0010\t+be\u001e,G\u000fI8sA\r{W.\\1oI:\u0002\u0013\n\u001e\u0011jg\u0002\u001aG.Z1sK\u0012\u0004#-\u001a4pe\u0016\u0004\u0013p\\;s\u0015\u0001\u0002\u0003E\u000b\u0011uCN\\\u0007E];og2\u0002\u0013M\u001c3!s>,\beY1oAU\u001cX\rI5uA\u0005\u001c\b%\u0019\u0011tGJ\fGo\u00195!gB\f7-\u001a\u0011g_J\u0004C/Z7q_J\f'/\u001f\u0011gS2,7\u000fI8s\u0015\u0001\u0002\u0003E\u000b\u0011bAAd\u0017mY3!i>\u0004\u0003/\u001e;!e\u0016$XO\u001d8fI\u0002\n'\u000f^5gC\u000e$8O\f\u0011UQ&\u001c\b%[:!OV\f'/\u00198uK\u0016$\u0007\u0005^8!E\u0016\u0004SO\\5rk\u0016\u0004cm\u001c:\u000bA\u0001\u0002#\u0006I3wKJL\b\u0005V1sO\u0016$\be\u001c:!\u0007>lW.\u00198eY\u0001\u001ax\u000eI=pk\u0002\u001a\u0017M\u001c\u0011cK\u0002\u001aXO]3!i\"\fG\u000fI=pk\u0002:\u0018\u000e\u001c7!]>$\beY8mY&$W\rI8s\u0015\u0001\u0002\u0003E\u000b\u0011j]R,'OZ3sK\u0002:\u0018\u000e\u001e5!C:LxN\\3!K2\u001cX\rI<sSRLgn\u001a\u0011u_\u0002\"\bn\\:fAM\fW.\u001a\u0011qCRD7O\f\u0006!A\u0001Rs&A\u0002m_\u001e$B!!\u000b\u00020A\u0019Q&a\u000b\n\u0007\u00055bF\u0001\u0004M_\u001e<WM\u001d\u0005\b\u0003\u000f\u0019\u00019AA\u0019!\u0011\tY!a\r\n\t\u0005U\u0012Q\u0004\u0002\u0004\u0019><\u0007&B\u0002pk\u0006e\u0012EAA\u001e\u0003\u0011}tF\u000b\u0016\u000bA\u0001\u0002#\u0006\t1UCN\\g\u0006\\8hA\u0002J7\u000f\t;iK\u0002\"WMZ1vYR\u0004Cn\\4hKJ\u0004\u0003O]8wS\u0012,G\r\t4pe\u0002*g/\u001a:zAQ\f7o\u001b\u0018!/\"LG.\u001a\u0011z_V\u0014\b\u0005^1tW\u0002J7\u000f\t:v]:Lgn\u001a\u0017\u000bA\u0001\u0002#\u0006\t1TsN$X-\u001c\u0018pkR\u0004\u0007%\u00198eA\u0001\u001c\u0016p\u001d;f[:Jg\u000e\u0019\u0011be\u0016\u0004\u0013\r\\:pAI,G-\u001b:fGR,G\r\t;pAQD\u0017n\u001d\u0011m_\u001e<WM\u001d\u0018!)\",\u0007\u0005\\8hg\u00022wN\u001d\u0011b\u0015\u0001\u0002\u0003E\u000b\u0011uCN\\\u0007%\u0019:fAM$(/Z1nK\u0012\u0004Co\u001c\u0011ti\u0006tG-\u0019:eA=,HoL3se>\u0014\b%Y:!s>,\be^8vY\u0012\u0004S\r\u001f9fGRd\u0003EY;uA\u0015\f7\r\u001b\u0011uCN\\we\u001d\u0006!A\u0001R\u0003e\u001d9fG&4\u0017n\u0019\u0011pkR\u0004X\u000f\u001e\u0011jg\u0002\nGn]8!gR\u0014X-Y7fI\u0002\"x\u000eI1!Y><\u0007EZ5mK\u0002zg\u000e\t3jg.d\u0003%\u001a\u0018h]\u0001\u0002w.\u001e;0eVtg\u0006\\8hA\u0002z'O\u0003\u0011!A)\u0002\u0003m\\;u_\rd\u0017m]:GS2,7O\f7pO\u0002\u0004cm\u001c:!s>,\b\u0005^8!S:\u001c\b/Z2uA1\fG/\u001a:/\u0015\u0001\u0002\u0003E\u000b\u0006!A\u0001R\u0003%T3tg\u0006<Wm\u001d\u0011m_\u001e<W\r\u001a\u0011xSRD\u0007\u0005\u00197pO:\"WMY;hA\u0002\n\u0007\u000f]3be\u0002\u0012\u0017\u0010\t3fM\u0006,H\u000e\u001e\u0011p]2L\b%\u001b8!i\",\u0007\u0005\\8hA\u0019LG.Z:/\u0015\u0001\u0002\u0003E\u000b\u0011Z_V\u00043-\u00198!kN,\u0007\u0005\u001e5fA\u0001lS\u0006Z3ck\u001e\u0004\u0007e\u001c9uS>t\u0007e\u001e5f]\u0002\u0012XO\u001c8j]\u001e\u0004S.\u001b7mAQ|\u0007e\u001d5po\u0002\"\b.Z7!_:\u0004C\u000f[3!G>t7o\u001c7fAQ|wN\f\u0006!A\u0001Rs&\u0001\u0003i_6,Gc\u0001?\u0002B!9\u0011q\u0001\u0003A\u0004\u0005\r\u0003\u0003BA\u0006\u0003\u000bJA!a\u0012\u0002\u001e\t!\u0001j\\7fQ\u0015!q.^A&C\t\ti%\u0001%0U)R\u0001\u0005\t\u0011+AI+G/\u001e:og\u0002\"\b.\u001a\u0011j[Bd\u0017nY5uAm[V.\u001b7m]\u0005\u0004\u0018NL\"uq:Bu.\\3/Q>lW-X/!S:\u00043oY8qK:R\u0001\u0005\t\u0011+_\u0005\u0019QM\u001c<\u0015\t\u0005M\u0013\u0011\u000e\t\t\u0003+\ni&a\u0019\u0002d9!\u0011qKA-!\tYV$C\u0002\u0002\\u\ta\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u00121!T1q\u0015\r\tY&\b\t\u0005\u0003+\n)'\u0003\u0003\u0002h\u0005\u0005$AB*ue&tw\rC\u0004\u0002\b\u0015\u0001\u001d!a\u001b\u0011\t\u0005-\u0011QN\u0005\u0005\u0003_\niBA\u0002F]ZDS!B8v\u0003g\n#!!\u001e\u0002\u0005\u0007|#F\u000b\u0006!A\u0001R\u0003\u0005\u0019+bg.tSM\u001c<aA%\u001c\b\u0005\u001e5fA\u0015tg/\u001b:p]6,g\u000e\u001e\u0011wCJL\u0017M\u00197fA5\f\u0007\u000f\t9bgN,G\r\t;pAQDW\rI'jY2\u00043m\\7nC:$\u0007e\u001e5f]*\u0001\u0003\u0005\t\u0016!SR\u0004\u0013n\u001d\u0011sk:\\\u0004\u0005^=qS\u000e\fG\u000e\\=!kN,G\rI5og&$W\rI1!AR\u000b7o\u001b\u0018J]B,H\u000f\u0019\u0011u_\u0002*gn];sK\u0002\ng.\u001f\u0011dQ\u0006tw-Z:!S:T\u0001\u0005\t\u0011+AQDW\rI3om\u00022\u0018M]:!CJ,\u0007\u0005\u001d:pa\u0016\u0014H.\u001f\u0011eKR,7\r^3e])\u0001\u0003\u0005\t\u0016\u000bA\u0001\u0002#\u0006\t(pi\u0016\u0004C\u000f[1uAe|W\u000fI:i_VdG\r\t8pi\u0002*8/\u001a\u0011agf\u001ch&\u001a8wA2\u0002\u0013m\u001d\u0011NS2dwe\u001d\u0011m_:<W\u0006\\5wK\u0012\u00043/\u001a:wKJT\u0001\u0005\t\u0011+AA\u0014xnY3tg\u0002jW-\u00198tAQD\u0017\r\u001e\u0011agf\u001ch&\u001a8wA\u00022\u0018M]5bE2,7\u000fI7bs\u0002rw\u000e\u001e\u0011cK\u0002*\b\u000f\t;pA\u0011\fG/\u001a\u0018\u000bA\u0001\u0002#fL\u0001\u0005CJ<7\u000f\u0006\u0003\u0002|\u0005\u0015\u0005\u0007BA?\u0003\u0003\u0003B!W1\u0002\u0000A\u0019\u0011*!!\u0005\u0015\u0005\re!!A\u0001\u0002\u000b\u0005AJA\u0002`IeBq!a\u0002\u0007\u0001\b\t9\t\u0005\u0003\u0002\f\u0005%\u0015\u0002BAF\u0003;\u0011A!\u0011:hg\"*aa\\;\u0002\u0010\u0006\u0012\u0011\u0011S\u0001I_)R#\u0002\t\u0011!U\u0001\u0012V\r^;s]N\u0004C\u000f[3!S6\u0004H.[2ji\u0002Z6,\\5mY:\n\u0007/\u001b\u0018Dibt\u0013I]4t]\u0005\u0014xm]/^A%t\u0007e]2pa\u0016t#\u0002\t\u0011!U=\nA\u0002^3tiJ+\u0007o\u001c:uKJ$B!a&\u0002\u001eB\u0019Q&!'\n\u0007\u0005meF\u0001\u0007UKN$(+\u001a9peR,'\u000f\u0003\u0004\u0002\b\u001d\u0001\u001dA\r\u0015\u0006\u000f=,\u0018\u0011U\u0011\u0003\u0003G\u000bQh\f\u0016+\u0015\u0001\u0002\u0003E\u000b\u0011SKB|'\u000f\u001e\u0011uKN$\bE]3tk2$8\u000f\t;pA\t\u001b\u0006\u000b\t4pe\u0002JE)\u0012\u0011j]R,wM]1uS>t'\u0002\t\u0011!U=\n\u0001B]3q_J$XM\u001d\u000b\u0005\u0003S\u000b\t\rE\u0004\u001d\u0003W\u000by+!.\n\u0007\u00055VDA\u0005Gk:\u001cG/[8ocA\u0019A$!-\n\u0007\u0005MVDA\u0002J]R\u0004R\u0001HA\\\u0003wK1!!/\u001e\u0005\u0019y\u0005\u000f^5p]B\u0019Q&!0\n\u0007\u0005}fF\u0001\fD_6\u0004\u0018\u000e\\3Qe>\u0014G.Z7SKB|'\u000f^3s\u0011\u0019\t9\u0001\u0003a\u0002e!*\u0001b\\;\u0002F\u0006\u0012\u0011qY\u0001?_)R#\u0002\t\u0011!U\u0001\u0012V\r]8si\u0002\u0012W/\u001b7eAI,7/\u001e7ug\u0002\"x\u000e\t\"T!\u00022wN\u001d\u0011J\t\u0016\u0003\u0013N\u001c;fOJ\fG/[8o\u0015\u0001\u0002\u0003EK\u0018\u0002\u0013]|'o[:qC\u000e,Gc\u0001?\u0002N\"1\u0011qA\u0005A\u0004IBS!C8v\u0003#\f#!a5\u0002\u0005W{#F\u000b\u0006!A\u0001R\u0003\u0005\u00165jg\u0002J7\u000f\t;iK\u0002\u0002wn\u001d\u0018QCRD\u0007\r\t9pS:$\u0018N\\4!i>\u0004C\u000f[3!aJ|'.Z2uAI|w\u000e\u001e\u0011eSJ,7\r^8ss:R\u0001\u0005\t\u0011+\u0015\u0001\u0002\u0003E\u000b\u0011UQ&\u001c\b%[:!i\",\u0007\u0005\u001d:fM\u0016\u0014(/\u001a3!C\u000e\u001cWm]:!i>\u0004C\u000f[3!aJ|'.Z2uA\u0011L'/Z2u_JLH\u0006I1oI\u0002\u001a\bn\\;mI*\u0001\u0003\u0005\t\u0016!C2<\u0018-_:!E\u0016\u0004\u0003O]3gKJ\u0014X\r\u001a\u0011pm\u0016\u0014\b\u0005Y8t]A<H\r\u0019\u0016!Q]D\u0017n\u00195![&<\u0007\u000e\u001e\u0011bYN|\u0007\u0005]8j]R\u0004Co\u001c\u0011uQ\u0016T\u0001\u0005\t\u0011+AA\u0014xN[3di\u0002\"\u0017N]3di>\u0014\u0018\u0010I5oA\rd\u0017m]:jG\u0002\u001aG.\u001b\u0011tG\u0016t\u0017M]5pg2\u0002#-\u001e;![&<\u0007\u000e\u001e\u0011o_R\u0004\u0013N\u001c\u0011pi\",'O\u0003\u0011!A)\u0002So]3!G\u0006\u001cXm\u001d\u0011mS.,\u0007EQ*QA=\u0014\b\u0005T*QAM,'O^3sAU\u001c\u0018mZ3*])\u0001\u0003\u0005\t\u00160\u0003\ryW\u000f\u001e\u000b\u0004y\u0006e\u0007BBA\u0004\u0015\u0001\u000f!\u0007K\u0003\u000b_V\fi.\t\u0002\u0002`\u0006yuF\u000b\u0016\u000bA\u0001\u0002#\u0006\t+iSN\u0004\u0013n\u001d\u0011uQ\u0016\u0004\u0003m\\:/!\u0006$\b\u000e\u0019\u0011q_&tG/\u001b8hAQ|\u0007\u0005\u001e5fAA\u0014xN[3di\u001e\u001a\b\u0005Y8vi\u0002\u0004C-\u001b:fGR|'/\u001f\u0018\u000bA\u0001\u0002#fL\u0001\u0005M>\u00148\u000e\u0006\u0003\u0002f\u0006M\b\u0003BAt\u0003[tA!a\u0003\u0002j&!\u00111^A\u000f\u0003\u00111uN]6\n\t\u0005=\u0018\u0011\u001f\u0002\u0004\u0003BL'\u0002BAv\u0003;Aa!a\u0002\f\u0001\b\u0011\u0004&B\u0006pk\u0006]\u0018EAA}\u0003\u0005ErF\u000b\u0016\u000bA\u0001\u0002#\u0006\t)s_ZLG-Z:!i\",\u0007\u0005\u0019\u0018g_J\\g&Y:z]\u000e\u0004\u0007%\u00198eA\u0001tcm\u001c:l]\u0005<\u0018-\u001b;aA\u0005\u0003\u0016j\u001d\u0011g_J\u00043\u000f]1x]&tw\rI1oI\u0002Rw.\u001b8j]\u001eT\u0001\u0005\t\u0011+A\u0005\u001c\u0018P\\2!MV$XO]3tA]LG\u000f[5oAe|WO\u001d\u0011uCN\\\u0007%\u001b8!C\u0002j\u0015\u000e\u001c7.MJLWM\u001c3ms\u0002j\u0017M\u001c8fe:R\u0001\u0005\t\u0011+_\u0005A1/Z9vK:\u001cW-\u0006\u0003\u0002\u0000\n\u001dA\u0003\u0002B\u0001\u0005\u0017\u0001Ba\t\u0016\u0003\u0004A!\u0011l\u001bB\u0003!\rI%q\u0001\u0003\u0007\u0005\u0013a!\u0019\u0001'\u0003\u0003QCqA!\u0004\r\u0001\u0004\u0011y!\u0001\u0004t_V\u00148-\u001a\t\u00053.\u0014\t\u0002\u0005\u0003$U\t\u0015\u0001&\u0002\u0007pk\nU\u0011E\u0001B\f\u0003yz#F\u000b\u0006!A\u0001R\u0003eQ8om\u0016\u0014Ho\u001d\u0011bA\u0001\u001cV-].UCN\\7\fV/^A\u0002Jg\u000e^8!C\u0002\u0002G+Y:l7N+\u0017o\u0017+^;\u0002T\u0001\u0005\t\u0011+_\u0005AAO]1wKJ\u001cX-\u0006\u0004\u0003\u001e\tE\"q\u0005\u000b\u0005\u0005?\u0011)\u0004\u0006\u0003\u0003\"\t-\u0002\u0003B\u0012+\u0005G\u0001B!W6\u0003&A\u0019\u0011Ja\n\u0005\r\t%RB1\u0001M\u0005\u00051\u0006B\u0002+\u000e\u0001\u0004\u0011i\u0003E\u0004\u001d\u0003W\u0013yCa\r\u0011\u0007%\u0013\t\u0004\u0002\u0004\u0003\n5\u0011\r\u0001\u0014\t\u0005G)\u0012)\u0003C\u0004\u0003\u000e5\u0001\rAa\u000e\u0011\te['q\u0006\u0015\u0006\u001b=,(1H\u0011\u0003\u0005{\t!l\f\u0016+\u0015\u0001\u0002\u0003E\u000b\u0011D_:4XM\u001d;tA\u0005\u0004\u0003mU3r7Rk\u0006\rI5oi>\u0004\u0013\r\t1UCN\\7lU3r7ZkV\f\u0019\u0011vg&tw\r\t;iK\u0002:\u0017N^3oA\u00014'\b\t+!{y\u0002C+Y:l7Zk\u0006M\u0003\u0011!A)z\u0003&\u0002\u0001pk\n\u0005\u0013E\u0001B\"\u0003\r\u0015rF\u000b\u0016\u000bA)\u0002C\u000b[3!7nk\u0017\u000e\u001c7/I\u00164\u0017N\\3/)\u0006\u0014x-\u001a;^;\u0002\u001aw.\u001c9b]&|g\u000eI8cU\u0016\u001cG\u000f\f\u0011vgV\fG\u000e\\=!C2L\u0017m]3eA\u0005\u001c\beW.U;vc#\u0002\t\u0016!aJ|g/\u001b3fg\u0002jwn\u001d;!_\u001a\u0004C\u000f[3!Q\u0016d\u0007/\u001a:![\u0016$\bn\u001c3tA\u0005tG\rI7bGJ|7\u000fI;tK\u0012\u0004Co\u001c\u0011ck&dG\r\t;bg.\u0004sM]1qQNt#\u0002\t\u0016![\u0016$\bn\u001c3tA1L7.\u001a\u0011a)\u0006\u001c8N\f1\\7\u0006\u0004\b\u000f\\=^;2\u0002\u0003\rV1tW:\u00027lW:pkJ\u001cWm]/^Y\u0001\u0002G+Y:l]\u0001\\6lY8n[\u0006tG-X/!C2dwn\u001e\u0011z_V\u0004Co\u001c\u0006!U\u0001\"WMZ5oK\u0002\"\b.\u001a\u0011uCN\\7\u000f\f\u0011xQ&dW\rI7fi\"|Gm\u001d\u0011mS.,\u0007\u0005\u0019+bg.t\u0003mW.eKN$X,\u0018\u0017!AR\u000b7o\u001b\u0018a7ncwnZ/^A=\u0014(\u0002\t\u0016!AR\u000b7o\u001b\u0018a7n+gN^/^AA\u0014xN^5eK\u0002\"\b.\u001a\u0011d_J,\u0007%\u0011)Jg\u0002\"\b.\u0019;!CJ,\u0007\u0005\u001d:pm&$W\r\u001a\u0011u_\u0002\n\u0007\u0005^1tW\u0002JW\u000e\u001d7f[\u0016tG/\u0019;j_:T\u0001EK\u0018")
public class TaskBase
implements Applicative.Applyer<Task, Task, Result, Ctx>,
TraverseCtxHolder {
    @Override
    @Scaladoc(value="/**\n     * A variant of [[traverse]] that also provides the [[mill.api.Ctx]] to the\n     * function [[f]]\n     */")
    public <I, R> Task<R> traverseCtx(Seq<Task<I>> xs, Function2<IndexedSeq<I>, Ctx, Result<R>> f) {
        return ((TraverseCtxHolder)this).traverseCtx(xs, f);
    }

    @Override
    public Object ctx(Object c) {
        return Applicative.Applyer.ctx$(this, c);
    }

    @Scaladoc(value="/**\n   * `Task.dest` is a unique `os.Path` (e.g. `out/classFiles.dest/` or `out/run.dest/`)\n   * that is assigned to every Target or Command. It is cleared before your\n   * task runs, and you can use it as a scratch space for temporary files or\n   * a place to put returned artifacts. This is guaranteed to be unique for\n   * every Target or Command, so you can be sure that you will not collide or\n   * interfere with anyone else writing to those same paths.\n   */")
    public Path dest(Ctx.Dest ctx) {
        return ctx.dest();
    }

    @Scaladoc(value="/**\n   * `Task.log` is the default logger provided for every task. While your task is running,\n   * `System.out` and `System.in` are also redirected to this logger. The logs for a\n   * task are streamed to standard out/error as you would expect, but each task's\n   * specific output is also streamed to a log file on disk, e.g. `out/run.log` or\n   * `out/classFiles.log` for you to inspect later.\n   *\n   * Messages logged with `log.debug` appear by default only in the log files.\n   * You can use the `--debug` option when running mill to show them on the console too.\n   */")
    public Logger log(Ctx.Log ctx) {
        return ctx.log();
    }

    @Scaladoc(value="/**\n   * Returns the implicit [[mill.api.Ctx.Home.home]] in scope.\n   */")
    public Path home(Ctx.Home ctx) {
        return ctx.home();
    }

    @Scaladoc(value="/**\n   * `Task.env` is the environment variable map passed to the Mill command when\n   * it is run; typically used inside a `Task.Input` to ensure any changes in\n   * the env vars are properly detected.\n   *\n   * Note that you should not use `sys.env`, as Mill's long-lived server\n   * process means that `sys.env` variables may not be up to date.\n   */")
    public Map<String, String> env(Ctx.Env ctx) {
        return ctx.env();
    }

    @Scaladoc(value="/**\n   * Returns the implicit [[mill.api.Ctx.Args.args]] in scope.\n   */")
    public IndexedSeq<Object> args(Ctx.Args ctx) {
        return ctx.args();
    }

    @Scaladoc(value="/**\n   * Report test results to BSP for IDE integration\n   */")
    public TestReporter testReporter(Ctx ctx) {
        return ctx.testReporter();
    }

    @Scaladoc(value="/**\n   * Report build results to BSP for IDE integration\n   */")
    public Function1<Object, Option<CompileProblemReporter>> reporter(Ctx ctx) {
        return ctx.reporter();
    }

    @Scaladoc(value="/**\n   * This is the `os.Path` pointing to the project root directory.\n   *\n   * This is the preferred access to the project directory, and should\n   * always be preferred over `os.pwd`* (which might also point to the\n   * project directory in classic cli scenarios, but might not in other\n   * use cases like BSP or LSP server usage).\n   */")
    public Path workspace(Ctx ctx) {
        return ctx.workspace();
    }

    @Scaladoc(value="/**\n   * This is the `os.Path` pointing to the project's `out` directory.\n   */")
    public Path out(Ctx ctx) {
        return ctx.out();
    }

    @Scaladoc(value="/**\n   * Provides the `.fork.async` and `.fork.await` APIs for spawning and joining\n   * async futures within your task in a Mill-friendly manner.\n   */")
    public Ctx.Fork.Api fork(Ctx ctx) {
        return ctx.fork();
    }

    @Scaladoc(value="/**\n   * Converts a `Seq[Task[T]]` into a `Task[Seq[T]]`\n   */")
    public <T> Task<Seq<T>> sequence(Seq<Task<T>> source) {
        return new Task.Sequence<T>(source);
    }

    @Scaladoc(value="/**\n   * Converts a `Seq[T]` into a `Task[Seq[V]]` using the given `f: T => Task[V]`\n   */")
    public <T, V> Task<Seq<V>> traverse(Seq<T> source, Function1<T, Task<V>> f) {
        return new Task.Sequence((Seq)source.map(f));
    }

    public TaskBase() {
        Applicative.Applyer.$init$(this);
        TraverseCtxHolder.$init$(this);
    }

    public static interface TraverseCtxHolder {
        @Scaladoc(value="/**\n     * A variant of [[traverse]] that also provides the [[mill.api.Ctx]] to the\n     * function [[f]]\n     */")
        default public <I, R> Task<R> traverseCtx(Seq<Task<I>> xs, Function2<IndexedSeq<I>, Ctx, Result<R>> f) {
            return new Task.TraverseCtx(xs, f);
        }

        public static void $init$(TraverseCtxHolder $this) {
        }
    }
}

