/*
    Copyright 2000-2010 Broadcom Corporation

    <:label-BRCM:2011:DUAL/GPL:standard

    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:

       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.

    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.

    :>
*/

#ifndef _WAN_DRV_H_
#define _WAN_DRV_H_


/**************************************************************************
* File Name  : wan_drv.h
*
* Description: This file contains the implementation for the BCM6838 WAN
*              block to handle GPON/EPON/ActiveEthernet
*
* Updates    : 02/26/2013  Created.
***************************************************************************/
#include "rdpa_epon.h"


typedef enum
{
    SERDES_WAN_TYPE_GPON,
    SERDES_WAN_TYPE_EPON,
    SERDES_WAN_TYPE_AE,
    SERDES_WAN_TYPE_DSL,
    SERDES_WAN_TYPE_GBE
}E_SERDES_WAN_TYPE;


int ConfigWanSerdes(E_SERDES_WAN_TYPE wan_type, rdpa_epon_speed_mode epon_speed);

void SATA_PRBS_Gen(uint32_t enable, int mode, E_SERDES_WAN_TYPE wan_type, 
            uint32_t *valid, rdpa_epon_speed_mode epon_speed);

void SATA_PRBS_Get_Status(uint32_t *valid);

#endif
