/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __RUNNER_H_INCLUDED
#define __RUNNER_H_INCLUDED

#include "access_macros.h"
#ifndef __PACKING_ATTRIBUTE_STRUCT_END__
#include "packing.h"
#endif
#include "rdp_map.h"
/*  File automatically generated by Reggae at 23/09/2014  12:35:45   */


/*****************************************************************************************/
/* Packet SRAM arbiter.  This block is responsible for managing the arbitration between  */
/* the different clients of the packet SRAM.  The clients are: DMA,the Runners and MIPS, */
/*  which is also responsible for configuring the PSRAM.  The arbitration is according t */
/* o configurable fixed priority.  The block is also responsible fortranslating the EC t */
/* ransactions from the users into standard SRAM transactions and includes the SRAM itse */
/* lf (1Mbit single port SRAM).                                                          */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
#define PSRAM_MEM_OFFSET	( 0x000A0000 )
#define PSRAM_BLOCK_OFFSET	( 0x000C0000 )
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define PSRAM_MEM_MEM_ENTRY_OFFSET 	( 0x00000000 )
#define PSRAM_MEM_MEM_ENTRY_ADDRESS	( PSRAM_MEM_OFFSET + PSRAM_MEM_MEM_ENTRY_OFFSET )

/** Number of entries of the function into block **/
#define PSRAM_MEM_MEM_ENTRY_COUNTER ( 32768 )
/** Number of registers per entry **/
#define PSRAM_MEM_MEM_ENTRY_IN_OFFSET ( 4 )

#define PSRAM_BLOCK_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define PSRAM_BLOCK_CONFIGURATIONS_ADDRESS	( PSRAM_BLOCK_OFFSET + PSRAM_BLOCK_CONFIGURATIONS_OFFSET )

#define PSRAM_BLOCK_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define PSRAM_BLOCK_PM_COUNTERS_ADDRESS	( PSRAM_BLOCK_OFFSET + PSRAM_BLOCK_PM_COUNTERS_OFFSET )

#define PSRAM_BLOCK_DEBUG_OFFSET 	( 0x00000200 )
#define PSRAM_BLOCK_DEBUG_ADDRESS	( PSRAM_BLOCK_OFFSET + PSRAM_BLOCK_DEBUG_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* psram_mem_entry                                                                       */
/* psram_mem_entry                                                                       */
/*****************************************************************************************/

#define PSRAM_MEM_MEM_ENTRY_DATA_DATA_DATA_VALUE             ( 0x0 )
#define PSRAM_MEM_MEM_ENTRY_DATA_DATA_DATA_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_MEM_MEM_ENTRY_DATA_OFFSET ( 0x00000000 )

#define PSRAM_MEM_MEM_ENTRY_DATA_ADDRESS      	( PSRAM_MEM_MEM_ENTRY_ADDRESS + PSRAM_MEM_MEM_ENTRY_DATA_OFFSET )
#define PSRAM_MEM_MEM_ENTRY_DATA_READ( e, r ) 	READ_32( ( PSRAM_MEM_MEM_ENTRY_DATA_ADDRESS  + e * 4 ), (r) )
#define PSRAM_MEM_MEM_ENTRY_DATA_WRITE( e, v )	WRITE_32( ( PSRAM_MEM_MEM_ENTRY_DATA_ADDRESS + e * 4 ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data */
	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_MEM_MEM_ENTRY_DATA ;
#else
typedef struct
{
	/* data */
	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_MEM_MEM_ENTRY_DATA ;
#endif

/*****************************************************************************************/
/* address_collision_enable                                                              */
/* This register enables the address collision mechanizm for all the clients             */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_RRREN_DIS_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_RRREN_EN_VALUE                ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_RRREN_EN_VALUE_RESET_VALUE    ( 0x1 )


#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_OFFSET ( 0x00000000 )

#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* address_collision_enable */
	uint32_t rrren	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN ;
#else
typedef struct
{
	/* address_collision_enable */
	uint32_t rrren	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN ;
#endif

/*****************************************************************************************/
/* mips_c_param_reg                                                                      */
/* This register determines the priority, the weight and the collision enable relationsh */
/* ip with the other clients for the client     offset   client  -------- -------  4     */
/*      MIPS C  8         RUNNER A  C         RUNNER B  10        SDMA  14        MIPS D */
/*   18        MIPS (D)DMA                                                               */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_COLEN_MIN_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_COLEN_RESET_VALUE             ( 0xE )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_COLEN_RESET_VALUE_RESET_VALUE ( 0xE )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_COLEN_MAX_VALUE               ( 0x3F )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_WEIT_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_WEIT_RESET_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_WEIT_RESET_VALUE_RESET_VALUE  ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_WEIT_MAX_VALUE                ( 0x7 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_PRI_MIN_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_PRI_MAX_VALUE                 ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_PRI_RESET_VALUE               ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_PRI_RESET_VALUE_RESET_VALUE   ( 0x8 )


#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_OFFSET ( 0x00000004 )

#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR ;
#else
typedef struct
{
	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR ;
#endif

/*****************************************************************************************/
/* runner_a_param_reg                                                                    */
/* This register determines the priority, the weight and the collision enable relationsh */
/* ip with the other clients for the client     offset   client  -------- -------  4     */
/*      MIPS C  8         RUNNER A  C         RUNNER B  10        SDMA  14        MIPS D */
/*   18        MIPS (D)DMA                                                               */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_COLEN_MIN_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_COLEN_RESET_VALUE             ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_COLEN_RESET_VALUE_RESET_VALUE ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_COLEN_MAX_VALUE               ( 0x3F )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_WEIT_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_WEIT_RESET_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_WEIT_RESET_VALUE_RESET_VALUE  ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_WEIT_MAX_VALUE                ( 0x7 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_PRI_MIN_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_PRI_RESET_VALUE               ( 0x4 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_PRI_RESET_VALUE_RESET_VALUE   ( 0x4 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_PRI_MAX_VALUE                 ( 0x8 )


#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_OFFSET ( 0x00000008 )

#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR ;
#else
typedef struct
{
	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR ;
#endif

/*****************************************************************************************/
/* runner_b_param_reg                                                                    */
/* This register determines the priority, the weight and the collision enable relationsh */
/* ip with the other clients for the client     offset   client  -------- -------  4     */
/*      MIPS C  8         RUNNER A  C         RUNNER B  10        SDMA  14        MIPS D */
/*   18        MIPS (D)DMA                                                               */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_COLEN_MIN_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_COLEN_RESET_VALUE             ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_COLEN_RESET_VALUE_RESET_VALUE ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_COLEN_MAX_VALUE               ( 0x3F )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_WEIT_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_WEIT_RESET_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_WEIT_RESET_VALUE_RESET_VALUE  ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_WEIT_MAX_VALUE                ( 0x7 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_PRI_MIN_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_PRI_RESET_VALUE               ( 0x4 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_PRI_RESET_VALUE_RESET_VALUE   ( 0x4 )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_PRI_MAX_VALUE                 ( 0x8 )


#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_OFFSET ( 0x0000000C )

#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR ;
#else
typedef struct
{
	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR ;
#endif

/*****************************************************************************************/
/* sdma_param_reg                                                                        */
/* This register determines the priority, the weight and the collision enable relationsh */
/* ip with the other clients for the client     offset   client  -------- -------  4     */
/*      MIPS C  8         RUNNER A  C         RUNNER B  10        SDMA  14        MIPS D */
/*   18        MIPS (D)DMA                                                               */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_COLEN_MIN_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_COLEN_MIN_VALUE_RESET_VALUE   ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_COLEN_MAX_VALUE               ( 0x3F )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_WEIT_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_WEIT_RESET_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_WEIT_RESET_VALUE_RESET_VALUE  ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_WEIT_MAX_VALUE                ( 0x7 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_PRI_MIN_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_PRI_RESET_VALUE               ( 0x4 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_PRI_RESET_VALUE_RESET_VALUE   ( 0x4 )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_PRI_MAX_VALUE                 ( 0x8 )


#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_OFFSET ( 0x00000010 )

#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR ;
#else
typedef struct
{
	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR ;
#endif

/*****************************************************************************************/
/* mips_d_param_reg                                                                      */
/* This register determines the priority, the weight and the collision enable relationsh */
/* ip with the other clients for the client     offset   client  -------- -------  4     */
/*      MIPS C  8         RUNNER A  C         RUNNER B  10        SDMA  14        MIPS D */
/*   18        MIPS (D)DMA                                                               */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_COLEN_MIN_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_COLEN_RESET_VALUE             ( 0xE )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_COLEN_RESET_VALUE_RESET_VALUE ( 0xE )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_COLEN_MAX_VALUE               ( 0x3F )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_WEIT_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_WEIT_RESET_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_WEIT_RESET_VALUE_RESET_VALUE  ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_WEIT_MAX_VALUE                ( 0x7 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_PRI_MIN_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_PRI_MAX_VALUE                 ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_PRI_RESET_VALUE               ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_PRI_RESET_VALUE_RESET_VALUE   ( 0x8 )


#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_OFFSET ( 0x00000014 )

#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR ;
#else
typedef struct
{
	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR ;
#endif

/*****************************************************************************************/
/* mips_d_dma_param_reg                                                                  */
/* This register determines the priority, the weight and the collision enable relationsh */
/* ip with the other clients for the client     offset   client  -------- -------  4     */
/*      MIPS C  8         RUNNER A  C         RUNNER B  10        SDMA  14        MIPS D */
/*   18        MIPS (D)DMA                                                               */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_COLEN_MIN_VALUE               ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_COLEN_RESET_VALUE             ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_COLEN_RESET_VALUE_RESET_VALUE ( 0x8 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_COLEN_MAX_VALUE               ( 0x3F )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_WEIT_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_WEIT_RESET_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_WEIT_RESET_VALUE_RESET_VALUE  ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_WEIT_MAX_VALUE                ( 0x7 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_PRI_MIN_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_PRI_RESET_VALUE               ( 0x2 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_PRI_RESET_VALUE_RESET_VALUE   ( 0x2 )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_PRI_MAX_VALUE                 ( 0x8 )


#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_OFFSET ( 0x00000018 )

#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR ;
#else
typedef struct
{
	/* priority */
	uint32_t pri  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* weight */
	uint32_t weit 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* addr_collision_en_with_clients */
	uint32_t colen	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR ;
#endif

/*****************************************************************************************/
/* read_margin_reg                                                                       */
/* read margin configuration for the packet sram memory. determines clock shift for data */
/*  sampling                                                                             */
/*****************************************************************************************/

#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_RDMREN_MIN_VALUE              ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_RDMREN_MIN_VALUE_RESET_VALUE  ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_RDMREN_MAX_VALUE              ( 0x1 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_RDMR_MIN_VALUE                ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_RDMR_MIN_VALUE_RESET_VALUE    ( 0x0 )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_RDMR_MAX_VALUE                ( 0xF )


#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_OFFSET ( 0x0000001C )

#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_ADDRESS   	( PSRAM_BLOCK_CONFIGURATIONS_ADDRESS + PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_OFFSET )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_READ( r ) 	READ_32( ( PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_ADDRESS ), (r) )
#define PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_CONFIGURATIONS_RDMRGN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1    	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_margin_enable */
	uint32_t rdmren	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_margin */
	uint32_t rdmr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_RDMRGN ;
#else
typedef struct
{
	/* read_margin */
	uint32_t rdmr  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_margin_enable */
	uint32_t rdmren	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1    	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS_RDMRGN ;
#endif

/*****************************************************************************************/
/* mon_user_en                                                                           */
/* this register contains a bit for enable/disable of the counters. The counters will be */
/*  reset to zero on the positive edge of the enable bit, and will count until the time  */
/* window which is decrement counter, will reach zero, or until the enable bit will be d */
/* e-asserted.                                                                           */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_MUEN_R1_RESERVED_VALUE               ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_R1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSDMAMEN_DIS_VALUE            ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSDMAMEN_EN_VALUE             ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSDMAMEN_EN_VALUE_RESET_VALUE ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSDMEN_DIS_VALUE              ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSDMEN_EN_VALUE               ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSDMEN_EN_VALUE_RESET_VALUE   ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_SDMAMEN_DIS_VALUE               ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_SDMAMEN_EN_VALUE                ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_SDMAMEN_EN_VALUE_RESET_VALUE    ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_RNRBMEN_DIS_VALUE               ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_RNRBMEN_EN_VALUE                ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_RNRBMEN_EN_VALUE_RESET_VALUE    ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_RNRAMEN_DIS_VALUE               ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_RNRAMEN_EN_VALUE                ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_RNRAMEN_EN_VALUE_RESET_VALUE    ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSCMEN_DIS_VALUE              ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSCMEN_EN_VALUE               ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_MIPSCMEN_EN_VALUE_RESET_VALUE   ( 0x1 )


#define PSRAM_BLOCK_PM_COUNTERS_MUEN_OFFSET ( 0x00000000 )

#define PSRAM_BLOCK_PM_COUNTERS_MUEN_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_MUEN_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_MUEN_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_MUEN_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_MUEN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1        	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_dma_measure_enable */
	uint32_t mipsdmamen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_measure_enable */
	uint32_t mipsdmen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sdma_measure_enable */
	uint32_t sdmamen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_b_measure_enable */
	uint32_t rnrbmen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_a_measure_enable */
	uint32_t rnramen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_c_measure_enable */
	uint32_t mipscmen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_MUEN ;
#else
typedef struct
{
	/* mips_c_measure_enable */
	uint32_t mipscmen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_a_measure_enable */
	uint32_t rnramen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_b_measure_enable */
	uint32_t rnrbmen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sdma_measure_enable */
	uint32_t sdmamen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_measure_enable */
	uint32_t mipsdmen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_dma_measure_enable */
	uint32_t mipsdmamen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1        	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_MUEN ;
#endif

/*****************************************************************************************/
/* bw_counts_clocks                                                                      */
/* determines the time window in which we perform the bandwidth monitoring(on cyclic mod */
/* e - when cyclic_bw_check_en=1)                                                        */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BWCL_TW_MIN_WINDOW_WIDTH_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWCL_TW_MIN_WINDOW_WIDTH_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWCL_TW_MAX_WINDOW_WIDTH_VALUE             ( 0xFFFFFFFF )


#define PSRAM_BLOCK_PM_COUNTERS_BWCL_OFFSET ( 0x00000004 )

#define PSRAM_BLOCK_PM_COUNTERS_BWCL_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BWCL_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BWCL_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_BWCL_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BWCL_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_BWCL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* time_window */
	uint32_t tw	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BWCL ;
#else
typedef struct
{
	/* time_window */
	uint32_t tw	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BWCL ;
#endif

/*****************************************************************************************/
/* bw_enable                                                                             */
/* pm_bw_check_en - start of new monitoring session. resets counters on rise.  cyclic_bw */
/* _check_en - if this enabled - when the bw period reaches its limit - the counters are */
/*  reet.                                                                                */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BWEN_R2_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_R2_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_CBWCEN_DIS_VALUE              ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_CBWCEN_DIS_VALUE_RESET_VALUE  ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_CBWCEN_EN_VALUE               ( 0x1 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_R1_RESERVED_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_BWCEN_DIS_VALUE               ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_BWCEN_DIS_VALUE_RESET_VALUE   ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_BWCEN_EN_VALUE                ( 0x1 )


#define PSRAM_BLOCK_PM_COUNTERS_BWEN_OFFSET ( 0x00000008 )

#define PSRAM_BLOCK_PM_COUNTERS_BWEN_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BWEN_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_BWEN_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BWEN_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_BWEN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved2 */
	uint32_t r2    	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cyclic_bw_check_en */
	uint32_t cbwcen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved1 */
	uint32_t r1    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pm_bw_check_en */
	uint32_t bwcen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BWEN ;
#else
typedef struct
{
	/* pm_bw_check_en */
	uint32_t bwcen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved1 */
	uint32_t r1    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cyclic_bw_check_en */
	uint32_t cbwcen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved2 */
	uint32_t r2    	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BWEN ;
#endif

/*****************************************************************************************/
/* max_time_served                                                                       */
/* This array of counters hold the maximum time in clock cycles the client has waited fr */
/* om the moment it had a request pending to the time the request gained arbitration.    */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_MAX_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_MAX_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_MAX_MAX_VALUE             ( 0xFFFFFFFF )


#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_OFFSET ( 0x0000000C )

#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* max_time */
	uint32_t max	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_MAX_TIME ;
#else
typedef struct
{
	/* max_time */
	uint32_t max	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_MAX_TIME ;
#endif

/*****************************************************************************************/
/* accumulate_time_served                                                                */
/* This array of counters hold the accumulated time in clock cycles the client has waite */
/* d from the moment it had a request pending to the time the request gained arbitration */
/* .                                                                                     */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_MAX_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_MAX_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_MAX_MAX_VALUE             ( 0xFFFFFFFF )


#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_OFFSET ( 0x00000024 )

#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* max_time */
	uint32_t max	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_ACC_TIME ;
#else
typedef struct
{
	/* max_time */
	uint32_t max	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_ACC_TIME ;
#endif

/*****************************************************************************************/
/* accumulate_req_served                                                                 */
/* This array of counters hold the accumulated number of requests that was served per us */
/* er.                                                                                   */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_REQ_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_REQ_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_REQ_MAX_VALUE             ( 0xFFFFFFFF )


#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_OFFSET ( 0x0000003C )

#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* number_of_requests */
	uint32_t req	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_ACC_REQ ;
#else
typedef struct
{
	/* number_of_requests */
	uint32_t req	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_ACC_REQ ;
#endif

/*****************************************************************************************/
/* accumulate_time_last                                                                  */
/* This array of counters hold the Result of th elast measure of accumulated time in clo */
/* ck cycles the client has waited from the moment it had a request pending to the time  */
/* the request gained arbitration.                                                       */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_TIME_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_TIME_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_TIME_MAX_VALUE             ( 0xFFFFFFFF )


#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_OFFSET ( 0x00000054 )

#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* accumulated_time */
	uint32_t time	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME ;
#else
typedef struct
{
	/* accumulated_time */
	uint32_t time	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME ;
#endif

/*****************************************************************************************/
/* accumulate_req_last                                                                   */
/* This array of counters hold the last result of accumulated number of requests that wa */
/* s served per user on cyclic measure.                                                  */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_REQ_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_REQ_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_REQ_MAX_VALUE             ( 0xFFFFFFFF )


#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_OFFSET ( 0x0000006C )

#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Number_of_requests */
	uint32_t req	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ ;
#else
typedef struct
{
	/* Number_of_requests */
	uint32_t req	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ ;
#endif

/*****************************************************************************************/
/* bw_counts_data_wr_acc                                                                 */
/* This counter holds the sum of the WR_CNT array.  It holds the result of the current m */
/* easure.  If the measure is a single measure, the result will be kept until de-asserti */
/* on and assertion of the SINGLE start bit.                                             */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_OFFSET ( 0x00000090 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC ;
#endif

/*****************************************************************************************/
/* bw_counts_data_rd_acc                                                                 */
/* This counter holds the sum of the RD_CNT array.  It holds the result of the current m */
/* easure.  If the measure is a single measure, the result will be kept until de-asserti */
/* on and assertion of the SINGLE start bit.                                             */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_OFFSET ( 0x00000094 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC ;
#endif

/*****************************************************************************************/
/* bw_counts_data_wr                                                                     */
/* This array of counters holds the number of double words written to the psram per clie */
/* nt.  It holds the result of the current measure.  If the measure is a single measure, */
/*  the result will be kept until de-assertion and assertion of the SINGLE start bit.    */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_OFFSET ( 0x00000098 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT ;
#endif

/*****************************************************************************************/
/* bw_counts_data_rd                                                                     */
/* This array of counters holds the number of double words read from the psram per clien */
/* t.  It holds the result of the current measure.  If the measure is a single measure,  */
/* the result will be kept until de-assertion and assertion of the SINGLE start bit.     */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_OFFSET ( 0x000000B0 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT ;
#endif

/*****************************************************************************************/
/* bw_counts_data_wr_last_acc                                                            */
/* This counter is a sum of the WR_CNT_LAST counters, which holds the number of double w */
/* ords written to the psram per client.  When the measure is cyclic, it holds the resul */
/* t of the last measure, sampled once every end of a time window.                       */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_OFFSET ( 0x000000C8 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC ;
#endif

/*****************************************************************************************/
/* bw_counts_data_rd_last_acc                                                            */
/* This counter is a sum of the RD_CNT_LAST counters, which holds the number of double w */
/* ords written to the psram per client.  When the measure is cyclic, it holds the resul */
/* t of the last measure, sampled once every end of a time window.                       */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_OFFSET ( 0x000000CC )

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_ADDRESS   	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_READ( r ) 	READ_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_ADDRESS ), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC ;
#endif

/*****************************************************************************************/
/* bw_counts_data_wr_last                                                                */
/* This array of counters holds the number of double words written to the psram per clie */
/* nt.  When the measure is cyclic, it holds the result of the last measure, sampled onc */
/* e every end of a time window.                                                         */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_OFFSET ( 0x000000D0 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST ;
#endif

/*****************************************************************************************/
/* bw_counts_data_rd_last                                                                */
/* This array of counters holds the number of double words read from the psram per clien */
/* t.  When the measure is cyclic, it holds the result of the last measure, sampled once */
/*  every end of a time window.                                                          */
/*****************************************************************************************/

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_CNT_DEFAULT_VALUE             ( 0x0 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_OFFSET ( 0x000000E8 )

#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ADDRESS        	( PSRAM_BLOCK_PM_COUNTERS_ADDRESS + PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_OFFSET )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_READ_I( r, i ) 	READ_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ADDRESS ), (i), (r) )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_WRITE_I( v, i )	WRITE_I_32( ( PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST ;
#else
typedef struct
{
	/* Double_word_count */
	uint32_t cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST ;
#endif

/*****************************************************************************************/
/* dbg_mux_sel                                                                           */
/* selects the debug vecore                                                              */
/*****************************************************************************************/

#define PSRAM_BLOCK_DEBUG_DBGSEL_R1_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGSEL_R1_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGSEL_R1_MAX_VALUE             ( 0x7F )
#define PSRAM_BLOCK_DEBUG_DBGSEL_VS_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGSEL_VS_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGSEL_VS_MAX_VALUE             ( 0x7F )


#define PSRAM_BLOCK_DEBUG_DBGSEL_OFFSET ( 0x00000000 )

#define PSRAM_BLOCK_DEBUG_DBGSEL_ADDRESS   	( PSRAM_BLOCK_DEBUG_ADDRESS + PSRAM_BLOCK_DEBUG_DBGSEL_OFFSET )
#define PSRAM_BLOCK_DEBUG_DBGSEL_READ( r ) 	READ_32( ( PSRAM_BLOCK_DEBUG_DBGSEL_ADDRESS ), (r) )
#define PSRAM_BLOCK_DEBUG_DBGSEL_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_DEBUG_DBGSEL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* vector_select */
	uint32_t vs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG_DBGSEL ;
#else
typedef struct
{
	/* vector_select */
	uint32_t vs	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG_DBGSEL ;
#endif

/*****************************************************************************************/
/* dbg_bus                                                                               */
/* the debug bus                                                                         */
/*****************************************************************************************/

#define PSRAM_BLOCK_DEBUG_DBGBUS_R1_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGBUS_R1_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGBUS_R1_MAX_VALUE             ( 0x7F )
#define PSRAM_BLOCK_DEBUG_DBGBUS_VB_MIN_VALUE             ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGBUS_VB_MIN_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_DEBUG_DBGBUS_VB_MAX_VALUE             ( 0x1FFFFF )


#define PSRAM_BLOCK_DEBUG_DBGBUS_OFFSET ( 0x00000004 )

#define PSRAM_BLOCK_DEBUG_DBGBUS_ADDRESS   	( PSRAM_BLOCK_DEBUG_ADDRESS + PSRAM_BLOCK_DEBUG_DBGBUS_OFFSET )
#define PSRAM_BLOCK_DEBUG_DBGBUS_READ( r ) 	READ_32( ( PSRAM_BLOCK_DEBUG_DBGBUS_ADDRESS ), (r) )
#define PSRAM_BLOCK_DEBUG_DBGBUS_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_DEBUG_DBGBUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dbg_bus */
	uint32_t vb	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG_DBGBUS ;
#else
typedef struct
{
	/* dbg_bus */
	uint32_t vb	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG_DBGBUS ;
#endif

/*****************************************************************************************/
/* request_vector                                                                        */
/* vector of all the requests of the clients (tx fifo not empty)                         */
/*****************************************************************************************/

#define PSRAM_BLOCK_DEBUG_REQ_VEC_R1_MIN_VALUE                            ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_R1_MIN_VALUE_RESET_VALUE                ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_R1_MAX_VALUE                            ( 0x7F )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSDMA_REQ_NON_VALID_VALUE             ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSDMA_REQ_NON_VALID_VALUE_RESET_VALUE ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSDMA_REQ_VALID_VALUE                 ( 0x1 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSD_REQ_NON_VALID_VALUE               ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSD_REQ_NON_VALID_VALUE_RESET_VALUE   ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSD_REQ_VALID_VALUE                   ( 0x1 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_SDMA_REQ_NON_VALID_VALUE                ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_SDMA_REQ_NON_VALID_VALUE_RESET_VALUE    ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_SDMA_REQ_VALID_VALUE                    ( 0x1 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_RNRB_REQ_NON_VALID_VALUE                ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_RNRB_REQ_NON_VALID_VALUE_RESET_VALUE    ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_RNRB_REQ_VALID_VALUE                    ( 0x1 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_RNRA_REQ_NON_VALID_VALUE                ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_RNRA_REQ_NON_VALID_VALUE_RESET_VALUE    ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_RNRA_REQ_VALID_VALUE                    ( 0x1 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSC_REQ_NON_VALID_VALUE               ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSC_REQ_NON_VALID_VALUE_RESET_VALUE   ( 0x0 )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_MIPSC_REQ_VALID_VALUE                   ( 0x1 )


#define PSRAM_BLOCK_DEBUG_REQ_VEC_OFFSET ( 0x00000008 )

#define PSRAM_BLOCK_DEBUG_REQ_VEC_ADDRESS   	( PSRAM_BLOCK_DEBUG_ADDRESS + PSRAM_BLOCK_DEBUG_REQ_VEC_OFFSET )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_READ( r ) 	READ_32( ( PSRAM_BLOCK_DEBUG_REQ_VEC_ADDRESS ), (r) )
#define PSRAM_BLOCK_DEBUG_REQ_VEC_WRITE( v )	WRITE_32( ( PSRAM_BLOCK_DEBUG_REQ_VEC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1         	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_dma_request */
	uint32_t mipsdma_req	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_request */
	uint32_t mipsd_req  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sdma_request */
	uint32_t sdma_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_b_request */
	uint32_t rnrb_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_a_request */
	uint32_t rnra_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_c_request */
	uint32_t mipsc_req  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG_REQ_VEC ;
#else
typedef struct
{
	/* mips_c_request */
	uint32_t mipsc_req  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_a_request */
	uint32_t rnra_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_b_request */
	uint32_t rnrb_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sdma_request */
	uint32_t sdma_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_request */
	uint32_t mipsd_req  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_dma_request */
	uint32_t mipsdma_req	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1         	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG_REQ_VEC ;
#endif

typedef struct
{
	/* psram_mem_entry */
	PSRAM_MEM_MEM_ENTRY_DATA data __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_MEM_MEM_ENTRY ;

typedef struct
{
	/* address_collision_enable */
	PSRAM_BLOCK_CONFIGURATIONS_ADCOLEN adcolen __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_c_param_reg */
	PSRAM_BLOCK_CONFIGURATIONS_MIPSCPAR mipscpar __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_a_param_reg */
	PSRAM_BLOCK_CONFIGURATIONS_RNRAPAR rnrapar __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_b_param_reg */
	PSRAM_BLOCK_CONFIGURATIONS_RNRBPAR rnrbpar __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sdma_param_reg */
	PSRAM_BLOCK_CONFIGURATIONS_SDMAPAR sdmapar __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_param_reg */
	PSRAM_BLOCK_CONFIGURATIONS_MIPSDPAR mipsdpar __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mips_d_dma_param_reg */
	PSRAM_BLOCK_CONFIGURATIONS_MIPSDMAPAR mipsdmapar __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_margin_reg */
	PSRAM_BLOCK_CONFIGURATIONS_RDMRGN rdmrgn __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_CONFIGURATIONS ;

/*****************************************************************************************/
/* This section is dedicated to the performance monitor counters, global and per user.   */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_NUMBER ( 6 )
#define PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_NUMBER ( 6 )
typedef struct
{
	/* mon_user_en */
	PSRAM_BLOCK_PM_COUNTERS_MUEN muen __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_clocks */
	PSRAM_BLOCK_PM_COUNTERS_BWCL bwcl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_enable */
	PSRAM_BLOCK_PM_COUNTERS_BWEN bwen __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_time_served */
	PSRAM_BLOCK_PM_COUNTERS_MAX_TIME max_time [ PSRAM_BLOCK_PM_COUNTERS_MAX_TIME_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* accumulate_time_served */
	PSRAM_BLOCK_PM_COUNTERS_ACC_TIME acc_time [ PSRAM_BLOCK_PM_COUNTERS_ACC_TIME_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* accumulate_req_served */
	PSRAM_BLOCK_PM_COUNTERS_ACC_REQ acc_req [ PSRAM_BLOCK_PM_COUNTERS_ACC_REQ_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* accumulate_time_last */
	PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME last_acc_time [ PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_TIME_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* accumulate_req_last */
	PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ last_acc_req [ PSRAM_BLOCK_PM_COUNTERS_LAST_ACC_REQ_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_wr_acc */
	PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_ACC bw_wr_cnt_acc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_rd_acc */
	PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_ACC bw_rd_cnt_acc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_wr */
	PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT bw_wr_cnt [ PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_rd */
	PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT bw_rd_cnt [ PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_wr_last_acc */
	PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_ACC bw_wr_cnt_last_acc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_rd_last_acc */
	PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_ACC bw_rd_cnt_last_acc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_wr_last */
	PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST bw_wr_cnt_last [ PSRAM_BLOCK_PM_COUNTERS_BW_WR_CNT_LAST_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_counts_data_rd_last */
	PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST bw_rd_cnt_last [ PSRAM_BLOCK_PM_COUNTERS_BW_RD_CNT_LAST_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_PM_COUNTERS ;

typedef struct
{
	/* dbg_mux_sel */
	PSRAM_BLOCK_DEBUG_DBGSEL dbgsel __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dbg_bus */
	PSRAM_BLOCK_DEBUG_DBGBUS dbgbus __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* request_vector */
	PSRAM_BLOCK_DEBUG_REQ_VEC req_vec __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK_DEBUG ;

typedef struct
{
	/* mem_entry function */
	PSRAM_MEM_MEM_ENTRY mem_entry [ PSRAM_MEM_MEM_ENTRY_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_MEM ;

typedef struct
{
	/* configurations function */
	PSRAM_BLOCK_CONFIGURATIONS configurations __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved0 [ 224 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pm_counters function */
	PSRAM_BLOCK_PM_COUNTERS pm_counters __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug function */
	PSRAM_BLOCK_DEBUG debug __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
PSRAM_BLOCK ;

typedef struct
{
	/* MEM */
	PSRAM_MEM mem __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 131068 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BLOCK */
	PSRAM_BLOCK block __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
PSRAM_FOR_ALL ;
#endif /* PSRAM_H_INCLUDED */
