/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __GPON_H_INCLUDED
#define __GPON_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:54:37   */

#include "access_macros.h"
#include "packing.h"
#include "rdp_map.h"

/*****************************************************************************************/
/* GPON MAC configuration registers and PM counters.                                     */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define GPON_RX_GENERAL_CONFIG_OFFSET 	( 0x00000000 )
#define GPON_RX_GENERAL_CONFIG_ADDRESS	( GPON_RX_OFFSET + GPON_RX_GENERAL_CONFIG_OFFSET )

#define GPON_RX_IRQ_OFFSET 	( 0x00000010 )
#define GPON_RX_IRQ_ADDRESS	( GPON_RX_OFFSET + GPON_RX_IRQ_OFFSET )

#define GPON_RX_PLOAM_OFFSET 	( 0x00000020 )
#define GPON_RX_PLOAM_ADDRESS	( GPON_RX_OFFSET + GPON_RX_PLOAM_OFFSET )

#define GPON_RX_ALLOC_ID_OFFSET 	( 0x00000030 )
#define GPON_RX_ALLOC_ID_ADDRESS	( GPON_RX_OFFSET + GPON_RX_ALLOC_ID_OFFSET )

#define GPON_RX_CLK_8KHZ_OFFSET 	( 0x00000120 )
#define GPON_RX_CLK_8KHZ_ADDRESS	( GPON_RX_OFFSET + GPON_RX_CLK_8KHZ_OFFSET )

#define GPON_RX_CONGESTION_OFFSET 	( 0x00000130 )
#define GPON_RX_CONGESTION_ADDRESS	( GPON_RX_OFFSET + GPON_RX_CONGESTION_OFFSET )

#define GPON_RX_PORT_ID_OFFSET 	( 0x00000200 )
#define GPON_RX_PORT_ID_ADDRESS	( GPON_RX_OFFSET + GPON_RX_PORT_ID_OFFSET )

#define GPON_RX_ENCRYPTION_OFFSET 	( 0x00000700 )
#define GPON_RX_ENCRYPTION_ADDRESS	( GPON_RX_OFFSET + GPON_RX_ENCRYPTION_OFFSET )

#define GPON_RX_AMD2_OFFSET 	( 0x00000800 )
#define GPON_RX_AMD2_ADDRESS	( GPON_RX_OFFSET + GPON_RX_AMD2_OFFSET )

#define GPON_RX_PM_COUNTER_OFFSET 	( 0x00000A00 )
#define GPON_RX_PM_COUNTER_ADDRESS	( GPON_RX_OFFSET + GPON_RX_PM_COUNTER_OFFSET )

#define GPON_RX_BWMAP_RECORD_OFFSET 	( 0x00000A80 )
#define GPON_RX_BWMAP_RECORD_ADDRESS	( GPON_RX_OFFSET + GPON_RX_BWMAP_RECORD_OFFSET )

#define GPON_RX_GRX_DEBUG_OFFSET 	( 0x00000B00 )
#define GPON_RX_GRX_DEBUG_ADDRESS	( GPON_RX_OFFSET + GPON_RX_GRX_DEBUG_OFFSET )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_OFFSET 	( 0x00000000 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS	( GPON_TX_OFFSET + GPON_TX_GENERAL_TRANSMITTER_CONTROL_OFFSET )

#define GPON_TX_INTERRUPT_CONTROLLER_OFFSET 	( 0x00000024 )
#define GPON_TX_INTERRUPT_CONTROLLER_ADDRESS	( GPON_TX_OFFSET + GPON_TX_INTERRUPT_CONTROLLER_OFFSET )

#define GPON_TX_GENERAL_CONFIGURATION_OFFSET 	( 0x00000050 )
#define GPON_TX_GENERAL_CONFIGURATION_ADDRESS	( GPON_TX_OFFSET + GPON_TX_GENERAL_CONFIGURATION_OFFSET )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_OFFSET 	( 0x00000200 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS	( GPON_TX_OFFSET + GPON_TX_PLOAM_AND_DBA_MEMORY_OFFSET )

#define GPON_TX_TX_FIFO_CONFIGURATION_OFFSET 	( 0x00000500 )
#define GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS	( GPON_TX_OFFSET + GPON_TX_TX_FIFO_CONFIGURATION_OFFSET )

#define GPON_TX_TX_FIFO_STATISTICS_OFFSET 	( 0x00000800 )
#define GPON_TX_TX_FIFO_STATISTICS_ADDRESS	( GPON_TX_OFFSET + GPON_TX_TX_FIFO_STATISTICS_OFFSET )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_OFFSET 	( 0x00000A00 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS	( GPON_TX_OFFSET + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* Receiver_Status                                                                       */
/* This registers shows the status of different receiver sub-units                       */
/*****************************************************************************************/

#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_R2_R_VALUE                              ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_R2_R_VALUE_RESET_VALUE                  ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_BIT_ALIGN_DEFAULT_VALUE                 ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_BIT_ALIGN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_R1_R_VALUE                              ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_R1_R_VALUE_RESET_VALUE                  ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_LCDG_STATE_GEM_SYNCED_VALUE             ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_LCDG_STATE_GEM_SYNCED_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_LCDG_STATE_GEM_LCDG_VALUE               ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_FEC_STATE_FEC_OFF_VALUE                 ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_FEC_STATE_FEC_OFF_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_FEC_STATE_FEC_ON_VALUE                  ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_LOF_SYNCED_VALUE                        ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_LOF_LOF_VALUE                           ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_LOF_LOF_VALUE_RESET_VALUE               ( 0x1 )


#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_OFFSET ( 0x00000000 )

#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_ADDRESS   	( GPON_RX_GENERAL_CONFIG_ADDRESS + GPON_RX_GENERAL_CONFIG_RCVR_STATUS_OFFSET )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_READ( r ) 	READ_32( ( GPON_RX_GENERAL_CONFIG_RCVR_STATUS_ADDRESS ), (r) )
#define GPON_RX_GENERAL_CONFIG_RCVR_STATUS_WRITE( v )	WRITE_32( ( GPON_RX_GENERAL_CONFIG_RCVR_STATUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2        	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Frame_bit_alignment */
	uint32_t bit_align 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loss_of_GEM_Delineation */
	uint32_t lcdg_state	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_state */
	uint32_t fec_state 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOF_State */
	uint32_t lof       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_RCVR_STATUS ;
#else
typedef struct
{	uint32_t lof       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOF_State */
	uint32_t fec_state 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_state */
	uint32_t lcdg_state	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loss_of_GEM_Delineation */
	uint32_t r1        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bit_align 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Frame_bit_alignment */
	uint32_t r2        	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_RCVR_STATUS ;
#endif

/*****************************************************************************************/
/* Receiver_General_Configuration                                                        */
/* This register controls several general parameters of the receiver:  * Descrambler ove */
/* rride  * Receiver enable/disable  * Loopback enable/disable                           */
/*****************************************************************************************/

#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_R1_R_VALUE                                     ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_R1_R_VALUE_RESET_VALUE                         ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_DIN_POLARITY_POSITIVE_VALUE                    ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_DIN_POLARITY_POSITIVE_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_DIN_POLARITY_NEGATIVE_VALUE                    ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_SOP_RESET_DEASSERTED_VALUE                     ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_SOP_RESET_DEASSERTED_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_SOP_RESET_ASSERTED_VALUE                       ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_SQUELCH_DIS_SQUELCH_ENABLE_VALUE               ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_SQUELCH_DIS_SQUELCH_DISABLE_VALUE              ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_SQUELCH_DIS_SQUELCH_DISABLE_VALUE_RESET_VALUE  ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_ST_DISC_FEC_ST_DISCONNECTED_VALUE          ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_ST_DISC_FEC_ST_CONNECTED_VALUE             ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_ST_DISC_FEC_ST_CONNECTED_VALUE_RESET_VALUE ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_FORCE_FORCE_FEC_OFF_VALUE                  ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_FORCE_FORCE_FEC_OFF_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_FORCE_FORCE_FEC_ON_VALUE                   ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_LOOPBACK_ENABLE_LOOPBACK_OFF_VALUE             ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_LOOPBACK_ENABLE_LOOPBACK_OFF_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_LOOPBACK_ENABLE_LOOPBACK_ON_VALUE              ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_RX_DISABLE_RX_ENABLED_VALUE                    ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_RX_DISABLE_RX_DISABLED_VALUE                   ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_RX_DISABLE_RX_DISABLED_VALUE_RESET_VALUE       ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_DISABLE_FEC_ENABLED_VALUE                  ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_DISABLE_FEC_ENABLED_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_FEC_DISABLE_FEC_DISABLED_VALUE                 ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_DES_DISABLE_DESCRAMBLER_ON_VALUE               ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_DES_DISABLE_DESCRAMBLER_ON_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_DES_DISABLE_DESCRAMBLER_OFF_VALUE              ( 0x1 )


#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_OFFSET ( 0x00000004 )

#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_ADDRESS   	( GPON_RX_GENERAL_CONFIG_ADDRESS + GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_OFFSET )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_READ( r ) 	READ_32( ( GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_ADDRESS ), (r) )
#define GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_WRITE( v )	WRITE_32( ( GPON_RX_GENERAL_CONFIG_RCVR_CONFIG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1             	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_data_in_polarity */
	uint32_t din_polarity   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SOP_Reset */
	uint32_t sop_reset      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Squelch_Disable */
	uint32_t squelch_dis    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_State_Disconnect */
	uint32_t fec_st_disc    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Force */
	uint32_t fec_force      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loopback_Enable */
	uint32_t loopback_enable	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Receiver_Enable */
	uint32_t rx_disable     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Disable */
	uint32_t fec_disable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descrambler_Disable */
	uint32_t des_disable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_RCVR_CONFIG ;
#else
typedef struct
{	uint32_t des_disable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descrambler_Disable */
	uint32_t fec_disable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Disable */
	uint32_t rx_disable     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Receiver_Enable */
	uint32_t loopback_enable	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loopback_Enable */
	uint32_t fec_force      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Force */
	uint32_t fec_st_disc    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_State_Disconnect */
	uint32_t squelch_dis    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Squelch_Disable */
	uint32_t sop_reset      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SOP_Reset */
	uint32_t din_polarity   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_data_in_polarity */
	uint32_t r1             	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_RCVR_CONFIG ;
#endif

/*****************************************************************************************/
/* Loss_of_Frame_parameters                                                              */
/* This registers controls the Alpha and Delta values which indicate the number of corre */
/* ct/incorrect framing patterns required for assertion/de-assertion of the LOF alarm    */
/*****************************************************************************************/

#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_ALPHA_DEFAULT_VALUE             ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_ALPHA_DEFAULT_VALUE_RESET_VALUE ( 0x1 )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_DELTA_DEFAULT_VALUE             ( 0x5 )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_DELTA_DEFAULT_VALUE_RESET_VALUE ( 0x5 )


#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_OFFSET ( 0x00000008 )

#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_ADDRESS   	( GPON_RX_GENERAL_CONFIG_ADDRESS + GPON_RX_GENERAL_CONFIG_LOF_PARAMS_OFFSET )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_READ( r ) 	READ_32( ( GPON_RX_GENERAL_CONFIG_LOF_PARAMS_ADDRESS ), (r) )
#define GPON_RX_GENERAL_CONFIG_LOF_PARAMS_WRITE( v )	WRITE_32( ( GPON_RX_GENERAL_CONFIG_LOF_PARAMS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alpha_value */
	uint32_t alpha	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Delta_value */
	uint32_t delta	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_LOF_PARAMS ;
#else
typedef struct
{	uint32_t delta	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Delta_value */
	uint32_t alpha	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alpha_value */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_LOF_PARAMS ;
#endif

/*****************************************************************************************/
/* Random_Seed                                                                           */
/* This register contains a random 32 bit number which changes constantly                */
/*****************************************************************************************/

#define GPON_RX_GENERAL_CONFIG_RANDOMSD_RANDOMSD_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_GENERAL_CONFIG_RANDOMSD_RANDOMSD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_GENERAL_CONFIG_RANDOMSD_OFFSET ( 0x0000000C )

#define GPON_RX_GENERAL_CONFIG_RANDOMSD_ADDRESS   	( GPON_RX_GENERAL_CONFIG_ADDRESS + GPON_RX_GENERAL_CONFIG_RANDOMSD_OFFSET )
#define GPON_RX_GENERAL_CONFIG_RANDOMSD_READ( r ) 	READ_32( ( GPON_RX_GENERAL_CONFIG_RANDOMSD_ADDRESS ), (r) )
#define GPON_RX_GENERAL_CONFIG_RANDOMSD_WRITE( v )	WRITE_32( ( GPON_RX_GENERAL_CONFIG_RANDOMSD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Random_Seed */
	uint32_t randomsd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_RANDOMSD ;
#else
typedef struct
{	uint32_t randomsd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Random_Seed */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG_RANDOMSD ;
#endif

/*****************************************************************************************/
/* Interrupt_status_register                                                             */
/* This register contains the current active receiver  interrupts. Each asserted bit rep */
/* resents an active interrupt source. The inetrrupt remains active until the software c */
/* lears it by writing 1 to the corresponding bit. Writing 0 to any bit has no effect.   */
/* All the field in this register can be changed on-the-fly during operation.            */
/*****************************************************************************************/

#define GPON_RX_IRQ_GRXISR_R1_DEFAULT_VALUE                        ( 0x0 )
#define GPON_RX_IRQ_GRXISR_R1_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define GPON_RX_IRQ_GRXISR_TOD_NO_INTERRUPT_VALUE                  ( 0x0 )
#define GPON_RX_IRQ_GRXISR_TOD_NO_INTERRUPT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_IRQ_GRXISR_TOD_INTERRUPT_ASSERTED_VALUE            ( 0x1 )
#define GPON_RX_IRQ_GRXISR_FECCHNG_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXISR_FECCHNG_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXISR_FECCHNG_INTERRUPT_ASSERTED_VALUE        ( 0x1 )
#define GPON_RX_IRQ_GRXISR_LCDGCHNG_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_RX_IRQ_GRXISR_LCDGCHNG_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_IRQ_GRXISR_LCDGCHNG_INTERRUPT_ASSERTED_VALUE       ( 0x1 )
#define GPON_RX_IRQ_GRXISR_LOFCHNG_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXISR_LOFCHNG_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXISR_LOFCHNG_INTERRUPT_ASSERTED_VALUE        ( 0x1 )
#define GPON_RX_IRQ_GRXISR_ACCFIFO_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXISR_ACCFIFO_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXISR_ACCFIFO_INTERRUPT_ASSERTED_VALUE        ( 0x1 )
#define GPON_RX_IRQ_GRXISR_AES_NO_INTERRUPT_VALUE                  ( 0x0 )
#define GPON_RX_IRQ_GRXISR_AES_NO_INTERRUPT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_IRQ_GRXISR_AES_INTERRUPT_ASSERTED_VALUE            ( 0x1 )
#define GPON_RX_IRQ_GRXISR_TDMFIFO_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXISR_TDMFIFO_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXISR_TDMFIFO_INTERRUPT_ASSERTED_VALUE        ( 0x1 )
#define GPON_RX_IRQ_GRXISR_RXFIFO_NO_INTERRUPT_VALUE               ( 0x0 )
#define GPON_RX_IRQ_GRXISR_RXFIFO_NO_INTERRUPT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_RX_IRQ_GRXISR_RXFIFO_INTERRUPT_ASSERTED_VALUE         ( 0x1 )


#define GPON_RX_IRQ_GRXISR_OFFSET ( 0x00000000 )

#define GPON_RX_IRQ_GRXISR_ADDRESS   	( GPON_RX_IRQ_ADDRESS + GPON_RX_IRQ_GRXISR_OFFSET )
#define GPON_RX_IRQ_GRXISR_READ( r ) 	READ_32( ( GPON_RX_IRQ_GRXISR_ADDRESS ), (r) )
#define GPON_RX_IRQ_GRXISR_WRITE( v )	WRITE_32( ( GPON_RX_IRQ_GRXISR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TOD_update_IRQ */
	uint32_t tod     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_State_change_IRQ */
	uint32_t fecchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LCDG_state_change_IRQ */
	uint32_t lcdgchng	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOF_state_change_IRQ */
	uint32_t lofchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Access_FIFO_Full_IRQ */
	uint32_t accfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AES_Error_IRQ */
	uint32_t aes     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_FIFO_Full_IRQ */
	uint32_t tdmfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rx_FIFO_Full_IRQ */
	uint32_t rxfifo  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ_GRXISR ;
#else
typedef struct
{	uint32_t rxfifo  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rx_FIFO_Full_IRQ */
	uint32_t tdmfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_FIFO_Full_IRQ */
	uint32_t aes     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AES_Error_IRQ */
	uint32_t accfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Access_FIFO_Full_IRQ */
	uint32_t lofchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOF_state_change_IRQ */
	uint32_t lcdgchng	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LCDG_state_change_IRQ */
	uint32_t fecchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_State_change_IRQ */
	uint32_t tod     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TOD_update_IRQ */
	uint32_t r1      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ_GRXISR ;
#endif

/*****************************************************************************************/
/* Interrupt_enable_register                                                             */
/* This register provides an enable mask for each of the interrupt sources depicted in t */
/* he ISR register. Writing 1 to a bit in this register enables assertion of the IRQ lin */
/* e when the corresponding interrupt is active. Writing 0 to a bit in this register mas */
/* ks assertion of the IRQ line when the corresponding interrupt is active.  All the fie */
/* lds in this register can be changed on-the-fly during operation.                      */
/*****************************************************************************************/

#define GPON_RX_IRQ_GRXIER_R1_DEFAULT_VALUE                        ( 0x0 )
#define GPON_RX_IRQ_GRXIER_R1_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define GPON_RX_IRQ_GRXIER_TOD_IRQ_DISABLED_VALUE                  ( 0x0 )
#define GPON_RX_IRQ_GRXIER_TOD_IRQ_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_IRQ_GRXIER_TOD_IRQ_ENABLED_VALUE                   ( 0x1 )
#define GPON_RX_IRQ_GRXIER_FECCHNG_IRQ_DISABLED_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXIER_FECCHNG_IRQ_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXIER_FECCHNG_IRQ_ENABLED_VALUE               ( 0x1 )
#define GPON_RX_IRQ_GRXIER_LCDGCHNG_IRQ_DISABLED_VALUE             ( 0x0 )
#define GPON_RX_IRQ_GRXIER_LCDGCHNG_IRQ_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_IRQ_GRXIER_LCDGCHNG_IRQ_ENABLED_VALUE              ( 0x1 )
#define GPON_RX_IRQ_GRXIER_LOFCHNG_IRQ_DISABLED_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXIER_LOFCHNG_IRQ_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXIER_LOFCHNG_IRQ_ENABLED_VALUE               ( 0x1 )
#define GPON_RX_IRQ_GRXIER_ACCFIFO_IRQ_DISABLED_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXIER_ACCFIFO_IRQ_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXIER_ACCFIFO_IRQ_ENABLED_VALUE               ( 0x1 )
#define GPON_RX_IRQ_GRXIER_AES_IRQ_DISABLED_VALUE                  ( 0x0 )
#define GPON_RX_IRQ_GRXIER_AES_IRQ_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_IRQ_GRXIER_AES_IRQ_ENABLED_VALUE                   ( 0x1 )
#define GPON_RX_IRQ_GRXIER_TDMFIFO_IRQ_DISABLED_VALUE              ( 0x0 )
#define GPON_RX_IRQ_GRXIER_TDMFIFO_IRQ_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_IRQ_GRXIER_TDMFIFO_IRQ_ENABLED_VALUE               ( 0x1 )
#define GPON_RX_IRQ_GRXIER_RXFIFO_IRQ_DISABLED_VALUE               ( 0x0 )
#define GPON_RX_IRQ_GRXIER_RXFIFO_IRQ_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_RX_IRQ_GRXIER_RXFIFO_IRQ_ENABLED_VALUE                ( 0x1 )


#define GPON_RX_IRQ_GRXIER_OFFSET ( 0x00000004 )

#define GPON_RX_IRQ_GRXIER_ADDRESS   	( GPON_RX_IRQ_ADDRESS + GPON_RX_IRQ_GRXIER_OFFSET )
#define GPON_RX_IRQ_GRXIER_READ( r ) 	READ_32( ( GPON_RX_IRQ_GRXIER_ADDRESS ), (r) )
#define GPON_RX_IRQ_GRXIER_WRITE( v )	WRITE_32( ( GPON_RX_IRQ_GRXIER_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TOD_update_IRQ_mask */
	uint32_t tod     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_state_change_IRQ_mask */
	uint32_t fecchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LCDG_change_IRQ_mask */
	uint32_t lcdgchng	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOF_change_IRQ_mask */
	uint32_t lofchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Access_FIFO_Full_IRQ_mask */
	uint32_t accfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AES_Error_IRQ_mask */
	uint32_t aes     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_FIFO_Full_IRQ_mask */
	uint32_t tdmfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rx_FIFO_Full_IRQ_mask */
	uint32_t rxfifo  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ_GRXIER ;
#else
typedef struct
{	uint32_t rxfifo  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rx_FIFO_Full_IRQ_mask */
	uint32_t tdmfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_FIFO_Full_IRQ_mask */
	uint32_t aes     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AES_Error_IRQ_mask */
	uint32_t accfifo 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Access_FIFO_Full_IRQ_mask */
	uint32_t lofchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LOF_change_IRQ_mask */
	uint32_t lcdgchng	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LCDG_change_IRQ_mask */
	uint32_t fecchng 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_state_change_IRQ_mask */
	uint32_t tod     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TOD_update_IRQ_mask */
	uint32_t r1      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ_GRXIER ;
#endif

/*****************************************************************************************/
/* Interrupt_test_register                                                               */
/* This register enables testing by simulating interrupt sources. When the software sets */
/*  a bit in the ITR, the corresponding bit in the ISR shows an active interrupt. The in */
/* terrupt remains active untill software clears the bit in the ITR and the ISR.  All th */
/* e fields in this register can be changed on-the-fly during operation.                 */
/*****************************************************************************************/

#define GPON_RX_IRQ_GRXITR_R1_DEFAULT_VALUE                           ( 0x0 )
#define GPON_RX_IRQ_GRXITR_R1_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define GPON_RX_IRQ_GRXITR_IST_INTERRUPT_NOT_ACTIVE_VALUE             ( 0x0 )
#define GPON_RX_IRQ_GRXITR_IST_INTERRUPT_NOT_ACTIVE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_IRQ_GRXITR_IST_INTERRUPT_ACTIVE_VALUE                 ( 0x1 )


#define GPON_RX_IRQ_GRXITR_OFFSET ( 0x00000008 )

#define GPON_RX_IRQ_GRXITR_ADDRESS   	( GPON_RX_IRQ_ADDRESS + GPON_RX_IRQ_GRXITR_OFFSET )
#define GPON_RX_IRQ_GRXITR_READ( r ) 	READ_32( ( GPON_RX_IRQ_GRXITR_ADDRESS ), (r) )
#define GPON_RX_IRQ_GRXITR_WRITE( v )	WRITE_32( ( GPON_RX_IRQ_GRXITR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1 	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_simulation_test */
	uint32_t ist	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ_GRXITR ;
#else
typedef struct
{	uint32_t ist	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_simulation_test */
	uint32_t r1 	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ_GRXITR ;
#endif

/*****************************************************************************************/
/* ONU_ID_settings                                                                       */
/* Sets the ONU_ID for the ONU.  Two registers are provided, and each can be disabled in */
/* dependently.  The first register is used for the ONU_ID. The second register is used  */
/* for assigning the broadcast address.                                                  */
/*****************************************************************************************/

#define GPON_RX_PLOAM_ONU_ID_R1_DEFAULT_VALUE                         ( 0x0 )
#define GPON_RX_PLOAM_ONU_ID_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define GPON_RX_PLOAM_ONU_ID_DISABLE_ONU_ID_ENABLE_VALUE              ( 0x0 )
#define GPON_RX_PLOAM_ONU_ID_DISABLE_ONU_ID_DISABLE_VALUE             ( 0x1 )
#define GPON_RX_PLOAM_ONU_ID_DISABLE_ONU_ID_DISABLE_VALUE_RESET_VALUE ( 0x1 )
#define GPON_RX_PLOAM_ONU_ID_ONU_ID_DEFAULT_VALUE                     ( 0x0 )
#define GPON_RX_PLOAM_ONU_ID_ONU_ID_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )


#define GPON_RX_PLOAM_ONU_ID_OFFSET ( 0x00000000 )

#define GPON_RX_PLOAM_ONU_ID_ADDRESS        	( GPON_RX_PLOAM_ADDRESS + GPON_RX_PLOAM_ONU_ID_OFFSET )
#define GPON_RX_PLOAM_ONU_ID_READ_I( r, i ) 	READ_I_32( ( GPON_RX_PLOAM_ONU_ID_ADDRESS ), (i), (r) )
#define GPON_RX_PLOAM_ONU_ID_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_PLOAM_ONU_ID_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ONU_ID_Disable */
	uint32_t disable	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ONU_ID */
	uint32_t onu_id 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PLOAM_ONU_ID ;
#else
typedef struct
{	uint32_t onu_id 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ONU_ID */
	uint32_t disable	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ONU_ID_Disable */
	uint32_t r1     	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PLOAM_ONU_ID ;
#endif

/*****************************************************************************************/
/* PLOAM_Processor_Parameters                                                            */
/* This register allows setting of the PLOAM Processor operation parameters.             */
/*****************************************************************************************/

#define GPON_RX_PLOAM_PARAMS_R1_DEFAULT_VALUE                                 ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_R1_DEFAULT_VALUE_RESET_VALUE                     ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_FAPL_FORWARD_DISABLE_VALUE                       ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_FAPL_FORWARD_DISABLE_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_FAPL_FORWARD_ENABLE_VALUE                        ( 0x1 )
#define GPON_RX_PLOAM_PARAMS_IDLE_FILTER_IDLE_FILTER_DISABLE_VALUE            ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_IDLE_FILTER_IDLE_FILTER_ENABLE_VALUE             ( 0x1 )
#define GPON_RX_PLOAM_PARAMS_IDLE_FILTER_IDLE_FILTER_ENABLE_VALUE_RESET_VALUE ( 0x1 )
#define GPON_RX_PLOAM_PARAMS_CRC_OVERRD_CRC_ENABLE_VALUE                      ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_CRC_OVERRD_CRC_ENABLE_VALUE_RESET_VALUE          ( 0x0 )
#define GPON_RX_PLOAM_PARAMS_CRC_OVERRD_CRC_OVERRIDE_VALUE                    ( 0x1 )


#define GPON_RX_PLOAM_PARAMS_OFFSET ( 0x00000008 )

#define GPON_RX_PLOAM_PARAMS_ADDRESS   	( GPON_RX_PLOAM_ADDRESS + GPON_RX_PLOAM_PARAMS_OFFSET )
#define GPON_RX_PLOAM_PARAMS_READ( r ) 	READ_32( ( GPON_RX_PLOAM_PARAMS_ADDRESS ), (r) )
#define GPON_RX_PLOAM_PARAMS_WRITE( v )	WRITE_32( ( GPON_RX_PLOAM_PARAMS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* forward_all_ploam_messages */
	uint32_t fapl       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_filtering_enable */
	uint32_t idle_filter	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_Override */
	uint32_t crc_overrd 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PLOAM_PARAMS ;
#else
typedef struct
{	uint32_t crc_overrd 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_Override */
	uint32_t idle_filter	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_filtering_enable */
	uint32_t fapl       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* forward_all_ploam_messages */
	uint32_t r1         	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PLOAM_PARAMS ;
#endif

/*****************************************************************************************/
/* Ranging_Alloc_ID_Configuration                                                        */
/* Assigns Alloc-IDs used during ranging (first the broadcast Alloc-ID is assigned and t */
/* hen the ONU-ID is assigned). After ranging, this Alloc-ID is disabled.                */
/*****************************************************************************************/

#define GPON_RX_ALLOC_ID_RANG_ALC_ID_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_ALLOC_ID_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_ALLOC_ID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_ALLOC_ID_RANG_ALC_ID_OFFSET ( 0x00000000 )

#define GPON_RX_ALLOC_ID_RANG_ALC_ID_ADDRESS   	( GPON_RX_ALLOC_ID_ADDRESS + GPON_RX_ALLOC_ID_RANG_ALC_ID_OFFSET )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_READ( r ) 	READ_32( ( GPON_RX_ALLOC_ID_RANG_ALC_ID_ADDRESS ), (r) )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_WRITE( v )	WRITE_32( ( GPON_RX_ALLOC_ID_RANG_ALC_ID_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc-ID */
	uint32_t alloc_id	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_RANG_ALC_ID ;
#else
typedef struct
{	uint32_t alloc_id	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc-ID */
	uint32_t r1      	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_RANG_ALC_ID ;
#endif

/*****************************************************************************************/
/* Alloc_ID_Configuration                                                                */
/* 40 registers are provided to allow assignment of up to 40 Alloc-IDs per ONU.          */
/*****************************************************************************************/

#define GPON_RX_ALLOC_ID_ALC_ID_CFG_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_CFG_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_CFG_ALLOC_ID_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_CFG_ALLOC_ID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_ALLOC_ID_ALC_ID_CFG_OFFSET ( 0x00000004 )

#define GPON_RX_ALLOC_ID_ALC_ID_CFG_ADDRESS        	( GPON_RX_ALLOC_ID_ADDRESS + GPON_RX_ALLOC_ID_ALC_ID_CFG_OFFSET )
#define GPON_RX_ALLOC_ID_ALC_ID_CFG_READ_I( r, i ) 	READ_I_32( ( GPON_RX_ALLOC_ID_ALC_ID_CFG_ADDRESS ), (i), (r) )
#define GPON_RX_ALLOC_ID_ALC_ID_CFG_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_ALLOC_ID_ALC_ID_CFG_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID */
	uint32_t alloc_id	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_ALC_ID_CFG ;
#else
typedef struct
{	uint32_t alloc_id	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID */
	uint32_t r1      	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_ALC_ID_CFG ;
#endif

/*****************************************************************************************/
/* ranging_alloc_ID_enable                                                               */
/* This register is used to enable/disable the ranging Alloc-ID comprator                */
/*****************************************************************************************/

#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_RESERVED1_RESERVED_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_RESERVED1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_ALLOC_EN_DISABLE_VALUE               ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_ALLOC_EN_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_ALLOC_EN_ENABLE_VALUE                ( 0x1 )


#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_OFFSET ( 0x000000A4 )

#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_ADDRESS   	( GPON_RX_ALLOC_ID_ADDRESS + GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_OFFSET )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_READ( r ) 	READ_32( ( GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_ADDRESS ), (r) )
#define GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_WRITE( v )	WRITE_32( ( GPON_RX_ALLOC_ID_RANG_ALC_ID_EN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc_ID_enable */
	uint32_t alloc_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_RANG_ALC_ID_EN ;
#else
typedef struct
{	uint32_t alloc_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc_ID_enable */
	uint32_t reserved1	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_RANG_ALC_ID_EN ;
#endif

/*****************************************************************************************/
/* Alloc_ID_Enable                                                                       */
/* This register is used to enable/disable the Alloc-ID comprators                       */
/*****************************************************************************************/

#define GPON_RX_ALLOC_ID_ALC_ID_EN_R1_DEFAULT_VALUE                            ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_R1_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_ALLOC_EN_ALLOC_ID_DISABLE_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_ALLOC_EN_ALLOC_ID_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_ALLOC_EN_ALLOC_ID_ENABLE_VALUE              ( 0x1 )


#define GPON_RX_ALLOC_ID_ALC_ID_EN_OFFSET ( 0x000000A8 )

#define GPON_RX_ALLOC_ID_ALC_ID_EN_ADDRESS        	( GPON_RX_ALLOC_ID_ADDRESS + GPON_RX_ALLOC_ID_ALC_ID_EN_OFFSET )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_READ_I( r, i ) 	READ_I_32( ( GPON_RX_ALLOC_ID_ALC_ID_EN_ADDRESS ), (i), (r) )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_ALLOC_ID_ALC_ID_EN_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc-ID_Enable */
	uint32_t alloc_en	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_ALC_ID_EN ;
#else
typedef struct
{	uint32_t alloc_en	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc-ID_Enable */
	uint32_t r1      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_ALC_ID_EN ;
#endif

/*****************************************************************************************/
/* alloc_id_to_TCONT_association                                                         */
/* A vector that defines which TCONT is associated to each one of the ALLOC_ID which are */
/*  configured in the ALLOC_ID CONF register.  For each ALLOC_ID, there are 6 bits dedic */
/* ated for configuring the associated queue number. The least significant byte in the f */
/* irst register defines the alloc-id for tcont0, while the most significant byte of the */
/*  last register in the array defines the alloc-id for tcont 39                         */
/*****************************************************************************************/

#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R3_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R3_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A3_TNUM_MIN_VALUE_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A3_TNUM_DEFAULT_VALUE             ( 0x3 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A3_TNUM_DEFAULT_VALUE_RESET_VALUE ( 0x3 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A3_TNUM_MAX_VALUE_VALUE           ( 0x27 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R2_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A2_TNUM_MIN_VALUE_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A2_TNUM_DEFAULT_VALUE             ( 0x2 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A2_TNUM_DEFAULT_VALUE_RESET_VALUE ( 0x2 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A2_TNUM_MAX_VALUE_VALUE           ( 0x27 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R1_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A1_TNUM_MIN_VALUE_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A1_TNUM_DEFAULT_VALUE             ( 0x1 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A1_TNUM_DEFAULT_VALUE_RESET_VALUE ( 0x1 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A1_TNUM_MAX_VALUE_VALUE           ( 0x27 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R0_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_R0_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A0_TNUM_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A0_TNUM_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A0_TNUM_MIN_VALUE_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_A0_TNUM_MAX_VALUE_VALUE           ( 0x27 )


#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_OFFSET ( 0x000000C0 )

#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_ADDRESS        	( GPON_RX_ALLOC_ID_ADDRESS + GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_OFFSET )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_READ_I( r, i ) 	READ_I_32( ( GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_ADDRESS ), (i), (r) )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r3     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_3_TCONT_number */
	uint32_t a3_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_2_TCONT_number */
	uint32_t a2_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_1_TCONT_number */
	uint32_t a1_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_0_TCONT_number */
	uint32_t a0_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC ;
#else
typedef struct
{	uint32_t a0_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_0_TCONT_number */
	uint32_t r0     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t a1_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_1_TCONT_number */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t a2_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_2_TCONT_number */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t a3_tnum	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_ID_3_TCONT_number */
	uint32_t r3     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC ;
#endif

/*****************************************************************************************/
/* Bandwidth_counters_association                                                        */
/* set of 4 counters which accumulate the accesses of a certain TCONT.  Each counter can */
/*  be associated with any of the 40 TCONTs.                                             */
/*****************************************************************************************/

#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R4_DEFAULT_VALUE                       ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R4_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT3_ASSOC_TCONT_NUM_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT3_ASSOC_TCONT_NUM_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R3_DEFAULT_VALUE                       ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R3_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT2_ASSOC_TCONT_NUM_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT2_ASSOC_TCONT_NUM_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R2_DEFAULT_VALUE                       ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R2_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT1_ASSOC_TCONT_NUM_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT1_ASSOC_TCONT_NUM_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R1_DEFAULT_VALUE                       ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT0_ASSOC_TCONT_NUM_VALUE             ( 0x0 )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_CNT0_ASSOC_TCONT_NUM_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_OFFSET ( 0x000000E8 )

#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_ADDRESS   	( GPON_RX_ALLOC_ID_ADDRESS + GPON_RX_ALLOC_ID_BW_CNT_ASSOC_OFFSET )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_READ( r ) 	READ_32( ( GPON_RX_ALLOC_ID_BW_CNT_ASSOC_ADDRESS ), (r) )
#define GPON_RX_ALLOC_ID_BW_CNT_ASSOC_WRITE( v )	WRITE_32( ( GPON_RX_ALLOC_ID_BW_CNT_ASSOC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r4        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt3_assoc */
	uint32_t cnt3_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt2_assoc */
	uint32_t cnt2_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt1_assoc */
	uint32_t cnt1_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt0_assoc */
	uint32_t cnt0_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_BW_CNT_ASSOC ;
#else
typedef struct
{	uint32_t cnt0_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt0_assoc */
	uint32_t r1        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t cnt1_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt1_assoc */
	uint32_t r2        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t cnt2_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt2_assoc */
	uint32_t r3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t cnt3_assoc	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cnt3_assoc */
	uint32_t r4        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID_BW_CNT_ASSOC ;
#endif

/*****************************************************************************************/
/* clock_8KHz_phase_lock_mechanism                                                       */
/* This register provide control over the 8KHz clock phase lock mechanism.  It enables/d */
/* isables the phase lock mechanism and controls the desired phase difference between th */
/* e output free-running 8KHz clock and the input frames stream.  When the desired phase */
/*  difference is 0, the rising edge of the output 8KHz clock will be synced to the fram */
/* e start.  The desired phase difference is in resolution of GPON clock cycles.  If one */
/*  will configure the phase difference to be 1, the rising edge of the clock will be on */
/* e GPON clock cycle before the frame start.                                            */
/*****************************************************************************************/

#define GPON_RX_CLK_8KHZ_CLK8KCONF_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSLOCKDIS_ENABLE_VALUE             ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSLOCKDIS_ENABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSLOCKDIS_DISABLE_VALUE            ( 0x1 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSDIFF_MIN_VALUE_VALUE             ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSDIFF_DEFAULT_VALUE               ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSDIFF_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_PHSDIFF_MAX_VALUE_VALUE             ( 0x4BEF )


#define GPON_RX_CLK_8KHZ_CLK8KCONF_OFFSET ( 0x00000000 )

#define GPON_RX_CLK_8KHZ_CLK8KCONF_ADDRESS   	( GPON_RX_CLK_8KHZ_ADDRESS + GPON_RX_CLK_8KHZ_CLK8KCONF_OFFSET )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_READ( r ) 	READ_32( ( GPON_RX_CLK_8KHZ_CLK8KCONF_ADDRESS ), (r) )
#define GPON_RX_CLK_8KHZ_CLK8KCONF_WRITE( v )	WRITE_32( ( GPON_RX_CLK_8KHZ_CLK8KCONF_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1        	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Phase_lock_mechanism_disable */
	uint32_t phslockdis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Phase_difference */
	uint32_t phsdiff   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_CLK_8KHZ_CLK8KCONF ;
#else
typedef struct
{	uint32_t phsdiff   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Phase_difference */
	uint32_t phslockdis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Phase_lock_mechanism_disable */
	uint32_t r1        	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_CLK_8KHZ_CLK8KCONF ;
#endif

/*****************************************************************************************/
/* congestion_thresholds                                                                 */
/* into congestion and out of congestion thresholds.    The thresholds are in number of  */
/* RX fifo entries.    Possible values: 0 - 63 decimal    (each entry in the FIFO is of  */
/* 8 bytes)                                                                              */
/*****************************************************************************************/

#define GPON_RX_CONGESTION_THRESH_R2_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_R2_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_OUTOF_MIN_VALUE              ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_OUTOF_MIN_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_OUTOF_MAX_VALUE              ( 0x3F )
#define GPON_RX_CONGESTION_THRESH_R1_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_R1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_INTO_MIN_VALUE               ( 0x0 )
#define GPON_RX_CONGESTION_THRESH_INTO_MAX_VALUE               ( 0x3F )
#define GPON_RX_CONGESTION_THRESH_INTO_MAX_VALUE_RESET_VALUE   ( 0x3F )


#define GPON_RX_CONGESTION_THRESH_OFFSET ( 0x00000000 )

#define GPON_RX_CONGESTION_THRESH_ADDRESS   	( GPON_RX_CONGESTION_ADDRESS + GPON_RX_CONGESTION_THRESH_OFFSET )
#define GPON_RX_CONGESTION_THRESH_READ( r ) 	READ_32( ( GPON_RX_CONGESTION_THRESH_ADDRESS ), (r) )
#define GPON_RX_CONGESTION_THRESH_WRITE( v )	WRITE_32( ( GPON_RX_CONGESTION_THRESH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r2   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* out_of_congestion */
	uint32_t outof	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* into_congestion */
	uint32_t into 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_CONGESTION_THRESH ;
#else
typedef struct
{	uint32_t into 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* into_congestion */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t outof	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* out_of_congestion */
	uint32_t r2   	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_CONGESTION_THRESH ;
#endif

/*****************************************************************************************/
/* PortID_Full_Configuration                                                             */
/* These 32 registers assign 32 Port-IDs ( from the possible 4096) to the ONU. Each Port */
/* -ID has a set of parameters associated with it. The number of the register is the Flo */
/* w-ID the Port-ID is assigned to. Register 31 also has a mask assigned with it (see re */
/* gister PORTIDMSK). These registers along with the following 224 registers, enable def */
/* ining up to 256 different port-ids.                                                   */
/*****************************************************************************************/

#define GPON_RX_PORT_ID_FULLCFG_R1_DEFAULT_VALUE                         ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_PRIORITY_LOW_PRIORITY_VALUE              ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_PRIORITY_LOW_PRIORITY_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_PRIORITY_HIGH_PRIORITY_VALUE             ( 0x1 )
#define GPON_RX_PORT_ID_FULLCFG_PRIORITY_PLOAM_VALUE                     ( 0x2 )
#define GPON_RX_PORT_ID_FULLCFG_PRIORITY_OMCI_PRIORITY_VALUE             ( 0x3 )
#define GPON_RX_PORT_ID_FULLCFG_TYPE_ETHERNET_FLOW_VALUE                 ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_TYPE_ETHERNET_FLOW_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_TYPE_TDM_FLOW_VALUE                      ( 0x1 )
#define GPON_RX_PORT_ID_FULLCFG_ENCRYPT_PLAINTEXT_FLOW_VALUE             ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_ENCRYPT_PLAINTEXT_FLOW_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_ENCRYPT_ENCRYPTED_FLOW_VALUE             ( 0x1 )
#define GPON_RX_PORT_ID_FULLCFG_PORTID_DEFAULT_VALUE                     ( 0x0 )
#define GPON_RX_PORT_ID_FULLCFG_PORTID_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )


#define GPON_RX_PORT_ID_FULLCFG_OFFSET ( 0x00000000 )

#define GPON_RX_PORT_ID_FULLCFG_ADDRESS        	( GPON_RX_PORT_ID_ADDRESS + GPON_RX_PORT_ID_FULLCFG_OFFSET )
#define GPON_RX_PORT_ID_FULLCFG_READ_I( r, i ) 	READ_I_32( ( GPON_RX_PORT_ID_FULLCFG_ADDRESS ), (i), (r) )
#define GPON_RX_PORT_ID_FULLCFG_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_PORT_ID_FULLCFG_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_Priority */
	uint32_t priority	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_Type */
	uint32_t type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Encryption_State */
	uint32_t encrypt 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID */
	uint32_t portid  	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_FULLCFG ;
#else
typedef struct
{	uint32_t portid  	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID */
	uint32_t encrypt 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Encryption_State */
	uint32_t type    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_Type */
	uint32_t priority	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_Priority */
	uint32_t r1      	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_FULLCFG ;
#endif

/*****************************************************************************************/
/* PortID_Configuration                                                                  */
/* These 224 registers along with the former 32, assign 256 Port-IDs ( from the possible */
/*  4096) to the ONU. Each Port-ID has a set of parameters associated with it. While the */
/*  former 32 are fully configurable, these 224 registers has strict parameters: the typ */
/* e is always gem and the priority is low.                                              */
/*****************************************************************************************/

#define GPON_RX_PORT_ID_CFG_R1_DEFAULT_VALUE                         ( 0x0 )
#define GPON_RX_PORT_ID_CFG_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define GPON_RX_PORT_ID_CFG_ENCRYPT_PLAINTEXT_FLOW_VALUE             ( 0x0 )
#define GPON_RX_PORT_ID_CFG_ENCRYPT_PLAINTEXT_FLOW_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_PORT_ID_CFG_ENCRYPT_ENCRYPTED_FLOW_VALUE             ( 0x1 )
#define GPON_RX_PORT_ID_CFG_PORTID_DEFAULT_VALUE                     ( 0x0 )
#define GPON_RX_PORT_ID_CFG_PORTID_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )


#define GPON_RX_PORT_ID_CFG_OFFSET ( 0x00000080 )

#define GPON_RX_PORT_ID_CFG_ADDRESS        	( GPON_RX_PORT_ID_ADDRESS + GPON_RX_PORT_ID_CFG_OFFSET )
#define GPON_RX_PORT_ID_CFG_READ_I( r, i ) 	READ_I_32( ( GPON_RX_PORT_ID_CFG_ADDRESS ), (i), (r) )
#define GPON_RX_PORT_ID_CFG_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_PORT_ID_CFG_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Encryption_State */
	uint32_t encrypt	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID */
	uint32_t portid 	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_CFG ;
#else
typedef struct
{	uint32_t portid 	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID */
	uint32_t encrypt	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Encryption_State */
	uint32_t r1     	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_CFG ;
#endif

/*****************************************************************************************/
/* PortID_Disable                                                                        */
/* These registers allow disabling flows. The first allows disabling flows 0 to 31. The  */
/* second allows disabling flows 32-63, and so on.                                       */
/*****************************************************************************************/

#define GPON_RX_PORT_ID_DISABLE_PORTIDDIS_ENABLE_VALUE              ( 0x0 )
#define GPON_RX_PORT_ID_DISABLE_PORTIDDIS_DISABLE_VALUE             ( 0x1 )
#define GPON_RX_PORT_ID_DISABLE_PORTIDDIS_DEFAULT_VALUE             ( 0xFFFFFFFF )
#define GPON_RX_PORT_ID_DISABLE_PORTIDDIS_DEFAULT_VALUE_RESET_VALUE ( 0xFFFFFFFF )


#define GPON_RX_PORT_ID_DISABLE_OFFSET ( 0x00000400 )

#define GPON_RX_PORT_ID_DISABLE_ADDRESS        	( GPON_RX_PORT_ID_ADDRESS + GPON_RX_PORT_ID_DISABLE_OFFSET )
#define GPON_RX_PORT_ID_DISABLE_READ_I( r, i ) 	READ_I_32( ( GPON_RX_PORT_ID_DISABLE_ADDRESS ), (i), (r) )
#define GPON_RX_PORT_ID_DISABLE_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_PORT_ID_DISABLE_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Port-ID_Disable */
	uint32_t portiddis	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_DISABLE ;
#else
typedef struct
{	uint32_t portiddis	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID_Disable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_DISABLE ;
#endif

/*****************************************************************************************/
/* PortID_Mask                                                                           */
/* This registers allows Flow-ID #31 to contains multiple Port-IDs by masking several (o */
/* r all) bits of the Port-ID field before comparing it                                  */
/*****************************************************************************************/

#define GPON_RX_PORT_ID_MASK_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_RX_PORT_ID_MASK_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_RX_PORT_ID_MASK_PORTIDMSK_DEFAULT_VALUE             ( 0xFFF )
#define GPON_RX_PORT_ID_MASK_PORTIDMSK_DEFAULT_VALUE_RESET_VALUE ( 0xFFF )


#define GPON_RX_PORT_ID_MASK_OFFSET ( 0x00000420 )

#define GPON_RX_PORT_ID_MASK_ADDRESS   	( GPON_RX_PORT_ID_ADDRESS + GPON_RX_PORT_ID_MASK_OFFSET )
#define GPON_RX_PORT_ID_MASK_READ( r ) 	READ_32( ( GPON_RX_PORT_ID_MASK_ADDRESS ), (r) )
#define GPON_RX_PORT_ID_MASK_WRITE( v )	WRITE_32( ( GPON_RX_PORT_ID_MASK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID_Mask */
	uint32_t portidmsk	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_MASK ;
#else
typedef struct
{	uint32_t portidmsk	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Port-ID_Mask */
	uint32_t r1       	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_MASK ;
#endif

/*****************************************************************************************/
/* Last_Fragment_Indication_Mask                                                         */
/* The mask indicates which of the 8 possible PTI codepoints indicate that the fragment  */
/* contains end of packet                                                                */
/*****************************************************************************************/

#define GPON_RX_PORT_ID_LASTIND_R1_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_PORT_ID_LASTIND_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_PORT_ID_LASTIND_PTILAST_DEFAULT_VALUE             ( 0xAA )
#define GPON_RX_PORT_ID_LASTIND_PTILAST_DEFAULT_VALUE_RESET_VALUE ( 0xAA )


#define GPON_RX_PORT_ID_LASTIND_OFFSET ( 0x00000424 )

#define GPON_RX_PORT_ID_LASTIND_ADDRESS   	( GPON_RX_PORT_ID_ADDRESS + GPON_RX_PORT_ID_LASTIND_OFFSET )
#define GPON_RX_PORT_ID_LASTIND_READ( r ) 	READ_32( ( GPON_RX_PORT_ID_LASTIND_ADDRESS ), (r) )
#define GPON_RX_PORT_ID_LASTIND_WRITE( v )	WRITE_32( ( GPON_RX_PORT_ID_LASTIND_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PTI_Last_Indication */
	uint32_t ptilast	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_LASTIND ;
#else
typedef struct
{	uint32_t ptilast	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PTI_Last_Indication */
	uint32_t r1     	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID_LASTIND ;
#endif

/*****************************************************************************************/
/* Superframe_Counter                                                                    */
/* Shows the value of the received superframe counter                                    */
/*****************************************************************************************/

#define GPON_RX_ENCRYPTION_SF_CNTR_R1_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_ENCRYPTION_SF_CNTR_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_ENCRYPTION_SF_CNTR_SF_CNTR_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_ENCRYPTION_SF_CNTR_SF_CNTR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_ENCRYPTION_SF_CNTR_OFFSET ( 0x00000000 )

#define GPON_RX_ENCRYPTION_SF_CNTR_ADDRESS   	( GPON_RX_ENCRYPTION_ADDRESS + GPON_RX_ENCRYPTION_SF_CNTR_OFFSET )
#define GPON_RX_ENCRYPTION_SF_CNTR_READ( r ) 	READ_32( ( GPON_RX_ENCRYPTION_SF_CNTR_ADDRESS ), (r) )
#define GPON_RX_ENCRYPTION_SF_CNTR_WRITE( v )	WRITE_32( ( GPON_RX_ENCRYPTION_SF_CNTR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Superframe_Counter */
	uint32_t sf_cntr	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION_SF_CNTR ;
#else
typedef struct
{	uint32_t sf_cntr	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Superframe_Counter */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION_SF_CNTR ;
#endif

/*****************************************************************************************/
/* Decryption_Key                                                                        */
/* Sets the value of the 128 bit decryption key. Array of 4 32 bir registers. Registr 0  */
/* in the array sets the MSB, register 3 sets the LSB.   These registers should not be c */
/* hanged while waiting for a key-switch (the ARM bit in the SWITCH_TIME register is set */
/* ).                                                                                    */
/*****************************************************************************************/

#define GPON_RX_ENCRYPTION_KEY_KEY_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_ENCRYPTION_KEY_KEY_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_ENCRYPTION_KEY_OFFSET ( 0x00000004 )

#define GPON_RX_ENCRYPTION_KEY_ADDRESS        	( GPON_RX_ENCRYPTION_ADDRESS + GPON_RX_ENCRYPTION_KEY_OFFSET )
#define GPON_RX_ENCRYPTION_KEY_READ_I( r, i ) 	READ_I_32( ( GPON_RX_ENCRYPTION_KEY_ADDRESS ), (i), (r) )
#define GPON_RX_ENCRYPTION_KEY_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_ENCRYPTION_KEY_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Key */
	uint32_t key	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION_KEY ;
#else
typedef struct
{	uint32_t key	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Key */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION_KEY ;
#endif

/*****************************************************************************************/
/* Key_Switch_Time                                                                       */
/* Sets the superframe counter value at which the new key is put to use                  */
/*****************************************************************************************/

#define GPON_RX_ENCRYPTION_SWITCH_TIME_R1_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_ARM_NOT_ARMED_VALUE               ( 0x0 )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_ARM_NOT_ARMED_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_ARM_ARM_MECHANISM_VALUE           ( 0x1 )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_SW_TIME_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_SW_TIME_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_ENCRYPTION_SWITCH_TIME_OFFSET ( 0x00000014 )

#define GPON_RX_ENCRYPTION_SWITCH_TIME_ADDRESS   	( GPON_RX_ENCRYPTION_ADDRESS + GPON_RX_ENCRYPTION_SWITCH_TIME_OFFSET )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_READ( r ) 	READ_32( ( GPON_RX_ENCRYPTION_SWITCH_TIME_ADDRESS ), (r) )
#define GPON_RX_ENCRYPTION_SWITCH_TIME_WRITE( v )	WRITE_32( ( GPON_RX_ENCRYPTION_SWITCH_TIME_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Switch_mechanism_arm */
	uint32_t arm    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Switch_Time */
	uint32_t sw_time	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION_SWITCH_TIME ;
#else
typedef struct
{	uint32_t sw_time	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Switch_Time */
	uint32_t arm    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Switch_mechanism_arm */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION_SWITCH_TIME ;
#endif

/*****************************************************************************************/
/* tod_update_time                                                                       */
/* The update mechanism of the TOD clock counter is similar to the AES key switch mechan */
/* ism. The SW indicates the frame number in which there will be update, the update valu */
/* e and assert ARM bit. The HW will update the TOD accordingly. This register is settin */
/* g the frame number in which the update will take place.                               */
/*****************************************************************************************/

#define GPON_RX_AMD2_TOD_SF_UP_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_RX_AMD2_TOD_SF_UP_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_RX_AMD2_TOD_SF_UP_UP_SF_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_AMD2_TOD_SF_UP_UP_SF_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_AMD2_TOD_SF_UP_OFFSET ( 0x00000000 )

#define GPON_RX_AMD2_TOD_SF_UP_ADDRESS   	( GPON_RX_AMD2_ADDRESS + GPON_RX_AMD2_TOD_SF_UP_OFFSET )
#define GPON_RX_AMD2_TOD_SF_UP_READ( r ) 	READ_32( ( GPON_RX_AMD2_TOD_SF_UP_ADDRESS ), (r) )
#define GPON_RX_AMD2_TOD_SF_UP_WRITE( v )	WRITE_32( ( GPON_RX_AMD2_TOD_SF_UP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* update_sf */
	uint32_t up_sf	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_SF_UP ;
#else
typedef struct
{	uint32_t up_sf	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* update_sf */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_SF_UP ;
#endif

/*****************************************************************************************/
/* tod_update_val                                                                        */
/* This 2 registers hold the value of the TOD which the TOD counter should be updated to */
/* . The 30 lsb hold the nano seconds value and the 34 msb hold seconds value.  The firs */
/* t register in the array is the lsb.                                                   */
/*****************************************************************************************/

#define GPON_RX_AMD2_TOD_UP_VAL_TOD_VAL_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_AMD2_TOD_UP_VAL_TOD_VAL_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_AMD2_TOD_UP_VAL_OFFSET ( 0x00000004 )

#define GPON_RX_AMD2_TOD_UP_VAL_ADDRESS        	( GPON_RX_AMD2_ADDRESS + GPON_RX_AMD2_TOD_UP_VAL_OFFSET )
#define GPON_RX_AMD2_TOD_UP_VAL_READ_I( r, i ) 	READ_I_32( ( GPON_RX_AMD2_TOD_UP_VAL_ADDRESS ), (i), (r) )
#define GPON_RX_AMD2_TOD_UP_VAL_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_AMD2_TOD_UP_VAL_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* tod_val */
	uint32_t tod_val	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_UP_VAL ;
#else
typedef struct
{	uint32_t tod_val	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tod_val */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_UP_VAL ;
#endif

/*****************************************************************************************/
/* tod_update_arm                                                                        */
/* The arm bit is used by the SW for indicating the update values are valid. The enable  */
/* bit is used to disable an update which is already armed.                              */
/*****************************************************************************************/

#define GPON_RX_AMD2_TOD_ARM_R1_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_AMD2_TOD_ARM_R1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_AMD2_TOD_ARM_EN_DISABLE_VALUE             ( 0x0 )
#define GPON_RX_AMD2_TOD_ARM_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_AMD2_TOD_ARM_EN_ENABLE_VALUE              ( 0x1 )
#define GPON_RX_AMD2_TOD_ARM_ARM_SET_VALUE                ( 0x0 )
#define GPON_RX_AMD2_TOD_ARM_ARM_SET_VALUE_RESET_VALUE    ( 0x0 )


#define GPON_RX_AMD2_TOD_ARM_OFFSET ( 0x0000000C )

#define GPON_RX_AMD2_TOD_ARM_ADDRESS   	( GPON_RX_AMD2_ADDRESS + GPON_RX_AMD2_TOD_ARM_OFFSET )
#define GPON_RX_AMD2_TOD_ARM_READ( r ) 	READ_32( ( GPON_RX_AMD2_TOD_ARM_ADDRESS ), (r) )
#define GPON_RX_AMD2_TOD_ARM_WRITE( v )	WRITE_32( ( GPON_RX_AMD2_TOD_ARM_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1 	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* update_en */
	uint32_t en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* arm */
	uint32_t arm	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_ARM ;
#else
typedef struct
{	uint32_t arm	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* arm */
	uint32_t en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* update_en */
	uint32_t r1 	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_ARM ;
#endif

/*****************************************************************************************/
/* tod_clocks_in_sec                                                                     */
/* The TOD counter counts GPON clock cycles. This register holds the number of GPON cloc */
/* k cycles in one second - 1.  When the Tod counter reaches this value it will add 1 to */
/*  the TOD seconds counter and will generate 1PPs clock pulse.                          */
/*****************************************************************************************/

#define GPON_RX_AMD2_TOD_CYC_IN_SEC_R1_DEAULT_VALUE                      ( 0x0 )
#define GPON_RX_AMD2_TOD_CYC_IN_SEC_R1_DEAULT_VALUE_RESET_VALUE          ( 0x0 )
#define GPON_RX_AMD2_TOD_CYC_IN_SEC_CYC_IN_SEC_DEFAULT_VALUE             ( 0x9450C00 )
#define GPON_RX_AMD2_TOD_CYC_IN_SEC_CYC_IN_SEC_DEFAULT_VALUE_RESET_VALUE ( 0x9450C00 )


#define GPON_RX_AMD2_TOD_CYC_IN_SEC_OFFSET ( 0x00000014 )

#define GPON_RX_AMD2_TOD_CYC_IN_SEC_ADDRESS   	( GPON_RX_AMD2_ADDRESS + GPON_RX_AMD2_TOD_CYC_IN_SEC_OFFSET )
#define GPON_RX_AMD2_TOD_CYC_IN_SEC_READ( r ) 	READ_32( ( GPON_RX_AMD2_TOD_CYC_IN_SEC_ADDRESS ), (r) )
#define GPON_RX_AMD2_TOD_CYC_IN_SEC_WRITE( v )	WRITE_32( ( GPON_RX_AMD2_TOD_CYC_IN_SEC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cycles_in_sec */
	uint32_t cyc_in_sec	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_CYC_IN_SEC ;
#else
typedef struct
{	uint32_t cyc_in_sec	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cycles_in_sec */
	uint32_t r1        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_CYC_IN_SEC ;
#endif

/*****************************************************************************************/
/* tod_opps_duty_cycle                                                                   */
/* this register holds the number of GPON clock cycles in which the 1pps clock will be a */
/* sserted high. The clock will be asserted low for:  cycles_in_se - duty_cycle.    for  */
/* cycles_in_sec description see previos register                                        */
/*****************************************************************************************/

#define GPON_RX_AMD2_TOD_OPPS_DUTY_OPPS_EN_DISABLE_VALUE                ( 0x0 )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_OPPS_EN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_OPPS_EN_ENABLE_VALUE                 ( 0x1 )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_R1_DEFAULT_VALUE                     ( 0x0 )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_DUTY_CYCLE_DEFAULT_VALUE             ( 0x76A700 )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_DUTY_CYCLE_DEFAULT_VALUE_RESET_VALUE ( 0x76A700 )


#define GPON_RX_AMD2_TOD_OPPS_DUTY_OFFSET ( 0x00000018 )

#define GPON_RX_AMD2_TOD_OPPS_DUTY_ADDRESS   	( GPON_RX_AMD2_ADDRESS + GPON_RX_AMD2_TOD_OPPS_DUTY_OFFSET )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_READ( r ) 	READ_32( ( GPON_RX_AMD2_TOD_OPPS_DUTY_ADDRESS ), (r) )
#define GPON_RX_AMD2_TOD_OPPS_DUTY_WRITE( v )	WRITE_32( ( GPON_RX_AMD2_TOD_OPPS_DUTY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* opps_en */
	uint32_t opps_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* duty_cycle */
	uint32_t duty_cycle	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_OPPS_DUTY ;
#else
typedef struct
{	uint32_t duty_cycle	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* duty_cycle */
	uint32_t r1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t opps_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* opps_en */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2_TOD_OPPS_DUTY ;
#endif

/*****************************************************************************************/
/* CRC_Errors_in_the_US_BW_Map_field                                                     */
/* Counts the number of CRC errors in the US BW Map field                                */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_BWMAPERR_BWMAPERR_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_BWMAPERR_BWMAPERR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_BWMAPERR_OFFSET ( 0x00000000 )

#define GPON_RX_PM_COUNTER_BWMAPERR_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_BWMAPERR_OFFSET )
#define GPON_RX_PM_COUNTER_BWMAPERR_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_BWMAPERR_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_BWMAPERR_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_BWMAPERR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* US_BW_Map_CRC_Errors */
	uint32_t bwmaperr	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BWMAPERR ;
#else
typedef struct
{	uint32_t bwmaperr	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* US_BW_Map_CRC_Errors */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BWMAPERR ;
#endif

/*****************************************************************************************/
/* CRC_Errors_in_PLOAM_field                                                             */
/* Counts the number of CRC erros in the PLOAM field                                     */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_PLOAMERR_PLOAMERR_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_PLOAMERR_PLOAMERR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_PLOAMERR_OFFSET ( 0x00000004 )

#define GPON_RX_PM_COUNTER_PLOAMERR_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_PLOAMERR_OFFSET )
#define GPON_RX_PM_COUNTER_PLOAMERR_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_PLOAMERR_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_PLOAMERR_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_PLOAMERR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PLOAM_CRC_Errors */
	uint32_t ploamerr	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLOAMERR ;
#else
typedef struct
{	uint32_t ploamerr	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_CRC_Errors */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLOAMERR ;
#endif

/*****************************************************************************************/
/* CRC_Errors_in_Plend_field                                                             */
/* Counts the number of CRC Errors in the Plend field                                    */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_PLENDERR_PLENDERR_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_PLENDERR_PLENDERR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_PLENDERR_OFFSET ( 0x00000008 )

#define GPON_RX_PM_COUNTER_PLENDERR_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_PLENDERR_OFFSET )
#define GPON_RX_PM_COUNTER_PLENDERR_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_PLENDERR_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_PLENDERR_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_PLENDERR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Plend_CRC_Errors */
	uint32_t plenderr	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLENDERR ;
#else
typedef struct
{	uint32_t plenderr	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Plend_CRC_Errors */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLENDERR ;
#endif

/*****************************************************************************************/
/* Superframe_counter_mismatch_counter                                                   */
/* Counts the number of invalid (non-consecutive) superframe counter values              */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_SFMISMATCH_SFMISMATCH_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_SFMISMATCH_SFMISMATCH_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_SFMISMATCH_OFFSET ( 0x0000000C )

#define GPON_RX_PM_COUNTER_SFMISMATCH_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_SFMISMATCH_OFFSET )
#define GPON_RX_PM_COUNTER_SFMISMATCH_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_SFMISMATCH_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_SFMISMATCH_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_SFMISMATCH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Superframe_counter_mismatches */
	uint32_t sfmismatch	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_SFMISMATCH ;
#else
typedef struct
{	uint32_t sfmismatch	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Superframe_counter_mismatches */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_SFMISMATCH ;
#endif

/*****************************************************************************************/
/* BIP_Error_Counter                                                                     */
/* Counts the number of BIP errors detected since the counter was last read              */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_BIP_BIP_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_BIP_BIP_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_BIP_OFFSET ( 0x00000010 )

#define GPON_RX_PM_COUNTER_BIP_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_BIP_OFFSET )
#define GPON_RX_PM_COUNTER_BIP_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_BIP_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_BIP_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_BIP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* BIP_errors */
	uint32_t bip	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BIP ;
#else
typedef struct
{	uint32_t bip	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP_errors */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BIP ;
#endif

/*****************************************************************************************/
/* Non_idle_GEM_fragments_received                                                       */
/* Counts the total number of non-idle GEM fragments received (before filtering)         */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_GEMFRAG_GEMFRAG_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_GEMFRAG_GEMFRAG_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_GEMFRAG_OFFSET ( 0x00000014 )

#define GPON_RX_PM_COUNTER_GEMFRAG_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_GEMFRAG_OFFSET )
#define GPON_RX_PM_COUNTER_GEMFRAG_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_GEMFRAG_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_GEMFRAG_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_GEMFRAG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* GEM_fragments */
	uint32_t gemfrag	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_GEMFRAG ;
#else
typedef struct
{	uint32_t gemfrag	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GEM_fragments */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_GEMFRAG ;
#endif

/*****************************************************************************************/
/* Ethernet_packets_directed_at_ONU                                                      */
/* Counts the number of Ethernet packets which passed the Port-ID filtering              */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_ETHPACK_ETHPACK_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_ETHPACK_ETHPACK_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_ETHPACK_OFFSET ( 0x00000018 )

#define GPON_RX_PM_COUNTER_ETHPACK_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_ETHPACK_OFFSET )
#define GPON_RX_PM_COUNTER_ETHPACK_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_ETHPACK_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_ETHPACK_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_ETHPACK_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Ethernet_packets */
	uint32_t ethpack	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_ETHPACK ;
#else
typedef struct
{	uint32_t ethpack	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ethernet_packets */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_ETHPACK ;
#endif

/*****************************************************************************************/
/* TDM_fragments_directed_at_ONU                                                         */
/* Counts the number of TDM fragments which passed the Port-ID filtering                 */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_TDMFRAG_TDMFRAG_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_TDMFRAG_TDMFRAG_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_TDMFRAG_OFFSET ( 0x0000001C )

#define GPON_RX_PM_COUNTER_TDMFRAG_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_TDMFRAG_OFFSET )
#define GPON_RX_PM_COUNTER_TDMFRAG_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_TDMFRAG_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_TDMFRAG_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_TDMFRAG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TDM_fragments */
	uint32_t tdmfrag	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_TDMFRAG ;
#else
typedef struct
{	uint32_t tdmfrag	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_fragments */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_TDMFRAG ;
#endif

/*****************************************************************************************/
/* FEC_Symbol_Errors_Corrected                                                           */
/* Counts the number of bytes the FEC decoder corrected. This counter will freeze when i */
/* t crosses 0xFFFF_FFF0.                                                                */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_SYMERROR_SYMERRORS_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_SYMERROR_SYMERRORS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_SYMERROR_OFFSET ( 0x00000020 )

#define GPON_RX_PM_COUNTER_SYMERROR_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_SYMERROR_OFFSET )
#define GPON_RX_PM_COUNTER_SYMERROR_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_SYMERROR_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_SYMERROR_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_SYMERROR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Number_of_symbol_errors_the_FEC_corrected */
	uint32_t symerrors	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_SYMERROR ;
#else
typedef struct
{	uint32_t symerrors	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_symbol_errors_the_FEC_corrected */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_SYMERROR ;
#endif

/*****************************************************************************************/
/* FEC_Bit_Errors_Corrected                                                              */
/* Counts the number of bit errors the FEC block corrected. This counter will freeze whe */
/* n it crosses 0xFFFF_FF00.                                                             */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_BITERROR_BITERRORS_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_BITERROR_BITERRORS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_BITERROR_OFFSET ( 0x00000024 )

#define GPON_RX_PM_COUNTER_BITERROR_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_BITERROR_OFFSET )
#define GPON_RX_PM_COUNTER_BITERROR_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_BITERROR_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_BITERROR_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_BITERROR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Corrected_bit_errors */
	uint32_t biterrors	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BITERROR ;
#else
typedef struct
{	uint32_t biterrors	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Corrected_bit_errors */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BITERROR ;
#endif

/*****************************************************************************************/
/* AES_Machine_Allocation_Errors                                                         */
/* counts the number of times the cipher mechanism couldnt allocate a decryption machine */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_AESERROR_AESERRCNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_AESERROR_AESERRCNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_AESERROR_OFFSET ( 0x00000028 )

#define GPON_RX_PM_COUNTER_AESERROR_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_AESERROR_OFFSET )
#define GPON_RX_PM_COUNTER_AESERROR_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_AESERROR_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_AESERROR_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_AESERROR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* AES_allocation_error_count */
	uint32_t aeserrcnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_AESERROR ;
#else
typedef struct
{	uint32_t aeserrcnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AES_allocation_error_count */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_AESERROR ;
#endif

/*****************************************************************************************/
/* TDM_Statistics                                                                        */
/* counts the number of bytes correctly received by the TDM interface from GEM fragments */
/* . This counter will freeze when it crosses 0xFFFF_FFFC.                               */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_TDMSTATS_RCVBYTES_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_TDMSTATS_RCVBYTES_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_TDMSTATS_OFFSET ( 0x0000002C )

#define GPON_RX_PM_COUNTER_TDMSTATS_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_TDMSTATS_OFFSET )
#define GPON_RX_PM_COUNTER_TDMSTATS_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_TDMSTATS_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_TDMSTATS_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_TDMSTATS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Number_of_TDM_received_bytes */
	uint32_t rcvbytes	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_TDMSTATS ;
#else
typedef struct
{	uint32_t rcvbytes	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_TDM_received_bytes */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_TDMSTATS ;
#endif

/*****************************************************************************************/
/* Number_of_Ethernet_fragments                                                          */
/* Counts the number of Ethernet fragments which passed Port-ID filtering                */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_ETHFRAG_ETHFRAG_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_ETHFRAG_ETHFRAG_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_ETHFRAG_OFFSET ( 0x00000030 )

#define GPON_RX_PM_COUNTER_ETHFRAG_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_ETHFRAG_OFFSET )
#define GPON_RX_PM_COUNTER_ETHFRAG_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_ETHFRAG_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_ETHFRAG_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_ETHFRAG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Number_of_Ethernet_fragments */
	uint32_t ethfrag	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_ETHFRAG ;
#else
typedef struct
{	uint32_t ethfrag	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_Ethernet_fragments */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_ETHFRAG ;
#endif

/*****************************************************************************************/
/* Total_number_of_Ethernet_bytes_received_after_fil                                     */
/* Counts the number of total Ethernet bytes received after filtering. This counter will */
/*  freeze when it crosses 0xFFFF_F                                                      */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_ETHBYTECNT_ETHBYTECNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_ETHBYTECNT_ETHBYTECNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_ETHBYTECNT_OFFSET ( 0x00000034 )

#define GPON_RX_PM_COUNTER_ETHBYTECNT_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_ETHBYTECNT_OFFSET )
#define GPON_RX_PM_COUNTER_ETHBYTECNT_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_ETHBYTECNT_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_ETHBYTECNT_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_ETHBYTECNT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Ethernet_Byte_Count */
	uint32_t ethbytecnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_ETHBYTECNT ;
#else
typedef struct
{	uint32_t ethbytecnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ethernet_Byte_Count */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_ETHBYTECNT ;
#endif

/*****************************************************************************************/
/* FEC_Uncorrectable_Codeword_counter                                                    */
/* Counts the number of codewords the FEC decoder was unable to correct                  */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_FECUCCWCNT_R1_DEFAULT_VALUE                     ( 0x0 )
#define GPON_RX_PM_COUNTER_FECUCCWCNT_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_RX_PM_COUNTER_FECUCCWCNT_FECUCCWCNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_FECUCCWCNT_FECUCCWCNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_FECUCCWCNT_OFFSET ( 0x00000038 )

#define GPON_RX_PM_COUNTER_FECUCCWCNT_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_FECUCCWCNT_OFFSET )
#define GPON_RX_PM_COUNTER_FECUCCWCNT_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_FECUCCWCNT_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_FECUCCWCNT_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_FECUCCWCNT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* R */
	uint32_t r1        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Uncorrectable_codewords_counter */
	uint32_t fecuccwcnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_FECUCCWCNT ;
#else
typedef struct
{	uint32_t fecuccwcnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Uncorrectable_codewords_counter */
	uint32_t r1        	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* R */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_FECUCCWCNT ;
#endif

/*****************************************************************************************/
/* FEC_correctable_Codeword_counter                                                      */
/* Counts the number of codewords which contained at least one error and the FEC decoder */
/*  succeeded to decode                                                                  */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_FECCCWCNT_FECCCWCNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_FECCCWCNT_FECCCWCNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_FECCCWCNT_OFFSET ( 0x0000003C )

#define GPON_RX_PM_COUNTER_FECCCWCNT_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_FECCCWCNT_OFFSET )
#define GPON_RX_PM_COUNTER_FECCCWCNT_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_FECCCWCNT_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_FECCCWCNT_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_FECCCWCNT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FEC_correctable_codewords_counter */
	uint32_t fecccwcnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_FECCCWCNT ;
#else
typedef struct
{	uint32_t fecccwcnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_correctable_codewords_counter */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_FECCCWCNT ;
#endif

/*****************************************************************************************/
/* valid_ploam_cnt_onuid                                                                 */
/* counts the number of valid received PLOAM messages passed the ONU ID filter           */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_PLONUCNT_PL_ONU_CNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_PLONUCNT_PL_ONU_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_PLONUCNT_OFFSET ( 0x00000040 )

#define GPON_RX_PM_COUNTER_PLONUCNT_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_PLONUCNT_OFFSET )
#define GPON_RX_PM_COUNTER_PLONUCNT_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_PLONUCNT_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_PLONUCNT_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_PLONUCNT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ploam_onuid_cnt */
	uint32_t pl_onu_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLONUCNT ;
#else
typedef struct
{	uint32_t pl_onu_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ploam_onuid_cnt */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLONUCNT ;
#endif

/*****************************************************************************************/
/* valid_ploam_cnt_broadcast                                                             */
/* counts the number of valid received PLOAM messages passed the BROADCAST ONU ID filter */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_PLBCSTCNT_PL_BCST_CNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_PLBCSTCNT_PL_BCST_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_PLBCSTCNT_OFFSET ( 0x00000044 )

#define GPON_RX_PM_COUNTER_PLBCSTCNT_ADDRESS   	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_PLBCSTCNT_OFFSET )
#define GPON_RX_PM_COUNTER_PLBCSTCNT_READ( r ) 	READ_32( ( GPON_RX_PM_COUNTER_PLBCSTCNT_ADDRESS ), (r) )
#define GPON_RX_PM_COUNTER_PLBCSTCNT_WRITE( v )	WRITE_32( ( GPON_RX_PM_COUNTER_PLBCSTCNT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ploam_broadcast_cnt */
	uint32_t pl_bcst_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLBCSTCNT ;
#else
typedef struct
{	uint32_t pl_bcst_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ploam_broadcast_cnt */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_PLBCSTCNT ;
#endif

/*****************************************************************************************/
/* bandwidth_alloc_cnt                                                                   */
/* set of 4 counters.  Each counter can be associated to each one of the 40 TCONTs  Each */
/*  counter accumaltes the allocations received to its associated TCONT (cnter = cntr +  */
/* sstop - sstart)                                                                       */
/*****************************************************************************************/

#define GPON_RX_PM_COUNTER_BW_CNT_BW_CNT_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_PM_COUNTER_BW_CNT_BW_CNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_PM_COUNTER_BW_CNT_OFFSET ( 0x00000050 )

#define GPON_RX_PM_COUNTER_BW_CNT_ADDRESS        	( GPON_RX_PM_COUNTER_ADDRESS + GPON_RX_PM_COUNTER_BW_CNT_OFFSET )
#define GPON_RX_PM_COUNTER_BW_CNT_READ_I( r, i ) 	READ_I_32( ( GPON_RX_PM_COUNTER_BW_CNT_ADDRESS ), (i), (r) )
#define GPON_RX_PM_COUNTER_BW_CNT_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_PM_COUNTER_BW_CNT_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* bandwidth_count */
	uint32_t bw_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BW_CNT ;
#else
typedef struct
{	uint32_t bw_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bandwidth_count */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER_BW_CNT ;
#endif

/*****************************************************************************************/
/* bw_rcd_configuration                                                                  */
/* the configurations of the BWmap recording mechanism:    Which allocs to record, when  */
/* to stop, etc.                                                                         */
/*****************************************************************************************/

#define GPON_RX_BWMAP_RECORD_CONFIG_R1_DEFAULT_VALUE                                       ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_R1_DEFAULT_VALUE_RESET_VALUE                           ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_SECIFIC_ALLOC_DEFAULT_VALUE                            ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_SECIFIC_ALLOC_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_SPECIFIC_ALLOC_DISABLE_VALUE                       ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_SPECIFIC_ALLOC_DISABLE_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_SPECIFIC_ALLOC_ENABLE_VALUE                        ( 0x1 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_ALL_ONU_DISABLE_VALUE                              ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_ALL_ONU_DISABLE_VALUE_RESET_VALUE                  ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_ALL_ONU_ENABLE_VALUE                               ( 0x1 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_ALL_DISABLE_VALUE                                  ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_ALL_DISABLE_VALUE_RESET_VALUE                      ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_ALL_ENABLE_VALUE                                   ( 0x1 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_STOP_ON_MAP_END_STOP_ON_MEM_FULL_VALUE             ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_STOP_ON_MAP_END_STOP_ON_MEM_FULL_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_BWMAP_RECORD_CONFIG_RCD_STOP_ON_MAP_END_STOP_ON_MAP_END_VALUE              ( 0x1 )


#define GPON_RX_BWMAP_RECORD_CONFIG_OFFSET ( 0x00000000 )

#define GPON_RX_BWMAP_RECORD_CONFIG_ADDRESS   	( GPON_RX_BWMAP_RECORD_ADDRESS + GPON_RX_BWMAP_RECORD_CONFIG_OFFSET )
#define GPON_RX_BWMAP_RECORD_CONFIG_READ( r ) 	READ_32( ( GPON_RX_BWMAP_RECORD_CONFIG_ADDRESS ), (r) )
#define GPON_RX_BWMAP_RECORD_CONFIG_WRITE( v )	WRITE_32( ( GPON_RX_BWMAP_RECORD_CONFIG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1                 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* secific_alloc */
	uint32_t secific_alloc      	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_specific_alloc */
	uint32_t rcd_specific_alloc 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_all_onu */
	uint32_t rcd_all_onu        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_all */
	uint32_t rcd_all            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_stop_on_map_end */
	uint32_t rcd_stop_on_map_end	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_CONFIG ;
#else
typedef struct
{	uint32_t rcd_stop_on_map_end	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_stop_on_map_end */
	uint32_t rcd_all            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_all */
	uint32_t rcd_all_onu        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_all_onu */
	uint32_t rcd_specific_alloc 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_specific_alloc */
	uint32_t secific_alloc      	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* secific_alloc */
	uint32_t r1                 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_CONFIG ;
#endif

/*****************************************************************************************/
/* bw_rcd_en                                                                             */
/* record enable                                                                         */
/*****************************************************************************************/

#define GPON_RX_BWMAP_RECORD_ENABLE_R1_DEFAULT_VALUE                     ( 0x0 )
#define GPON_RX_BWMAP_RECORD_ENABLE_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_RX_BWMAP_RECORD_ENABLE_RCD_ENABLE_DISABLE_VALUE             ( 0x0 )
#define GPON_RX_BWMAP_RECORD_ENABLE_RCD_ENABLE_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_BWMAP_RECORD_ENABLE_RCD_ENABLE_ENABLE_VALUE              ( 0x1 )


#define GPON_RX_BWMAP_RECORD_ENABLE_OFFSET ( 0x00000004 )

#define GPON_RX_BWMAP_RECORD_ENABLE_ADDRESS   	( GPON_RX_BWMAP_RECORD_ADDRESS + GPON_RX_BWMAP_RECORD_ENABLE_OFFSET )
#define GPON_RX_BWMAP_RECORD_ENABLE_READ( r ) 	READ_32( ( GPON_RX_BWMAP_RECORD_ENABLE_ADDRESS ), (r) )
#define GPON_RX_BWMAP_RECORD_ENABLE_WRITE( v )	WRITE_32( ( GPON_RX_BWMAP_RECORD_ENABLE_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1        	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_enable */
	uint32_t rcd_enable	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_ENABLE ;
#else
typedef struct
{	uint32_t rcd_enable	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_enable */
	uint32_t r1        	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_ENABLE ;
#endif

/*****************************************************************************************/
/* bw_rcd_result                                                                         */
/* indications on the recording result:  recording done  mismatch  write pointer (haw ma */
/* ny entries are valid in the ram)                                                      */
/*****************************************************************************************/

#define GPON_RX_BWMAP_RECORD_STATUS_R1_DEFAULT_VALUE                       ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_LAST_PTR_MIN_VALUE                 ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_LAST_PTR_MIN_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_LAST_PTR_MAX_VALUE                 ( 0x1 )
#define GPON_RX_BWMAP_RECORD_STATUS_ECD_EMPTY_NOT_EMPTY_VALUE              ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_ECD_EMPTY_EMPTY_VALUE                  ( 0x1 )
#define GPON_RX_BWMAP_RECORD_STATUS_ECD_EMPTY_EMPTY_VALUE_RESET_VALUE      ( 0x1 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_MISMATCH_NO_MISS_VALUE             ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_MISMATCH_NO_MISS_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_MISMATCH_MISMATCH_VALUE            ( 0x1 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_DONE_NOT_DONE_VALUE                ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_DONE_NOT_DONE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_RX_BWMAP_RECORD_STATUS_RCD_DONE_DONE_VALUE                    ( 0x1 )


#define GPON_RX_BWMAP_RECORD_STATUS_OFFSET ( 0x00000008 )

#define GPON_RX_BWMAP_RECORD_STATUS_ADDRESS   	( GPON_RX_BWMAP_RECORD_ADDRESS + GPON_RX_BWMAP_RECORD_STATUS_OFFSET )
#define GPON_RX_BWMAP_RECORD_STATUS_READ( r ) 	READ_32( ( GPON_RX_BWMAP_RECORD_STATUS_ADDRESS ), (r) )
#define GPON_RX_BWMAP_RECORD_STATUS_WRITE( v )	WRITE_32( ( GPON_RX_BWMAP_RECORD_STATUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1          	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_last_ptr */
	uint32_t rcd_last_ptr	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_empty */
	uint32_t ecd_empty   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_mismatch */
	uint32_t rcd_mismatch	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_done */
	uint32_t rcd_done    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_STATUS ;
#else
typedef struct
{	uint32_t rcd_done    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_done */
	uint32_t rcd_mismatch	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_mismatch */
	uint32_t ecd_empty   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_empty */
	uint32_t rcd_last_ptr	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_last_ptr */
	uint32_t r1          	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_STATUS ;
#endif

/*****************************************************************************************/
/* bw_rcd_rd_if                                                                          */
/* SW read interface.    which address within the recordnig memory to read               */
/*****************************************************************************************/

#define GPON_RX_BWMAP_RECORD_READ_IF_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_RX_BWMAP_RECORD_READ_IF_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_RX_BWMAP_RECORD_READ_IF_READ_ADDR_MIN_VALUE             ( 0x0 )
#define GPON_RX_BWMAP_RECORD_READ_IF_READ_ADDR_MIN_VALUE_RESET_VALUE ( 0x0 )
#define GPON_RX_BWMAP_RECORD_READ_IF_READ_ADDR_MAX_VALUE             ( 0x3F )


#define GPON_RX_BWMAP_RECORD_READ_IF_OFFSET ( 0x0000000C )

#define GPON_RX_BWMAP_RECORD_READ_IF_ADDRESS   	( GPON_RX_BWMAP_RECORD_ADDRESS + GPON_RX_BWMAP_RECORD_READ_IF_OFFSET )
#define GPON_RX_BWMAP_RECORD_READ_IF_READ( r ) 	READ_32( ( GPON_RX_BWMAP_RECORD_READ_IF_ADDRESS ), (r) )
#define GPON_RX_BWMAP_RECORD_READ_IF_WRITE( v )	WRITE_32( ( GPON_RX_BWMAP_RECORD_READ_IF_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_addr */
	uint32_t read_addr	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_READ_IF ;
#else
typedef struct
{	uint32_t read_addr	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_addr */
	uint32_t r1       	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_READ_IF ;
#endif

/*****************************************************************************************/
/* bw_rcd_rdata                                                                          */
/* recording read data.    2 registers - 64bit data.    each entry describes one access  */
/* as recorded.                                                                          */
/*****************************************************************************************/

#define GPON_RX_BWMAP_RECORD_RDATA_RCD_DATA_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_BWMAP_RECORD_RDATA_RCD_DATA_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_BWMAP_RECORD_RDATA_OFFSET ( 0x00000010 )

#define GPON_RX_BWMAP_RECORD_RDATA_ADDRESS        	( GPON_RX_BWMAP_RECORD_ADDRESS + GPON_RX_BWMAP_RECORD_RDATA_OFFSET )
#define GPON_RX_BWMAP_RECORD_RDATA_READ_I( r, i ) 	READ_I_32( ( GPON_RX_BWMAP_RECORD_RDATA_ADDRESS ), (i), (r) )
#define GPON_RX_BWMAP_RECORD_RDATA_WRITE_I( v, i )	WRITE_I_32( ( GPON_RX_BWMAP_RECORD_RDATA_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rcd_data */
	uint32_t rcd_data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_RDATA ;
#else
typedef struct
{	uint32_t rcd_data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rcd_data */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD_RDATA ;
#endif

/*****************************************************************************************/
/* GPON_Debug_bus_selector                                                               */
/* Selects one of many debug vectors which the GPON block will output                    */
/*****************************************************************************************/

#define GPON_RX_GRX_DEBUG_DBG_SEL_R1_DEFAULT_VALUE                  ( 0x0 )
#define GPON_RX_GRX_DEBUG_DBG_SEL_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_RX_GRX_DEBUG_DBG_SEL_DBG_SEL_DEFAULT_VALUE             ( 0x0 )
#define GPON_RX_GRX_DEBUG_DBG_SEL_DBG_SEL_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_RX_GRX_DEBUG_DBG_SEL_OFFSET ( 0x00000000 )

#define GPON_RX_GRX_DEBUG_DBG_SEL_ADDRESS   	( GPON_RX_GRX_DEBUG_ADDRESS + GPON_RX_GRX_DEBUG_DBG_SEL_OFFSET )
#define GPON_RX_GRX_DEBUG_DBG_SEL_READ( r ) 	READ_32( ( GPON_RX_GRX_DEBUG_DBG_SEL_ADDRESS ), (r) )
#define GPON_RX_GRX_DEBUG_DBG_SEL_WRITE( v )	WRITE_32( ( GPON_RX_GRX_DEBUG_DBG_SEL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_Select */
	uint32_t dbg_sel	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GRX_DEBUG_DBG_SEL ;
#else
typedef struct
{	uint32_t dbg_sel	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_Select */
	uint32_t r1     	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GRX_DEBUG_DBG_SEL ;
#endif

/*****************************************************************************************/
/* Tx_ranging_delay                                                                      */
/* This register contains the Ted - Transmit equalization delay, which is the total dela */
/* y from the RX frame to the TX frame. This value is determined by the OLT during the r */
/* anging process. The software should translate the number to frames, bytes & bits, and */
/*  then configure the register. This register may be modified while TX is enabled given */
/*  a space of 3 frames from last allocation for that ONU                                */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_SDLY_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_SDLY_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_FDLY_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_FDLY_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_R2_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_R2_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_BDLY_DEFAULT_VALUE             ( 0xBB8 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_BDLY_DEFAULT_VALUE_RESET_VALUE ( 0xBB8 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_OFFSET ( 0x00000000 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved1 */
	uint32_t r1  	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_Bit_Delay */
	uint32_t sdly	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_Frame_Delay */
	uint32_t fdly	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
	uint32_t r2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_Byte_Delay */
	uint32_t bdly	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY ;
#else
typedef struct
{	uint32_t bdly	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_Byte_Delay */
	uint32_t r2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
	uint32_t fdly	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_Frame_Delay */
	uint32_t sdly	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_Bit_Delay */
	uint32_t r1  	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY ;
#endif

/*****************************************************************************************/
/* Tx_enable_register                                                                    */
/* This register contains the enable-bits for the different transmittor functions  Writi */
/* ng the same value to one of the bits is allowed and does not affect functionality.  F */
/* or example, if BIP is enabled, and the SW writes 1 to this bit again, the BIP will st */
/* ay enabled.                                                                           */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_RNGEN_DISABLE_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_RNGEN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_RNGEN_ENABLE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_MISCTXEN_DISABLE_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_MISCTXEN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_MISCTXEN_ENABLE_VALUE              ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_TDMEN_DISABLE_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_TDMEN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_TDMEN_ENABLE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_PLSEN_DISABLE_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_PLSEN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_PLSEN_ENABLE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_LOOPBEN_DISABLE_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_LOOPBEN_DISABLE_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_LOOPBEN_ENABLE_VALUE               ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_FECEN_DISABLE_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_FECEN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_FECEN_ENABLE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_BIPEN_DISABLE_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_BIPEN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_BIPEN_ENABLE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_SCREN_DISABLE_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_SCREN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_SCREN_ENABLE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_TXEN_DISABLE_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_TXEN_DISABLE_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_TXEN_ENABLE_VALUE                  ( 0x1 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_OFFSET ( 0x00000004 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ranging_enable */
	uint32_t rngen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Misc_transmission_enable */
	uint32_t misctxen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_enable */
	uint32_t tdmen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Power_level_sequence_enable */
	uint32_t plsen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loop_back_enable */
	uint32_t loopben 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_enable */
	uint32_t fecen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP8_enable */
	uint32_t bipen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Scrambler_enable */
	uint32_t scren   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitter_enable */
	uint32_t txen    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN ;
#else
typedef struct
{	uint32_t txen    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitter_enable */
	uint32_t scren   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Scrambler_enable */
	uint32_t bipen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP8_enable */
	uint32_t fecen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_enable */
	uint32_t loopben 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loop_back_enable */
	uint32_t plsen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Power_level_sequence_enable */
	uint32_t tdmen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_enable */
	uint32_t misctxen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Misc_transmission_enable */
	uint32_t rngen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ranging_enable */
	uint32_t r1      	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN ;
#endif

/*****************************************************************************************/
/* data_polarity                                                                         */
/* This resister is used to determine the polarity of the transmitted data.              */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_R2_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_R2_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_DOUTPOL_POSITIVE_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_DOUTPOL_POSITIVE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_DOUTPOL_NEGATIVE_VALUE             ( 0x1 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_OFFSET ( 0x00000008 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_data_out_polarity */
	uint32_t doutpol	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL ;
#else
typedef struct
{	uint32_t doutpol	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_data_out_polarity */
	uint32_t r2     	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL ;
#endif

/*****************************************************************************************/
/* Normal_PLOAM_repetition                                                               */
/* This register enables configuring  the number of times in which a single normal ploam */
/*  transmission will be repeated before clearing the matching valid indication in TPVLD */
/*  register. The actual number of ploam transmission repetition will be the configured  */
/* value + 1.  Updating the register is possible only when the matching valid bit is cle */
/* ared.                                                                                 */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP3_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP3_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP2_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP2_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP1_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP0_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_PREP0_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_OFFSET ( 0x00000010 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_3 */
	uint32_t prep3	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_2 */
	uint32_t prep2	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_1 */
	uint32_t prep1	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_0 */
	uint32_t prep0	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP ;
#else
typedef struct
{	uint32_t prep0	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_0 */
	uint32_t prep1	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_1 */
	uint32_t prep2	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_2 */
	uint32_t prep3	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ploam_repetition_3 */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP ;
#endif

/*****************************************************************************************/
/* Tx_PLOAM_valid_information                                                            */
/* This register enables the hardware software handshake for sending PLOAM buffers. The  */
/* software asserts a valid bit when a write cycle with value 1 to the appropriate valid */
/*  bit. (SW write cycle with 0 value does not affect the register). The hardware clears */
/*  the appropriate bit  to 0 value  after transmitting the buffer  NPREP+1 transmission */
/* s  or once if NPREP is set to zero (see also  NPREP reg for details).                 */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_UPLVD_INVALID_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_UPLVD_INVALID_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_UPLVD_VALID_VALUE               ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_NPVLD_INVALID_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_NPVLD_INVALID_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_NPVLD_VALID_VALUE               ( 0x1 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_OFFSET ( 0x00000014 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM_valid */
	uint32_t uplvd	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_valid */
	uint32_t npvld	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD ;
#else
typedef struct
{	uint32_t npvld	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_valid */
	uint32_t uplvd	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM_valid */
	uint32_t r1   	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD ;
#endif

/*****************************************************************************************/
/* Tx_DBR_valid_information                                                              */
/* This register enables the hardware software handshake for sending DBA buffers. The SW */
/*  asserts/deasserts  the valid bits. Each bit corresponds to one tcont. Lsb - tcont0,  */
/* msb tcont31.                                                                          */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_DBAV_INVALID_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_DBAV_INVALID_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_DBAV_VALID_VALUE               ( 0x1 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_OFFSET ( 0x00000018 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DBA_valid */
	uint32_t dbav	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD ;
#else
typedef struct
{	uint32_t dbav	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA_valid */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD ;
#endif

/*****************************************************************************************/
/* TX_DBR_configuration                                                                  */
/* This register contains some configuration bits regarding the DBR mechanism, and the r */
/* est of the valid bits for tconts 32-39.   The RDBAEN (bit16) is configuring which sou */
/* rce update the DBA registers. When de-asserted, the DBA registers are under mips resp */
/* onsibility. When asserted, the Runner is responsible for updating the DBA registers.  */
/* In this case, the MIPS may only read these registers. This bit should not be configur */
/* ed on the fly.  The stop index is used to determine the size of the report, when the  */
/* runner is updating the DBR. It is used for enabling work with less than 40 TCONTS, wi */
/* thout updating a report for all the 40 TCONTS on every update.  The flush bit is used */
/*  to reset the DBR pointers used by the hw when the runner updates the DBR.  This regi */
/* ster can be updated when TX is enabled.                                               */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_R1_DEFAULT_VALUE                       ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBFLUSH_DISABLED_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBFLUSH_DISABLED_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBFLUSH_ENABLED_VALUE                  ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DIVRATE_DIV32_VALUE                    ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DIVRATE_DIV48_VALUE                    ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DIVRATE_DIV48_VALUE_RESET_VALUE        ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DIVRATE_DIV64_VALUE                    ( 0x2 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBR_GEN_EN_SW_UPDATE_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBR_GEN_EN_SW_UPDATE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBR_GEN_EN_RNR_UPDATE_VALUE            ( 0x1 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBAV_INVALID_VALUE                     ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBAV_INVALID_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_DBAV_VALID_VALUE                       ( 0x1 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_OFFSET ( 0x0000001C )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1        	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBR_flush */
	uint32_t dbflush   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* divide_ratio */
	uint32_t divrate   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* report_gen_en */
	uint32_t dbr_gen_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBRvalid */
	uint32_t dbav      	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF ;
#else
typedef struct
{	uint32_t dbav      	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBRvalid */
	uint32_t dbr_gen_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* report_gen_en */
	uint32_t divrate   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* divide_ratio */
	uint32_t dbflush   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBR_flush */
	uint32_t r1        	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF ;
#endif

/*****************************************************************************************/
/* TX_PLOAM_clear_content                                                                */
/* The SW may use this register in order to  clear TPVLD and NPREP reg.  This register c */
/* an be updated when TX is enabled.                                                     */
/*****************************************************************************************/

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_TPCLRC_NOT_CLEAR_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_TPCLRC_NOT_CLEAR_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_TPCLRC_CLEAR_VALUE                 ( 0x1 )


#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_OFFSET ( 0x00000020 )

#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_ADDRESS   	( GPON_TX_GENERAL_TRANSMITTER_CONTROL_ADDRESS + GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_OFFSET )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_READ( r ) 	READ_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_ADDRESS ), (r) )
#define GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_ploam_clear_conetent */
	uint32_t tpclrc	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR ;
#else
typedef struct
{	uint32_t tpclrc	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_ploam_clear_conetent */
	uint32_t r1    	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR ;
#endif

/*****************************************************************************************/
/* Interrupt_status_register_0                                                           */
/* This register contains the current active transmitter interrupts. Each asserted bit r */
/* epresents an active interrupt source. The interrupt remains active until the software */
/*  clears it by writing 1 to the corresponding bit.  The dbr interrupts has two bits, i */
/* ndicating, not only interrupt, but the type of dbr (01 - 0ne byte, 10 -  two bytes, 1 */
/* 1 - 4 bytes dbr).  Writing 0 to any bit has no effect.                                */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB12IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB12IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB12IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB12IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB12IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB11IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB11IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB11IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB11IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB11IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB10IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB10IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB10IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB10IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB10IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB9IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB9IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB9IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB9IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB9IRQ_RESERVED_VALUE                  ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB8IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB8IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB8IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB8IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB8IRQ_RESERVED_VALUE                  ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB7IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB7IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB7IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB7IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB7IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB6IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB6IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB6IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB6IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB6IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB5IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB5IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB5IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB5IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB5IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB4IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB4IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB4IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB4IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB4IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB3IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB3IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB3IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB3IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB3IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB2IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB2IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB2IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB2IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB2IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB1IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB1IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB1IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB1IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB1IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB0IRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB0IRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB0IRQ_DBR_TYPE_1_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB0IRQ_DBR_TYPE_2_VALUE                ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_DB0IRQ_DBR_TYPE_3_VALUE                ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_RPLMIRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_RPLMIRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_RPLMIRQ_INTERRUPT_ASSERTED_VALUE       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_IPLMIRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_IPLMIRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_IPLMIRQ_INTERRUPT_ASSERTED_VALUE       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_UPLMIRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_UPLMIRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_UPLMIRQ_INTERRUPT_ASSERTED_VALUE       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_NPLMIRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_NPLMIRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_NPLMIRQ_INTERRUPT_ASSERTED_VALUE       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_ACCIRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_ACCIRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_ACCIRQ_INTERRUPT_ASSERTED_VALUE        ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_TDMIRQ_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_TDMIRQ_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_TDMIRQ_INTERRUPT_ASSERTED_VALUE        ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_OFFSET ( 0x00000000 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXISR0_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXISR0_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR0_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXISR0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DBA12_transmitted */
	uint32_t db12irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA11_transmitted */
	uint32_t db11irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA10_transmitted */
	uint32_t db10irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA9_transmitted */
	uint32_t db9irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA8_transmitted */
	uint32_t db8irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA7_transmitted */
	uint32_t db7irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA6_transmitted */
	uint32_t db6irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA5_transmitted */
	uint32_t db5irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA4_transmitted */
	uint32_t db4irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA3_transmitted */
	uint32_t db3irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA2_transmitted */
	uint32_t db2irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA1_transmitted */
	uint32_t db1irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA0_transmitted */
	uint32_t db0irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ranging_PLOAM_transmitted */
	uint32_t rplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_transmitted */
	uint32_t iplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM_transmitted */
	uint32_t uplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_transmitted */
	uint32_t nplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Access_FIFO_error */
	uint32_t accirq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_FIFO_error */
	uint32_t tdmirq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXISR0 ;
#else
typedef struct
{	uint32_t tdmirq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_FIFO_error */
	uint32_t accirq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Access_FIFO_error */
	uint32_t nplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_transmitted */
	uint32_t uplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM_transmitted */
	uint32_t iplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_transmitted */
	uint32_t rplmirq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ranging_PLOAM_transmitted */
	uint32_t db0irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA0_transmitted */
	uint32_t db1irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA1_transmitted */
	uint32_t db2irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA2_transmitted */
	uint32_t db3irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA3_transmitted */
	uint32_t db4irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA4_transmitted */
	uint32_t db5irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA5_transmitted */
	uint32_t db6irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA6_transmitted */
	uint32_t db7irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA7_transmitted */
	uint32_t db8irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA8_transmitted */
	uint32_t db9irq 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA9_transmitted */
	uint32_t db10irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA10_transmitted */
	uint32_t db11irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA11_transmitted */
	uint32_t db12irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA12_transmitted */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXISR0 ;
#endif

/*****************************************************************************************/
/* Interrupt_status_register_1                                                           */
/* This register contains the current active transmitter interrupts. Each asserted bit r */
/* epresents an active interrupt source. The interrupt remains active until the software */
/*  clears it by writing 1 to the corresponding bit.  The dbr interrupts has two bits, i */
/* ndicating, not only interrupt, but the type of dbr (01 - 0ne byte, 10 -  two bytes, 1 */
/* 1 - 4 bytes dbr).  Writing 0 to any bit has no effect.                                */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB28IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB28IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB28IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB28IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB28IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB27IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB27IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB27IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB27IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB27IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB26IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB26IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB26IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB26IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB26IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB25IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB25IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB25IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB25IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB25IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB24IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB24IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB24IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB24IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB24IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB23IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB23IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB23IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB23IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB23IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB22IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB22IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB22IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB22IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB22IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB21IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB21IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB21IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB21IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB21IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB20IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB20IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB20IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB20IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB20IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB19IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB19IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB19IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB19IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB19IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB18IRQ_RESERVED_VALUE                 ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB18IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB18IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB18IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB18IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB17IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB17IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB17IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB17IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB17IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB16IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB16IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB16IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB16IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB16IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB15IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB15IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB15IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB15IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB15IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB14IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB14IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB14IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB14IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB14IRQ_RESERVED_VALUE                 ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB13IRQ_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB13IRQ_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB13IRQ_DBR_TYPE_1_VALUE               ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB13IRQ_DBR_TYPE_2_VALUE               ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_DB13IRQ_RESERVED_VALUE                 ( 0x3 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_OFFSET ( 0x00000004 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXISR1_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXISR1_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR1_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXISR1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DBA28_transmitted */
	uint32_t db28irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA27_transmitted */
	uint32_t db27irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA26_transmitted */
	uint32_t db26irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA25_transmitted */
	uint32_t db25irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA24_transmitted */
	uint32_t db24irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA23_transmitted */
	uint32_t db23irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA22_transmitted */
	uint32_t db22irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA21_transmitted */
	uint32_t db21irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA20_transmitted */
	uint32_t db20irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA19_transmitted */
	uint32_t db19irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA18_transmitted */
	uint32_t db18irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA17_transmitted */
	uint32_t db17irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA16_transmitted */
	uint32_t db16irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA15_transmitted */
	uint32_t db15irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA14_transmitted */
	uint32_t db14irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA13_transmitted */
	uint32_t db13irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXISR1 ;
#else
typedef struct
{	uint32_t db13irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA13_transmitted */
	uint32_t db14irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA14_transmitted */
	uint32_t db15irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA15_transmitted */
	uint32_t db16irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA16_transmitted */
	uint32_t db17irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA17_transmitted */
	uint32_t db18irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA18_transmitted */
	uint32_t db19irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA19_transmitted */
	uint32_t db20irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA20_transmitted */
	uint32_t db21irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA21_transmitted */
	uint32_t db22irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA22_transmitted */
	uint32_t db23irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA23_transmitted */
	uint32_t db24irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA24_transmitted */
	uint32_t db25irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA25_transmitted */
	uint32_t db26irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA26_transmitted */
	uint32_t db27irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA27_transmitted */
	uint32_t db28irq	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA28_transmitted */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXISR1 ;
#endif

/*****************************************************************************************/
/* Interrupt_status_register_2                                                           */
/* This register contains the current active transmitter interrupts. Each asserted bit r */
/* epresents an active interrupt source. The interrupt remains active until the software */
/*  clears it by writing 1 to the corresponding bit.  The dbr interrupts has two bits, i */
/* ndicating, not only interrupt, but the type of dbr (01 - 0ne byte, 10 -  two bytes, 1 */
/* 1 - 4 bytes dbr).  Writing 0 to any bit has no effect.                                */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_R1_DEFAULT_VALUE                               ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_R1_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ROGUE_ONU_DIFF_NO_INTERRUPT_VALUE              ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ROGUE_ONU_DIFF_NO_INTERRUPT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ROGUE_ONU_DIFF_INTERRUPT_ASSERTED_VALUE        ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ROGUE_ONU_LEVEL_NO_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ROGUE_ONU_LEVEL_NO_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ROGUE_ONU_LEVEL_INTERRUPT_ASSERTED_VALUE       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_OVRIRQ_NO_INTERRUPT_VALUE                      ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_OVRIRQ_NO_INTERRUPT_VALUE_RESET_VALUE          ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_OVRIRQ_INTERRUPT_ASSERTED_VALUE                ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB39IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB39IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB39IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB39IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB39IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB38IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB38IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB38IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB38IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB38IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB37IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB37IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB37IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB37IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB37IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB36IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB36IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB36IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB36IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB36IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB35IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB35IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB35IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB35IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB35IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB34IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB34IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB34IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB34IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB34IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB33IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB33IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB33IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB33IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB33IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB32IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB32IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB32IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB32IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB32IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB31IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB31IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB31IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB31IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB31IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB30IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB30IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB30IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB30IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB30IRQ_RESERVED_VALUE                         ( 0x3 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB29IRQ_NO_INTERRUPT_VALUE                     ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB29IRQ_NO_INTERRUPT_VALUE_RESET_VALUE         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB29IRQ_DBR_TYPE_1_VALUE                       ( 0x1 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB29IRQ_DBR_TYPE_2_VALUE                       ( 0x2 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_DB29IRQ_RESERVED_VALUE                         ( 0x3 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_OFFSET ( 0x00000008 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXISR2_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXISR2_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXISR2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1             	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_onu_diff */
	uint32_t rogue_onu_diff 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_onu_level */
	uint32_t rogue_onu_level	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Overrun_occurred */
	uint32_t ovrirq         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA39_transmitted */
	uint32_t db39irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA38_transmitted */
	uint32_t db38irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA37_transmitted */
	uint32_t db37irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA36_transmitted */
	uint32_t db36irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA35_transmitted */
	uint32_t db35irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA34_transmitted */
	uint32_t db34irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA33_transmitted */
	uint32_t db33irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA32_transmitted */
	uint32_t db32irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA31transmitted */
	uint32_t db31irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA30_transmitted */
	uint32_t db30irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA29_transmitted */
	uint32_t db29irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXISR2 ;
#else
typedef struct
{	uint32_t db29irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA29_transmitted */
	uint32_t db30irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA30_transmitted */
	uint32_t db31irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA31transmitted */
	uint32_t db32irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA32_transmitted */
	uint32_t db33irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA33_transmitted */
	uint32_t db34irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA34_transmitted */
	uint32_t db35irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA35_transmitted */
	uint32_t db36irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA36_transmitted */
	uint32_t db37irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA37_transmitted */
	uint32_t db38irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA38_transmitted */
	uint32_t db39irq        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBA39_transmitted */
	uint32_t ovrirq         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Overrun_occurred */
	uint32_t rogue_onu_level	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_onu_level */
	uint32_t rogue_onu_diff 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_onu_diff */
	uint32_t r1             	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXISR2 ;
#endif

/*****************************************************************************************/
/* Interrupt_enable_register_0                                                           */
/* This register provides an enable mask for each of the interrupt sources depicted in t */
/* he ISR register.                                                                      */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_IEM_INTERRUPT_DISABLED_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_IEM_INTERRUPT_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_IEM_INTERRUPT_ENABLED_VALUE              ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_OFFSET ( 0x0000000C )

#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXIER0_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXIER0_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER0_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXIER0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Interrupt_enable_mask */
	uint32_t iem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXIER0 ;
#else
typedef struct
{	uint32_t iem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_mask */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXIER0 ;
#endif

/*****************************************************************************************/
/* Interrupt_enable_register_1                                                           */
/* This register provides an enable mask for each of the interrupt sources depicted in t */
/* he ISR register.                                                                      */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_IEM_INTERRUPT_DISABLED_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_IEM_INTERRUPT_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_IEM_INTERRUPT_ENABLED_VALUE              ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_OFFSET ( 0x00000010 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXIER1_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXIER1_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER1_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXIER1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Interrupt_enable_mask */
	uint32_t iem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXIER1 ;
#else
typedef struct
{	uint32_t iem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_mask */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXIER1 ;
#endif

/*****************************************************************************************/
/* Interrupt_enable_register_2                                                           */
/* This register provides an enable mask for each of the interrupt sources depicted in t */
/* he ISR register.                                                                      */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_R1_DEFAULT_VALUE                         ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_IEM_INTERRUPT_DISABLED_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_IEM_INTERRUPT_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_IEM_INTERRUPT_ENABLED_VALUE              ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_OFFSET ( 0x00000014 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXIER2_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXIER2_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXIER2_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXIER2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_mask */
	uint32_t iem	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXIER2 ;
#else
typedef struct
{	uint32_t iem	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_mask */
	uint32_t r1 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXIER2 ;
#endif

/*****************************************************************************************/
/* Interrupt_test_register_0                                                             */
/* This register enables testing by simulating interrupt sources. When the software sets */
/*  a bit in the ITR, the corresponding bit in the ISR shows an active interrupt. The in */
/* terrupt remains active until software clears the bit in the ITR                       */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_IST_NO_TEST_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_IST_NO_TEST_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_IST_ASSERT_INTERRUPT_FOR_TEST_VALUE     ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_OFFSET ( 0x00000018 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXITR0_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXITR0_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR0_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXITR0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Interrupt_simulation_test */
	uint32_t ist	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXITR0 ;
#else
typedef struct
{	uint32_t ist	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_simulation_test */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXITR0 ;
#endif

/*****************************************************************************************/
/* Interrupt_test_register_1                                                             */
/* This register enables testing by simulating interrupt sources. When the software sets */
/*  a bit in the ITR, the corresponding bit in the ISR shows an active interrupt. The in */
/* terrupt remains active until software clears the bit in the ITR                       */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_IST_NO_TEST_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_IST_NO_TEST_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_IST_ASSERT_INTERRUPT_FOR_TEST_VALUE     ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_OFFSET ( 0x0000001C )

#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXITR1_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXITR1_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR1_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXITR1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Interrupt_simulation_test */
	uint32_t ist	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXITR1 ;
#else
typedef struct
{	uint32_t ist	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_simulation_test */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXITR1 ;
#endif

/*****************************************************************************************/
/* Interrupt_test_register_2                                                             */
/* This register enables testing by simulating interrupt sources. When the software sets */
/*  a bit in the ITR, the corresponding bit in the ISR shows an active interrupt. The in */
/* terrupt remains active until software clears the bit in the ITR                       */
/*****************************************************************************************/

#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_R1_DEFAULT_VALUE                        ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_R1_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_IST_NO_TEST_INTERRUPT_VALUE             ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_IST_NO_TEST_INTERRUPT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_IST_ASSERT_INTERRUPT_FOR_TEST_VALUE     ( 0x1 )


#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_OFFSET ( 0x00000020 )

#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_ADDRESS   	( GPON_TX_INTERRUPT_CONTROLLER_ADDRESS + GPON_TX_INTERRUPT_CONTROLLER_TXITR2_OFFSET )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_READ( r ) 	READ_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXITR2_ADDRESS ), (r) )
#define GPON_TX_INTERRUPT_CONTROLLER_TXITR2_WRITE( v )	WRITE_32( ( GPON_TX_INTERRUPT_CONTROLLER_TXITR2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_simulation_test */
	uint32_t ist	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXITR2 ;
#else
typedef struct
{	uint32_t ist	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_simulation_test */
	uint32_t r1 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER_TXITR2 ;
#endif

/*****************************************************************************************/
/* ONU_ID                                                                                */
/* Specify the ONU ID. This register can be modified while TX is enabled.                */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_ONUID_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ONUID_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ONUID_ONUID_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ONUID_ONUID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_ONUID_OFFSET ( 0x00000000 )

#define GPON_TX_GENERAL_CONFIGURATION_ONUID_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_ONUID_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_ONUID_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_ONUID_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_ONUID_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_ONUID_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ONU_ID */
	uint32_t onuid	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ONUID ;
#else
typedef struct
{	uint32_t onuid	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ONU_ID */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ONUID ;
#endif

/*****************************************************************************************/
/* Indication_field                                                                      */
/* Specifies the IND field in the PON upstream. This register can be modified while TX i */
/* s enabled.                                                                            */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_IND_R3_DEFAULT_VALUE                          ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_R3_DEFAULT_VALUE_RESET_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_R2_DEFAULT_VALUE                          ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_R2_DEFAULT_VALUE_RESET_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_RDI_DEASSERTED_VALUE                      ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_RDI_DEASSERTED_VALUE_RESET_VALUE          ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_RDI_ASSERTED_VALUE                        ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT5_NO_TRAFFIC_WAITING_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT5_NO_TRAFFIC_WAITING_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT5_TRAFFIC_WAITING_VALUE                ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT4_NO_TRAFFIC_WAITING_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT4_NO_TRAFFIC_WAITING_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT4_TRAFFIC_WAITING_VALUE                ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT3_NO_TRAFFIC_WAITING_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT3_NO_TRAFFIC_WAITING_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT3_TRAFFIC_WAITING_VALUE                ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT2_NO_TRAFFIC_WAITING_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT2_NO_TRAFFIC_WAITING_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_TWT2_TRAFFIC_WAITING_VALUE                ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_R1_DEFAULT_VALUE                          ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_IND_R1_DEFAULT_VALUE_RESET_VALUE              ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_IND_OFFSET ( 0x00000004 )

#define GPON_TX_GENERAL_CONFIGURATION_IND_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_IND_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_IND_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_IND_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_IND_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_IND_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3  	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Remote_defects_status */
	uint32_t rdi 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT5 */
	uint32_t twt5	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT4 */
	uint32_t twt4	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT3 */
	uint32_t twt3	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT2 */
	uint32_t twt2	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_IND ;
#else
typedef struct
{	uint32_t r1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t twt2	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT2 */
	uint32_t twt3	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT3 */
	uint32_t twt4	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT4 */
	uint32_t twt5	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Traffic_waiting_TCONT5 */
	uint32_t rdi 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Remote_defects_status */
	uint32_t r2  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3  	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_IND ;
#endif

/*****************************************************************************************/
/* Preamble_overhead                                                                     */
/* This register array of 16 bytes defines a configurable pattern of the preamble overhe */
/* ad. This register can be modified when TX is enabled in space of one frame from last  */
/* allocation to that ONU                                                                */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_PROD_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PROD_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PROD_PRODC_DEFAULT_VALUE             ( 0xFF )
#define GPON_TX_GENERAL_CONFIGURATION_PROD_PRODC_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define GPON_TX_GENERAL_CONFIGURATION_PROD_OFFSET ( 0x00000010 )

#define GPON_TX_GENERAL_CONFIGURATION_PROD_ADDRESS        	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_PROD_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_PROD_READ_I( r, i ) 	READ_I_32( ( GPON_TX_GENERAL_CONFIGURATION_PROD_ADDRESS ), (i), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_PROD_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_GENERAL_CONFIGURATION_PROD_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Overhead_content */
	uint32_t prodc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PROD ;
#else
typedef struct
{	uint32_t prodc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Overhead_content */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PROD ;
#endif

/*****************************************************************************************/
/* Preamble_overhead_specifications                                                      */
/* This register configures the preamble config lengths which consist of a pattern up to */
/*  16 bytes and a repetition byte. This register can be modified when TX is enabled in  */
/* space of one frame from last allocation to that ONU                                   */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_PRODS_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_PRL_DEFAULT_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_PRL_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_PRCL_MIN_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_PRCL_DEFAULT_VALUE             ( 0x8 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_PRCL_DEFAULT_VALUE_RESET_VALUE ( 0x8 )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_PRCL_MAX_VALUE                 ( 0x10 )


#define GPON_TX_GENERAL_CONFIGURATION_PRODS_OFFSET ( 0x00000050 )

#define GPON_TX_GENERAL_CONFIGURATION_PRODS_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_PRODS_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_PRODS_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_PRODS_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_PRODS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* preamble_repetition_length */
	uint32_t prl 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Preamble_length */
	uint32_t prcl	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PRODS ;
#else
typedef struct
{	uint32_t prcl	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Preamble_length */
	uint32_t prl 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* preamble_repetition_length */
	uint32_t r1  	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PRODS ;
#endif

/*****************************************************************************************/
/* Preamble_repetition_byte                                                              */
/* This register defines the byte repetition content. This register can be modified when */
/*  TX is enabled in space of one frame from last allocation to that ONU                 */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_PRRB_R1_DEFAULT_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRRB_R1_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRRB_BRC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PRRB_BRC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_PRRB_OFFSET ( 0x00000060 )

#define GPON_TX_GENERAL_CONFIGURATION_PRRB_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_PRRB_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_PRRB_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_PRRB_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_PRRB_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_PRRB_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1 	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Byte_repetition_content */
	uint32_t brc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PRRB ;
#else
typedef struct
{	uint32_t brc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Byte_repetition_content */
	uint32_t r1 	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PRRB ;
#endif

/*****************************************************************************************/
/* Delimiter_content                                                                     */
/* This register defines the delimiter content. This register can be modified when TX is */
/*  enabled in space of one frame from last allocation to that ONU. The delimiter contai */
/* ning 4 bytes is transmitted from Lsbyte to Msbyte                                     */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DELC_DELOC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DELC_DELOC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_DELC_OFFSET ( 0x00000070 )

#define GPON_TX_GENERAL_CONFIGURATION_DELC_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DELC_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DELC_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DELC_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DELC_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DELC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Delimiter_content */
	uint32_t deloc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DELC ;
#else
typedef struct
{	uint32_t deloc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Delimiter_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DELC ;
#endif

/*****************************************************************************************/
/* Misc_access_content1                                                                  */
/* This register defines sstart & sstop of misc access. This register can be updated onl */
/* y when TX is disabled.                                                                */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_MSSTART_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_MSSTART_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_MSSTOP_DEFAULT_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_MSSTOP_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_OFFSET ( 0x00000080 )

#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_MISCAC1_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_MISCAC1_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC1_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_MISCAC1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Msstart */
	uint32_t msstart	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Msstop */
	uint32_t msstop 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_MISCAC1 ;
#else
typedef struct
{	uint32_t msstop 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Msstop */
	uint32_t msstart	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Msstart */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_MISCAC1 ;
#endif

/*****************************************************************************************/
/* Misc_access_content2                                                                  */
/* This register defines misc access flags and queue. This register can be updated only  */
/* when TX is disabled.                                                                  */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_QU_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_QU_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_FECU_FLAG_DOWN_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_FECU_FLAG_DOWN_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_FECU_FLAG_UP_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_DBRU_FLAG_DOWN_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_DBRU_FLAG_DOWN_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_DBRU_FLAG_UP_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_PLOAMU_FLAG_DOWN_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_PLOAMU_FLAG_DOWN_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_PLOAMU_FLAG_UP_VALUE               ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_OFFSET ( 0x00000090 )

#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_MISCAC2_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_MISCAC2_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_MISCAC2_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_MISCAC2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Queue */
	uint32_t qu    	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FECu */
	uint32_t fecu  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBRu */
	uint32_t dbru  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAMu */
	uint32_t ploamu	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_MISCAC2 ;
#else
typedef struct
{	uint32_t ploamu	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAMu */
	uint32_t dbru  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DBRu */
	uint32_t fecu  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FECu */
	uint32_t qu    	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Queue */
	uint32_t r1    	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_MISCAC2 ;
#endif

/*****************************************************************************************/
/* Enable_short_allocations                                                              */
/* When asserted, allocations shorter than 16 bytes will be allowed                      */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_ESALL_R1_DEFAULT_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ESALL_R1_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ESALL_ESA_DISABLE_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ESALL_ESA_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ESALL_ESA_ENABLE_VALUE              ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_ESALL_OFFSET ( 0x000000A0 )

#define GPON_TX_GENERAL_CONFIGURATION_ESALL_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_ESALL_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_ESALL_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_ESALL_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_ESALL_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_ESALL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1 	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* enable_short_allocations */
	uint32_t esa	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ESALL ;
#else
typedef struct
{	uint32_t esa	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* enable_short_allocations */
	uint32_t r1 	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ESALL ;
#endif

/*****************************************************************************************/
/* Tcont_to_counter_group_association                                                    */
/* There are four sets of PM counters. Each set counts events that are related to one TC */
/* ONT. This register determines which TCONT is associated with each one of the counters */
/*  groups                                                                               */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R4_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R4_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP3_MIN_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP3_DEFAULT_VALUE             ( 0x3 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP3_DEFAULT_VALUE_RESET_VALUE ( 0x3 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP3_MAX_VALUE                 ( 0x27 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R3_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R3_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP2_MIN_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP2_DEFAULT_VALUE             ( 0x2 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP2_DEFAULT_VALUE_RESET_VALUE ( 0x2 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP2_MAX_VALUE                 ( 0x27 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R2_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R2_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP1_MIN_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP1_DEFAULT_VALUE             ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP1_DEFAULT_VALUE_RESET_VALUE ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP1_MAX_VALUE                 ( 0x27 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP0_MIN_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP0_MIN_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_QFORGRP0_MAX_VALUE                 ( 0x27 )


#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_OFFSET ( 0x000000B0 )

#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_QFORCNTR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r4      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_3 */
	uint32_t qforgrp3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r3      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_2 */
	uint32_t qforgrp2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r2      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_1 */
	uint32_t qforgrp1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_0 */
	uint32_t qforgrp0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_QFORCNTR ;
#else
typedef struct
{	uint32_t qforgrp0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_0 */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t qforgrp1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_1 */
	uint32_t r2      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t qforgrp2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_2 */
	uint32_t r3      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t qforgrp3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_number_for_group_3 */
	uint32_t r4      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_QFORCNTR ;
#endif

/*****************************************************************************************/
/* PLS_specification                                                                     */
/* PLS specifications including PLS pattern. This register can be modified when TX is en */
/* abled in space of one frame from last allocation to that ONU                          */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_PLSS_PLSPAT_DEFAULT_VALUE             ( 0xAAAAAAAA )
#define GPON_TX_GENERAL_CONFIGURATION_PLSS_PLSPAT_DEFAULT_VALUE_RESET_VALUE ( 0xAAAAAAAA )


#define GPON_TX_GENERAL_CONFIGURATION_PLSS_OFFSET ( 0x00000110 )

#define GPON_TX_GENERAL_CONFIGURATION_PLSS_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_PLSS_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_PLSS_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_PLSS_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_PLSS_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_PLSS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PLS_pattern */
	uint32_t plspat	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PLSS ;
#else
typedef struct
{	uint32_t plspat	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLS_pattern */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PLSS ;
#endif

/*****************************************************************************************/
/* PLS_repetition_specifications                                                         */
/* This register defines the number of repetitions on PLSS register. This register can b */
/* e modified when TX is enabled in space of one frame from last allocation to that ONU  */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_R1_RESERVED_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_R1_RESERVED_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_PLSR_DEFAULT_VALUE             ( 0x40 )
#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_PLSR_DEFAULT_VALUE_RESET_VALUE ( 0x40 )


#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_OFFSET ( 0x00000120 )

#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_PLSRS_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_PLSRS_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_PLSRS_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_PLSRS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* R */
	uint32_t r1  	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLS_repetition */
	uint32_t plsr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PLSRS ;
#else
typedef struct
{	uint32_t plsr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLS_repetition */
	uint32_t r1  	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* R */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_PLSRS ;
#endif

/*****************************************************************************************/
/* BIP_specifications                                                                    */
/* Enables injection of bip errors using a bip mask. The SW has two options of operation */
/* . One is to use BIPEF (Bip Error Force) field. The SW can set/clear this bit. When se */
/* t to  one the BIP error will be set in each burst BIP. The second option is to use BI */
/* PEV field. The SW can only set this field to one and the HW can only clear this bit t */
/* o zero after BIPENUN burst errors were injected. This register can be modified only w */
/* hen TX is disabled.                                                                   */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_BIPS_R1_DEFAULT_VALUE                  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPEF_NO_FORCE_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPEF_NO_FORCE_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPEF_FORCE_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPEV_INVALID_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPEV_INVALID_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPEV_VALID_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPM_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPM_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPENUM_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_BIPENUM_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_BIPS_OFFSET ( 0x00000130 )

#define GPON_TX_GENERAL_CONFIGURATION_BIPS_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_BIPS_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_BIPS_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_BIPS_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_BIPS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP_error_force */
	uint32_t bipef  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bip_error_valid */
	uint32_t bipev  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bip_error_mask */
	uint32_t bipm   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bip_error_num */
	uint32_t bipenum	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_BIPS ;
#else
typedef struct
{	uint32_t bipenum	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bip_error_num */
	uint32_t bipm   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bip_error_mask */
	uint32_t bipev  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bip_error_valid */
	uint32_t bipef  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP_error_force */
	uint32_t r1     	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_BIPS ;
#endif

/*****************************************************************************************/
/* CRC_offset                                                                            */
/* This register defines the offset from a packet start from which crc calculation is ap */
/* plied to the transmitted packet when crc32 is enabled. This register can be modified  */
/* only when TX is disabled.                                                             */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_R1_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_R1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_CRCOC_MIN_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_CRCOC_MIN_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_CRCOC_MAX_VALUE              ( 0x40 )


#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_OFFSET ( 0x00000140 )

#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_CRCOFF_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_CRCOFF_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_CRCOFF_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_CRCOFF_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_offset_content */
	uint32_t crcoc	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_CRCOFF ;
#else
typedef struct
{	uint32_t crcoc	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_offset_content */
	uint32_t r1   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_CRCOFF ;
#endif

/*****************************************************************************************/
/* single_TCONT_flush                                                                    */
/* This register enables single TCONT flush. When configuring the queue number, and sett */
/* ing the valid bit, the new data for the queue will be disregarded, and its read and w */
/* rite pointers will be reset.  In order to avoid under-run in the TX fifos, the flush  */
/* does not happen immediately, but is done when there is no transmission. When the flus */
/* h is done, the HW will assert flush_done bit (see next register).  If an immediate fl */
/* ush is desired (no waiting for no transmission), the flush immediate bit should be as */
/* serted along with the flush valid.                                                    */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_R2_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_R2_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLIMM_DISABLE_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLIMM_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLIMM_ENABLE_VALUE              ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLEN_DISABLE_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLEN_DISABLE_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLEN_ENABLE_VALUE               ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLQ_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_FLQ_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_OFFSET ( 0x00000144 )

#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_FLUSH_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_FLUSH_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_FLUSH_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_FLUSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r2   	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_immediate */
	uint32_t flimm	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_enable */
	uint32_t flen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_queue */
	uint32_t flq  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_FLUSH ;
#else
typedef struct
{	uint32_t flq  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_queue */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t flen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_enable */
	uint32_t flimm	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_immediate */
	uint32_t r2   	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_FLUSH ;
#endif

/*****************************************************************************************/
/* flush_done                                                                            */
/* This register contains the HW indication to SW that the flush was done.  In order to  */
/* initiate flush process the SW asserts flush valid and flush_q fields in the previous  */
/* register. When the flush is done (immediately or gracefully) the HW asserts the flush */
/*  done bit. This bit will stay asserted until the SW de-assert flush valid. In this ti */
/* me, between the assertion of flush done and de-assertion of flush valid, the flush co */
/* ntinues, meaning new data for the flushed queue will be disregarded, and IDLE GEMs wi */
/* ll be transmitted if the flushed queue will receive accesses.                         */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_FLDN_NOT_DONE_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_FLDN_NOT_DONE_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_FLDN_DONE_VALUE                 ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_OFFSET ( 0x00000148 )

#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_FLSHDN_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_FLSHDN_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_FLSHDN_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_FLSHDN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_done */
	uint32_t fldn	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_FLSHDN ;
#else
typedef struct
{	uint32_t fldn	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_done */
	uint32_t r1  	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_FLSHDN ;
#endif

/*****************************************************************************************/
/* buffer_ready_indications_update_set                                                   */
/* This register contains the control of the ready indications update mechanism. Asserti */
/* on of the set bit will activate a process of updating the indications of number of bu */
/* ffers ready per queue in the front end fifo. The updating process will be triggered e */
/* very time the set bit will change its state from 0 to 1. When the update is done, the */
/*  HW will assert the RDY bit.                                                          */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_RDY_NOT_READY_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_RDY_NOT_READY_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_RDY_READY_VALUE                 ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_R0_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_R0_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_SET_DISABLE_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_SET_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_SET_ENABLE_VALUE                ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_OFFSET ( 0x0000014C )

#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_RDYIND_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_RDYIND_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_RDYIND_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_RDYIND_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1 	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* indicatios_update_done */
	uint32_t rdy	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r0 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* indications_update_set */
	uint32_t set	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_RDYIND ;
#else
typedef struct
{	uint32_t set	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* indications_update_set */
	uint32_t r0 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t rdy	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* indicatios_update_done */
	uint32_t r1 	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_RDYIND ;
#endif

/*****************************************************************************************/
/* DV_specifications_polarity_and_extension_enable                                       */
/* DV is the data valid signal output to control the burst transceiver. If DVPOL registe */
/* r  is set to one then DV value when not in burst is zero and during burst is one and  */
/* vice versa. DVPOL doesnt affect DV value in setup (2 bytes pattern) and hold time (2 */
/*  bytes pattern). During setup and hold DV value is set according to DVSTP and DVHLD r */
/* egisters.  This register contains also the enable bit for the DV setup and hold exten */
/* sion.  This register can be modified only when TX is disabled.                        */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_R2_DEFAULT_VALUE                       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_R2_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_DVEXTEN_DISABLE_VALUE                  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_DVEXTEN_DISABLE_VALUE_RESET_VALUE      ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_DVEXTEN_ENABLE_VALUE                   ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_R1_DEFAULT_VALUE                       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_DVPOL_DV_ACTIVE_LOW_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_DVPOL_DV_ACTIVE_HIGH_VALUE             ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_DVPOL_DV_ACTIVE_HIGH_VALUE_RESET_VALUE ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_OFFSET ( 0x00000150 )

#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DVSLP_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DVSLP_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DVSLP_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DVSLP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_extension_enable */
	uint32_t dvexten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_polarity */
	uint32_t dvpol  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DVSLP ;
#else
typedef struct
{	uint32_t dvpol  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_polarity */
	uint32_t r1     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t dvexten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_extension_enable */
	uint32_t r2     	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DVSLP ;
#endif

/*****************************************************************************************/
/* DV_specifications_setup_pattern                                                       */
/* DV is the data valid signal output to control the burst transceiver. This register co */
/* nfigure the pattern of this signal during setup time prior to preamble transmission.  */
/*   The default setup pattern length is of 2 bytes, when bits 15:8 are transmitted firs */
/* t, and then bits 7:0.  he setup pattern can be extended (see previous register) to 3  */
/* bytes, where bits 23:16 will be the first to be transmitted and 7:0 are last.  This r */
/* egister can be modified only when TX is disabled.                                     */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_DVSTU_DEFAULT_VALUE             ( 0x800100 )
#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_DVSTU_DEFAULT_VALUE_RESET_VALUE ( 0x800100 )


#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_OFFSET ( 0x00000154 )

#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DVSTP_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DVSTP_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DVSTP_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DVSTP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_setup_bits */
	uint32_t dvstu	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DVSTP ;
#else
typedef struct
{	uint32_t dvstu	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_setup_bits */
	uint32_t r1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DVSTP ;
#endif

/*****************************************************************************************/
/* DV_specifications_hold_pattern                                                        */
/* DV is the data valid signal output to control the burst transceiver. This register co */
/* nfigure the hold pattern of this signal during hold time following burst transmission */
/*  end.  The hold pattern can be also extended (see previous register) in the same mann */
/* er as setup.   This register can be modified only when TX is disabled.                */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_DVHLD_DEFAULT_VALUE             ( 0x8000 )
#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_DVHLD_DEFAULT_VALUE_RESET_VALUE ( 0x8000 )


#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_OFFSET ( 0x00000158 )

#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DVHLD_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DVHLD_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DVHLD_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DVHLD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_hold_bits */
	uint32_t dvhld	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DVHLD ;
#else
typedef struct
{	uint32_t dvhld	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_hold_bits */
	uint32_t r1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DVHLD ;
#endif

/*****************************************************************************************/
/* data_pattern_enable                                                                   */
/* This register contains the configurations for the data pattern feature.  When the dat */
/* a pattern enable bit is asserted, the data bus will have the value of 0xAA in times w */
/* here there is no transimission (dv is off). A setup and hold patterns will also be tr */
/* ansmitted. The setup will be transmitted before the preamble and the hold will be tra */
/* nsmitted right after the last byte of payload. The setup and hold patterns are config */
/* ured in the next register, but their length is configured in this. The length for bot */
/* h may vary between 1 to 4 bytes.                                                      */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DPEN_R3_DEFAULT_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_R3_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_HLDLEN_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_HLDLEN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_HLDLEN_MIN_LENGTH_VALUE          ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_HLDLEN_MAX_LENGTH_VALUE          ( 0x4 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_R2_DEFAULT_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_R2_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_STPLEN_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_STPLEN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_STPLEN_MIN_LENGTH_VALUE          ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_STPLEN_MAX_LENGTH_VALUE          ( 0x4 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_R1_DEFAULT_VALUE                 ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_PRBS_DISABLE_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_PRBS_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_PRBS_ENABLE_VALUE                ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_DPEN_DISABLE_VALUE               ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_DPEN_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_DPEN_ENABLE_VALUE                ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_DPEN_OFFSET ( 0x00000160 )

#define GPON_TX_GENERAL_CONFIGURATION_DPEN_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DPEN_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DPEN_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DPEN_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DPEN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3    	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hold_length */
	uint32_t hldlen	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Setup_length */
	uint32_t stplen	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1    	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* prbs_pattern_enable */
	uint32_t prbs  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_pattern_enable */
	uint32_t dpen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DPEN ;
#else
typedef struct
{	uint32_t dpen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_pattern_enable */
	uint32_t prbs  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* prbs_pattern_enable */
	uint32_t r1    	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t stplen	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Setup_length */
	uint32_t r2    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t hldlen	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hold_length */
	uint32_t r3    	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DPEN ;
#endif

/*****************************************************************************************/
/* data_setup_pattern                                                                    */
/* This register contains configurable the data setup pattern. This pattern will be tran */
/* smitted before the preamble if the data pattern is enabled. The setup pattern length  */
/* is configured and may vary from 1 to 4 bytes (see previous register). If a length of  */
/* one byte is configured, bits 7:0 of this register will be transmitted. If the length  */
/* is 4 bytes, bits 7:0 will be transmitted first, and 31:24 will be transmitted last.   */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DSTP_STPPAT_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DSTP_STPPAT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_DSTP_OFFSET ( 0x00000164 )

#define GPON_TX_GENERAL_CONFIGURATION_DSTP_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DSTP_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DSTP_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DSTP_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DSTP_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DSTP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data_setup_pattern */
	uint32_t stppat	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DSTP ;
#else
typedef struct
{	uint32_t stppat	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_setup_pattern */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DSTP ;
#endif

/*****************************************************************************************/
/* data_hold_pattern                                                                     */
/* This register contains configurable the data hold pattern. This pattern will be trans */
/* mitted right after the last byte of payload if the data pattern is enabled. The hold  */
/* pattern length is configured and may vary from 1 to 4 bytes (see previous register).  */
/* If a length of one byte is configured, bits 7:0 of this register will be transmitted. */
/*  If the length is 4 bytes, bits 7:0 will be transmitted first, and 31:24 will be tran */
/* smitted last.                                                                         */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_DHLD_HLDPAT_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_DHLD_HLDPAT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_GENERAL_CONFIGURATION_DHLD_OFFSET ( 0x00000168 )

#define GPON_TX_GENERAL_CONFIGURATION_DHLD_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_DHLD_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_DHLD_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_DHLD_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_DHLD_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_DHLD_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data_hold_pattern */
	uint32_t hldpat	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DHLD ;
#else
typedef struct
{	uint32_t hldpat	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_hold_pattern */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_DHLD ;
#endif

/*****************************************************************************************/
/* rogue_onu_en                                                                          */
/* enables the measurement of rogue ONU.    If TX_DV will be asserted for a configured t */
/* ime window, then the TX_DV will be shut down and an interrupt will be asserted.       */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_R1_DEFAULT_VALUE                          ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_R1_DEFAULT_VALUE_RESET_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_DV_SEL_GPIO_VALUE                   ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_DV_SEL_GPIO_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_DV_SEL_CDR_VALUE                    ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_DIFF_CLR_DEFAULT_VALUE              ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_DIFF_CLR_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_DIFF_CLR_CLEAR_VALUE                ( 0x1 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_LEVEL_CLR_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_LEVEL_CLR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ROGUE_LEVEL_CLR_CLEAR_VALUE               ( 0x1 )


#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_OFFSET ( 0x00000170 )

#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1             	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_dv_sel */
	uint32_t rogue_dv_sel   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_diff_clear */
	uint32_t rogue_diff_clr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_level_clear */
	uint32_t rogue_level_clr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN ;
#else
typedef struct
{	uint32_t rogue_level_clr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_level_clear */
	uint32_t rogue_diff_clr 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_diff_clear */
	uint32_t rogue_dv_sel   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_dv_sel */
	uint32_t r1             	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN ;
#endif

/*****************************************************************************************/
/* rogue_onu_level_threshold                                                             */
/* num of cycles the dv is allowed to be active before considered as rogue               */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_WINDOW_SIZE_DEFAULT_VALUE             ( 0xFFFFFFFF )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_WINDOW_SIZE_DEFAULT_VALUE_RESET_VALUE ( 0xFFFFFFFF )


#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_OFFSET ( 0x00000174 )

#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* window_size */
	uint32_t window_size	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME ;
#else
typedef struct
{	uint32_t window_size	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* window_size */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME ;
#endif

/*****************************************************************************************/
/* rogue_diff_threshold                                                                  */
/* num of cycles the examined dv is allowed to be different from gpon dv before being co */
/* nsidered as rogue                                                                     */
/*****************************************************************************************/

#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_R1_DEFAULT_VALUE                      ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_R1_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_WINDOW_SIZE_DEFAULT_VALUE             ( 0x3FF )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_WINDOW_SIZE_DEFAULT_VALUE_RESET_VALUE ( 0x3FF )


#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_OFFSET ( 0x00000178 )

#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_ADDRESS   	( GPON_TX_GENERAL_CONFIGURATION_ADDRESS + GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_OFFSET )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_READ( r ) 	READ_32( ( GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_ADDRESS ), (r) )
#define GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_WRITE( v )	WRITE_32( ( GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1         	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* window_size */
	uint32_t window_size	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME ;
#else
typedef struct
{	uint32_t window_size	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* window_size */
	uint32_t r1         	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME ;
#endif

/*****************************************************************************************/
/* Ranging_PLOAM                                                                         */
/* This is an array of 13 bytes for ranging PLOAM buffer. This register can be modified  */
/* only when the corresponding valid bit is inactive.                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_RPLMC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_RPLMC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_OFFSET ( 0x00000000 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ranging_PLOAM_content */
	uint32_t rplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM ;
#else
typedef struct
{	uint32_t rplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ranging_PLOAM_content */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM ;
#endif

/*****************************************************************************************/
/* Idle_PLOAM                                                                            */
/* This is an array of 13 bytes for idle PLOAM buffer. This register can be modified onl */
/* y when TX is disabled.                                                                */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_IPLC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_IPLC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_OFFSET ( 0x00000040 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_content */
	uint32_t iplc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM ;
#else
typedef struct
{	uint32_t iplc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_content */
	uint32_t r1  	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM ;
#endif

/*****************************************************************************************/
/* Urgent_PLOAM                                                                          */
/* This is an array of 13 bytes for urgent PLOAM buffer. This register array can be modi */
/* fied only when the corresponding valid bit is inactive.                               */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_UPLMC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_UPLMC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_OFFSET ( 0x00000080 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM_content */
	uint32_t uplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM ;
#else
typedef struct
{	uint32_t uplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM_content */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM ;
#endif

/*****************************************************************************************/
/* Normal_PLOAM3                                                                         */
/* This is an array of 13 bytes for normal PLOAM3 buffer. This register can be modified  */
/* only when the corresponding valid bit is inactive.                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_NPLMC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_NPLMC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_OFFSET ( 0x000000C0 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_content */
	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3 ;
#else
typedef struct
{	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_content */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3 ;
#endif

/*****************************************************************************************/
/* Normal_PLOAM2                                                                         */
/* This is an array of 13 bytes for normal PLOAM2 buffer. This register can be modified  */
/* only when the corresponding valid bit is inactive.                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_NPLMC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_NPLMC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_OFFSET ( 0x00000100 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_content */
	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2 ;
#else
typedef struct
{	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_content */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2 ;
#endif

/*****************************************************************************************/
/* Normal_PLOAM1                                                                         */
/* This is an array of 13 bytes for normal PLOAM1 buffer. This register can be modified  */
/* only when the corresponding valid bit is inactive.                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_NPLMC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_NPLMC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_OFFSET ( 0x00000140 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_bits */
	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1 ;
#else
typedef struct
{	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_bits */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1 ;
#endif

/*****************************************************************************************/
/* Normal_PLOAM0                                                                         */
/* This is an array of 13 bytes for normal PLOAM0 buffer. Only 13 bytes are used. The tr */
/* ansmitter will transmit this buffer if                                                */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_NPLMC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_NPLMC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_OFFSET ( 0x00000180 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_content */
	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0 ;
#else
typedef struct
{	uint32_t nplmc	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_content */
	uint32_t r1   	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0 ;
#endif

/*****************************************************************************************/
/* Idle_DBR                                                                              */
/* This is a register which contains the 4 first bytes details the idle DBR buffer. modi */
/* fied only when TX is disabled.                                                        */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_IDBCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_IDBCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_OFFSET ( 0x00000200 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Idle_DBR_content */
	uint32_t idbcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR ;
#else
typedef struct
{	uint32_t idbcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR ;
#endif

/*****************************************************************************************/
/* idle_DBR_last_byte                                                                    */
/* The last byte of the Idle DBR                                                         */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_IDBR_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_IDBR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_OFFSET ( 0x00000204 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1  	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_DBR */
	uint32_t idbr	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5 ;
#else
typedef struct
{	uint32_t idbr	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_DBR */
	uint32_t r1  	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR0                                                                           */
/* 4 first bytes for DBR0.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_OFFSET ( 0x00000208 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0 ;
#endif

/*****************************************************************************************/
/* Normal_DBR0                                                                           */
/* The last byte of DBR0                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_OFFSET ( 0x0000020C )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR1                                                                           */
/* 4 first bytes for DBR1.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_OFFSET ( 0x00000210 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1 ;
#endif

/*****************************************************************************************/
/* Normal_DBR1                                                                           */
/* The last byte of DBR1                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_OFFSET ( 0x00000214 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR2                                                                           */
/* 4 first bytes for DBR2.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_OFFSET ( 0x00000218 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2 ;
#endif

/*****************************************************************************************/
/* Normal_DBR2                                                                           */
/* The last byte of DBR2                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_OFFSET ( 0x0000021C )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR3                                                                           */
/* 4 first bytes for DBR3.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_OFFSET ( 0x00000220 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3 ;
#endif

/*****************************************************************************************/
/* Normal_DBR3                                                                           */
/* The last byte of DBR3                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_OFFSET ( 0x00000224 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR4                                                                           */
/* 4 first bytes for DBR4.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_OFFSET ( 0x00000228 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4 ;
#endif

/*****************************************************************************************/
/* Normal_DBR4                                                                           */
/* The last byte of DBR4                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_OFFSET ( 0x0000022C )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR5                                                                           */
/* 4 first bytes for DBR5.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_OFFSET ( 0x00000230 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR5                                                                           */
/* The last byte of DBR5                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_OFFSET ( 0x00000234 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR6                                                                           */
/* 4 first bytes for DBR6.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_OFFSET ( 0x00000238 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6 ;
#endif

/*****************************************************************************************/
/* Normal_DBR6                                                                           */
/* The last byte of DBR6                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_OFFSET ( 0x0000023C )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR7                                                                           */
/* 4 first bytes for DBR7.This register can be modified only when the corresponding vali */
/* d bit is inactive.                                                                    */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_OFFSET ( 0x00000240 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Normal_DBR_content */
	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7 ;
#else
typedef struct
{	uint32_t ndbc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7 ;
#endif

/*****************************************************************************************/
/* Normal_DBR7                                                                           */
/* The last byte of DBR7                                                                 */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_R1_DEFAULT_VALUE                    ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_NDBCBYTE5_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_NDBCBYTE5_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_OFFSET ( 0x00000244 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_ADDRESS   	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_READ( r ) 	READ_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_ADDRESS ), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_WRITE( v )	WRITE_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5 ;
#else
typedef struct
{	uint32_t ndbcbyte5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_byte_5_content */
	uint32_t r1       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5 ;
#endif

/*****************************************************************************************/
/* Normal_DBR_registers_for_TCONTS_8_to_39                                               */
/* 3 bytes DBR registers for DBR 8 to 39 These registers can be modified only when the c */
/* orresponding valid bit is inactive.                                                   */
/*****************************************************************************************/

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_NDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_NDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_OFFSET ( 0x00000248 )

#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_ADDRESS        	( GPON_TX_PLOAM_AND_DBA_MEMORY_ADDRESS + GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_OFFSET )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_READ_I( r, i ) 	READ_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_ADDRESS ), (i), (r) )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1  	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
	uint32_t ndbc	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39 ;
#else
typedef struct
{	uint32_t ndbc	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_content */
	uint32_t r1  	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39 ;
#endif

/*****************************************************************************************/
/* Packet_descriptor_parameters                                                          */
/* This register array contains the packet descriptor parameters. Each of the eight entr */
/* ies in the array relates to one of the first eight Tx queues (ordered 0 to seven) and */
/*   details  the number of packet descriptor allocated to that queue (out of 128). This */
/*  register can be modified only when TX is disabled.                                   */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_PDSC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_PDSC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_PDBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_PDBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_OFFSET ( 0x00000000 )

#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_ADDRESS        	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_PDP_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_READ_I( r, i ) 	READ_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_PDP_ADDRESS ), (i), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_PDP_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Packet_descriptor_size_content */
	uint32_t pdsc	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Packet_descriptor_base_address_content */
	uint32_t pdbc	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_PDP ;
#else
typedef struct
{	uint32_t pdbc	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Packet_descriptor_base_address_content */
	uint32_t pdsc	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Packet_descriptor_size_content */
	uint32_t r1  	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_PDP ;
#endif

/*****************************************************************************************/
/* Packet_descriptor_parameters_for_TCONT_groups_0-3                                     */
/* Tconts 8-39 are bundled in 4 groups of 8 TCONTS each. The SW configure each groups ba */
/* se address for the packet descriptors queues. The packet descriptors Queues within ea */
/* ch group are of the same size. The size is derived from the corresponding data queue  */
/* size. The PD queue size is the corresponding data queue size divided by 64 bytes.  Th */
/* is register array of 4 registers contain the configured base address of each group. T */
/* he first register configures the address of group0 (TCONTS 8-15), and so on.          */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_PDBC_GRP_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_PDBC_GRP_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_OFFSET ( 0x00000020 )

#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_ADDRESS        	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_READ_I( r, i ) 	READ_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_ADDRESS ), (i), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1      	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* base_address_of_the_group */
	uint32_t pdbc_grp	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP ;
#else
typedef struct
{	uint32_t pdbc_grp	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* base_address_of_the_group */
	uint32_t r1      	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP ;
#endif

/*****************************************************************************************/
/* Tx_FIFO_parameter_array                                                               */
/* This register array contains the Tx FIFO parameters of the first 8 of the Tx FIFO que */
/* ues. It gives the base address of each of the first 8 queues and the queues size. A q */
/* ueue size is in 4 bytes resolution and is up to 13 bits  (0-32Kbyte). The total size  */
/* of all 40 queues must be smaller or equal to 20K. The base address must also be 4 byt */
/* es aligned.  This register can be modified only when TX is disabled.                  */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_TQSC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_TQSC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_TQBC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_TQBC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_OFFSET ( 0x00000030 )

#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_ADDRESS        	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_TQP_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_READ_I( r, i ) 	READ_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TQP_ADDRESS ), (i), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TQP_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_queue_size_content */
	uint32_t tqsc	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_queue_base_address_content */
	uint32_t tqbc	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TQP ;
#else
typedef struct
{	uint32_t tqbc	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_queue_base_address_content */
	uint32_t tqsc	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_queue_size_content */
	uint32_t r1  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TQP ;
#endif

/*****************************************************************************************/
/* data_queues_parameters_for_TCONT_groups_0-3                                           */
/* Tconts 8-39 are bundled in 4 groups of 8 TCONTS each. The SW configure each groups ba */
/* se address and size. The Queues within each group are of the same size. This register */
/*  array of 4 registers contain the configured base address of each group. The first re */
/* gister configures the address of group0 (TCONTS 8-15), and so on.                     */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_TDQS_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_TDQS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_TDQB_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_TDQB_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_OFFSET ( 0x00000050 )

#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_ADDRESS        	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_READ_I( r, i ) 	READ_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_ADDRESS ), (i), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* size_of_the_group */
	uint32_t tdqs	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* base_address_of_the_group */
	uint32_t tdqb	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP ;
#else
typedef struct
{	uint32_t tdqb	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* base_address_of_the_group */
	uint32_t tdqs	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* size_of_the_group */
	uint32_t r1  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP ;
#endif

/*****************************************************************************************/
/* Tx_FIFO_TDM_queue_parameters                                                          */
/* This register maps TX TDM flow to one of the forty TX FIFO queues. The mapping includ */
/* ing a single PORT ID, and a queue number. This register can be modified only when TX  */
/* is disabled.                                                                          */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_R1_DEFAULT_VALUE                 ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_TDQPTI_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_TDQPTI_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_TDQ_DEFAULT_VALUE                ( 0x27 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_TDQ_DEFAULT_VALUE_RESET_VALUE    ( 0x27 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_TDQPID_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_TDQPID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_OFFSET ( 0x00000060 )

#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_ADDRESS   	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_TDQP_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_READ( r ) 	READ_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TDQP_ADDRESS ), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQP_WRITE( v )	WRITE_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TDQP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_PTI_bits */
	uint32_t tdqpti	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_queue */
	uint32_t tdq   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_queue_PORT_ID */
	uint32_t tdqpid	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TDQP ;
#else
typedef struct
{	uint32_t tdqpid	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_queue_PORT_ID */
	uint32_t tdq   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_queue */
	uint32_t tdqpti	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_PTI_bits */
	uint32_t r1    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TDQP ;
#endif

/*****************************************************************************************/
/* LoopBack_parameters                                                                   */
/* This register maps the loopback operation mode to one out of the 40 Tx queues (while  */
/* disabling the other queues). This register can be modified only when TX is disabled.  */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_LBQN_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_LBQN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_OFFSET ( 0x00000070 )

#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_ADDRESS   	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_LBP_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_READ( r ) 	READ_32( ( GPON_TX_TX_FIFO_CONFIGURATION_LBP_ADDRESS ), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_LBP_WRITE( v )	WRITE_32( ( GPON_TX_TX_FIFO_CONFIGURATION_LBP_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LoopBack_queue_number */
	uint32_t lbqn	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_LBP ;
#else
typedef struct
{	uint32_t lbqn	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LoopBack_queue_number */
	uint32_t r1  	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_LBP ;
#endif

/*****************************************************************************************/
/* TX_threshold                                                                          */
/* If TDM threshold is enabled then if the requested TDM contains more than min threshol */
/* d valid entries, transmission will be enabled from TDM queue given a request. The TDM */
/*  access size will be the smallest of access size or num of bytes in queue or TDM max  */
/* threshold. This means that if there is more data in the queue than max threshold, max */
/*  threshold bytes of data will be transmitted (if the access is large enough).  If the */
/*  thresholds are disabled, the only condition for transmission is that the queue conta */
/* ins more than min threshold only and there is access for that queue. This register ca */
/* n be modified only when TX is disabled.                                               */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TTHEN_DISABLE_VALUE            ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TTHEN_ENABLE_VALUE             ( 0x1 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TTHEN_ENABLE_VALUE_RESET_VALUE ( 0x1 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TDMMAX_MIN_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TDMMAX_MAX_VALUE               ( 0x7FFF )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TDMMAX_MAX_VALUE_RESET_VALUE   ( 0x7FFF )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TDMMIN_MIN_VALUE               ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TDMMIN_MIN_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_TDMMIN_MAX_VALUE               ( 0x7FFF )


#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_OFFSET ( 0x00000080 )

#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_ADDRESS   	( GPON_TX_TX_FIFO_CONFIGURATION_ADDRESS + GPON_TX_TX_FIFO_CONFIGURATION_TTH_OFFSET )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_READ( r ) 	READ_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TTH_ADDRESS ), (r) )
#define GPON_TX_TX_FIFO_CONFIGURATION_TTH_WRITE( v )	WRITE_32( ( GPON_TX_TX_FIFO_CONFIGURATION_TTH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TDM_threshold_enable */
	uint32_t tthen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_threshold_max */
	uint32_t tdmmax	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_threshold_min */
	uint32_t tdmmin	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TTH ;
#else
typedef struct
{	uint32_t tdmmin	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_threshold_min */
	uint32_t r1    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t tdmmax	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_threshold_max */
	uint32_t tthen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_threshold_enable */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION_TTH ;
#endif

/*****************************************************************************************/
/* TX_queue_counters                                                                     */
/* This register array details the number of valid bytes in each of the forty Tx queues  */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_R1_DEFAULT_VALUE                 ( 0x0 )
#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_TQCNTC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_TQCNTC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_OFFSET ( 0x00000000 )

#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_ADDRESS        	( GPON_TX_TX_FIFO_STATISTICS_ADDRESS + GPON_TX_TX_FIFO_STATISTICS_TQCNTR_OFFSET )
#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_READ_I( r, i ) 	READ_I_32( ( GPON_TX_TX_FIFO_STATISTICS_TQCNTR_ADDRESS ), (i), (r) )
#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_TX_FIFO_STATISTICS_TQCNTR_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_queue_counter_content */
	uint32_t tqcntc	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_STATISTICS_TQCNTR ;
#else
typedef struct
{	uint32_t tqcntc	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_queue_counter_content */
	uint32_t r1    	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_STATISTICS_TQCNTR ;
#endif

/*****************************************************************************************/
/* TX_PD_queue_counters                                                                  */
/* This register array details the number of valid PDs in each of the forty Tx queues    */
/*****************************************************************************************/

#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_R1_DEFAULT_VALUE                   ( 0x0 )
#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_TQPDCNTC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_TQPDCNTC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_OFFSET ( 0x00000100 )

#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_ADDRESS        	( GPON_TX_TX_FIFO_STATISTICS_ADDRESS + GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_OFFSET )
#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_READ_I( r, i ) 	READ_I_32( ( GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_ADDRESS ), (i), (r) )
#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_PD_queue_counter_content */
	uint32_t tqpdcntc	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR ;
#else
typedef struct
{	uint32_t tqpdcntc	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_PD_queue_counter_content */
	uint32_t r1      	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR ;
#endif

/*****************************************************************************************/
/* Illegal_access_counter                                                                */
/* Number of illegal access received and discarded by the transmitter                    */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_IACC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_IACC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_OFFSET ( 0x00000000 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_ADDRESS   	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_READ( r ) 	READ_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_ADDRESS ), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_WRITE( v )	WRITE_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Illegal_access_counter_content */
	uint32_t iacc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC ;
#else
typedef struct
{	uint32_t iacc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Illegal_access_counter_content */
	uint32_t r1  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC ;
#endif

/*****************************************************************************************/
/* Received_access_counter                                                               */
/* This register array contains the number of received access per Tx queue               */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_R1_DEFAULT_VALUE               ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_RACC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_RACC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_OFFSET ( 0x00000004 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_ADDRESS        	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_READ_I( r, i ) 	READ_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_ADDRESS ), (i), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Received_access_counter_content */
	uint32_t racc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC ;
#else
typedef struct
{	uint32_t racc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Received_access_counter_content */
	uint32_t r1  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC ;
#endif

/*****************************************************************************************/
/* Requested_DBR_counter                                                                 */
/* This register array contains the number of requested DBA reports per TX queue         */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_R1_DEFAULT_VALUE                ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_RDBCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_RDBCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_OFFSET ( 0x00000014 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_ADDRESS        	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_READ_I( r, i ) 	READ_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_ADDRESS ), (i), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_DBR_counter_content */
	uint32_t rdbcc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC ;
#else
typedef struct
{	uint32_t rdbcc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_DBR_counter_content */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC ;
#endif

/*****************************************************************************************/
/* Transmitted_packet_counter                                                            */
/* This register array contains the number of transmitted packet per Tx queue            */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_TPCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_TPCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_OFFSET ( 0x00000024 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_ADDRESS        	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_READ_I( r, i ) 	READ_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_ADDRESS ), (i), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Transmitted_packet_counter_content */
	uint32_t tpcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC ;
#else
typedef struct
{	uint32_t tpcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitted_packet_counter_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC ;
#endif

/*****************************************************************************************/
/* Transmitted_gem_fragments_counter                                                     */
/* This register array contains the number of transmitted gem fragments per Tx queue     */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_TGCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_TGCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_OFFSET ( 0x00000034 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_ADDRESS        	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_READ_I( r, i ) 	READ_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_ADDRESS ), (i), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Transmitted_gem_counter_content */
	uint32_t tgcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC ;
#else
typedef struct
{	uint32_t tgcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitted_gem_counter_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC ;
#endif

/*****************************************************************************************/
/* Transmitted_idle_counter                                                              */
/* Overall transmitted idle gem per Tx queue                                             */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_TIC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_TIC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_OFFSET ( 0x00000044 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_ADDRESS        	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_READ_I( r, i ) 	READ_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_ADDRESS ), (i), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_WRITE_I( v, i )	WRITE_I_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_ADDRESS ), (i), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Transmitted_idle_counter */
	uint32_t tic	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC ;
#else
typedef struct
{	uint32_t tic	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitted_idle_counter */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC ;
#endif

/*****************************************************************************************/
/* Requested_idle_PLOAM_counter                                                          */
/* Requested idle PLOAM counter                                                          */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_IPCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_IPCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_OFFSET ( 0x00000054 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_ADDRESS   	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_READ( r ) 	READ_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_ADDRESS ), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_WRITE( v )	WRITE_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Idle_PLOAM_counter_content */
	uint32_t ipcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC ;
#else
typedef struct
{	uint32_t ipcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM_counter_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC ;
#endif

/*****************************************************************************************/
/* Requested_normal_PLOAM_counter                                                        */
/* Requested Normal PLOAM counter                                                        */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_RNPCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_RNPCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_OFFSET ( 0x00000058 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_ADDRESS   	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_READ( r ) 	READ_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_ADDRESS ), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_WRITE( v )	WRITE_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Requested_normal_PLOAM_counter_content */
	uint32_t rnpcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC ;
#else
typedef struct
{	uint32_t rnpcc	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_normal_PLOAM_counter_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC ;
#endif

/*****************************************************************************************/
/* Requested_special_PLOAM_counter                                                       */
/* Requested special PLOAM counter. Including urgent PLOAM counter & ranging PLOAM count */
/* er                                                                                    */
/*****************************************************************************************/

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_RRPCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_RRPCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_RUPCC_DEFAULT_VALUE             ( 0x0 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_RUPCC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_OFFSET ( 0x00000060 )

#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_ADDRESS   	( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_ADDRESS + GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_OFFSET )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_READ( r ) 	READ_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_ADDRESS ), (r) )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_WRITE( v )	WRITE_32( ( GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Request_ranging_PLOAM_counter_content */
	uint32_t rrpcc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_urgent_PLOAM_counter_content */
	uint32_t rupcc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC ;
#else
typedef struct
{	uint32_t rupcc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_urgent_PLOAM_counter_content */
	uint32_t rrpcc	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Request_ranging_PLOAM_counter_content */
}
__PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC ;
#endif

typedef struct
{
	/* Receiver_Status */
	GPON_RX_GENERAL_CONFIG_RCVR_STATUS rcvr_status __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Receiver_General_Configuration */
	GPON_RX_GENERAL_CONFIG_RCVR_CONFIG rcvr_config __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Loss_of_Frame_parameters */
	GPON_RX_GENERAL_CONFIG_LOF_PARAMS lof_params __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Random_Seed */
	GPON_RX_GENERAL_CONFIG_RANDOMSD randomsd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GENERAL_CONFIG ;

typedef struct
{
	/* Interrupt_status_register */
	GPON_RX_IRQ_GRXISR grxisr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_register */
	GPON_RX_IRQ_GRXIER grxier __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_test_register */
	GPON_RX_IRQ_GRXITR grxitr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_IRQ ;

/*****************************************************************************************/
/* The following register provide control over the ONU_ID and the way PLOAM messages are */
/*  filtered and handled.                                                                */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_PLOAM_ONU_ID_NUMBER ( 2 )
typedef struct
{
	/* ONU_ID_settings */
	GPON_RX_PLOAM_ONU_ID onu_id [ GPON_RX_PLOAM_ONU_ID_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_Processor_Parameters */
	GPON_RX_PLOAM_PARAMS params __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PLOAM ;

/*****************************************************************************************/
/* The following registers provide control over which Alloc-IDs are assigned to the ONU  */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_ALLOC_ID_ALC_ID_CFG_NUMBER ( 40 )
#define GPON_RX_ALLOC_ID_ALC_ID_EN_NUMBER ( 5 )
#define GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_NUMBER ( 10 )
typedef struct
{
	/* Ranging_Alloc_ID_Configuration */
	GPON_RX_ALLOC_ID_RANG_ALC_ID rang_alc_id __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc_ID_Configuration */
	GPON_RX_ALLOC_ID_ALC_ID_CFG alc_id_cfg [ GPON_RX_ALLOC_ID_ALC_ID_CFG_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ranging_alloc_ID_enable */
	GPON_RX_ALLOC_ID_RANG_ALC_ID_EN rang_alc_id_en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Alloc_ID_Enable */
	GPON_RX_ALLOC_ID_ALC_ID_EN alc_id_en [ GPON_RX_ALLOC_ID_ALC_ID_EN_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_id_to_TCONT_association */
	GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC alc_tcnt_assoc [ GPON_RX_ALLOC_ID_ALC_TCNT_ASSOC_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bandwidth_counters_association */
	GPON_RX_ALLOC_ID_BW_CNT_ASSOC bw_cnt_assoc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ALLOC_ID ;

typedef struct
{
	/* clock_8KHz_phase_lock_mechanism */
	GPON_RX_CLK_8KHZ_CLK8KCONF clk8kconf __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_CLK_8KHZ ;

typedef struct
{
	/* congestion_thresholds */
	GPON_RX_CONGESTION_THRESH thresh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_CONGESTION ;

/*****************************************************************************************/
/* The following registers provide control over which Port-IDs are assigned to the ONU a */
/* nd their parameters                                                                   */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_PORT_ID_FULLCFG_NUMBER ( 32 )
#define GPON_RX_PORT_ID_CFG_NUMBER ( 224 )
#define GPON_RX_PORT_ID_DISABLE_NUMBER ( 8 )
typedef struct
{
	/* PortID_Full_Configuration */
	GPON_RX_PORT_ID_FULLCFG fullcfg [ GPON_RX_PORT_ID_FULLCFG_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PortID_Configuration */
	GPON_RX_PORT_ID_CFG cfg [ GPON_RX_PORT_ID_CFG_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PortID_Disable */
	GPON_RX_PORT_ID_DISABLE disable [ GPON_RX_PORT_ID_DISABLE_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PortID_Mask */
	GPON_RX_PORT_ID_MASK mask __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Last_Fragment_Indication_Mask */
	GPON_RX_PORT_ID_LASTIND lastind __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PORT_ID ;

/*****************************************************************************************/
/* The following registers provide control over ONU decryption functions and key managem */
/* ent                                                                                   */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_ENCRYPTION_KEY_NUMBER ( 4 )
typedef struct
{
	/* Superframe_Counter */
	GPON_RX_ENCRYPTION_SF_CNTR sf_cntr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Decryption_Key */
	GPON_RX_ENCRYPTION_KEY key [ GPON_RX_ENCRYPTION_KEY_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Key_Switch_Time */
	GPON_RX_ENCRYPTION_SWITCH_TIME switch_time __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_ENCRYPTION ;

/*****************************************************************************************/
/* The following registers are used for setting the amendment 2 configurations such as 1 */
/* PPS clock duty cycle, TOD clock update frame, etc.                                    */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_AMD2_TOD_UP_VAL_NUMBER ( 2 )
typedef struct
{
	/* tod_update_time */
	GPON_RX_AMD2_TOD_SF_UP tod_sf_up __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tod_update_val */
	GPON_RX_AMD2_TOD_UP_VAL tod_up_val [ GPON_RX_AMD2_TOD_UP_VAL_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tod_update_arm */
	GPON_RX_AMD2_TOD_ARM tod_arm __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tod_clocks_in_sec */
	GPON_RX_AMD2_TOD_CYC_IN_SEC tod_cyc_in_sec __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tod_opps_duty_cycle */
	GPON_RX_AMD2_TOD_OPPS_DUTY tod_opps_duty __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_AMD2 ;

/*****************************************************************************************/
/* The following registers provide PM counters for statistics collection by the SW.  All */
/*  counters stuck on max value, according to its size. For expmple, a 32 bit counter wi */
/* ll be stuck on 0xFFFF_FFFF.                                                           */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_PM_COUNTER_BW_CNT_NUMBER ( 4 )
typedef struct
{
	/* CRC_Errors_in_the_US_BW_Map_field */
	GPON_RX_PM_COUNTER_BWMAPERR bwmaperr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_Errors_in_PLOAM_field */
	GPON_RX_PM_COUNTER_PLOAMERR ploamerr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_Errors_in_Plend_field */
	GPON_RX_PM_COUNTER_PLENDERR plenderr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Superframe_counter_mismatch_counter */
	GPON_RX_PM_COUNTER_SFMISMATCH sfmismatch __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP_Error_Counter */
	GPON_RX_PM_COUNTER_BIP bip __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Non_idle_GEM_fragments_received */
	GPON_RX_PM_COUNTER_GEMFRAG gemfrag __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ethernet_packets_directed_at_ONU */
	GPON_RX_PM_COUNTER_ETHPACK ethpack __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_fragments_directed_at_ONU */
	GPON_RX_PM_COUNTER_TDMFRAG tdmfrag __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Symbol_Errors_Corrected */
	GPON_RX_PM_COUNTER_SYMERROR symerror __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Bit_Errors_Corrected */
	GPON_RX_PM_COUNTER_BITERROR biterror __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AES_Machine_Allocation_Errors */
	GPON_RX_PM_COUNTER_AESERROR aeserror __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TDM_Statistics */
	GPON_RX_PM_COUNTER_TDMSTATS tdmstats __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_Ethernet_fragments */
	GPON_RX_PM_COUNTER_ETHFRAG ethfrag __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Total_number_of_Ethernet_bytes_received_after_fil */
	GPON_RX_PM_COUNTER_ETHBYTECNT ethbytecnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_Uncorrectable_Codeword_counter */
	GPON_RX_PM_COUNTER_FECUCCWCNT fecuccwcnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FEC_correctable_Codeword_counter */
	GPON_RX_PM_COUNTER_FECCCWCNT fecccwcnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* valid_ploam_cnt_onuid */
	GPON_RX_PM_COUNTER_PLONUCNT plonucnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* valid_ploam_cnt_broadcast */
	GPON_RX_PM_COUNTER_PLBCSTCNT plbcstcnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bandwidth_alloc_cnt */
	GPON_RX_PM_COUNTER_BW_CNT bw_cnt [ GPON_RX_PM_COUNTER_BW_CNT_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_PM_COUNTER ;

/*****************************************************************************************/
/* The configurations determine which accesses to record, and when to stop recording.    */
/*  The result indicate that the record is done, how many accesses were recorded and if  */
/* there was an overflow in the recording memory.    The read interface allow the SW to  */
/* read the memory. The SW sets the read address and can read the data right after assum */
/* ing it is ready.    The SW is not allowed to access the read interface register from  */
/* the assertion of record enable to the assertion of record done.                       */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_RX_BWMAP_RECORD_RDATA_NUMBER ( 2 )
typedef struct
{
	/* bw_rcd_configuration */
	GPON_RX_BWMAP_RECORD_CONFIG config __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_rcd_en */
	GPON_RX_BWMAP_RECORD_ENABLE enable __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_rcd_result */
	GPON_RX_BWMAP_RECORD_STATUS status __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_rcd_rd_if */
	GPON_RX_BWMAP_RECORD_READ_IF read_if __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bw_rcd_rdata */
	GPON_RX_BWMAP_RECORD_RDATA rdata [ GPON_RX_BWMAP_RECORD_RDATA_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_BWMAP_RECORD ;

typedef struct
{
	/* GPON_Debug_bus_selector */
	GPON_RX_GRX_DEBUG_DBG_SEL dbg_sel __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX_GRX_DEBUG ;

typedef struct
{
	/* Tx_ranging_delay */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDLY tdly __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_enable_register */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_TEN ten __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_polarity */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_POL pol __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM_repetition */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_NPREP nprep __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_PLOAM_valid_information */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPVLD tpvld __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_DBR_valid_information */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBVLD tdbvld __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_DBR_configuration */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_TDBCONF tdbconf __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_PLOAM_clear_content */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL_TPCLR tpclr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_TRANSMITTER_CONTROL ;

typedef struct
{
	/* Interrupt_status_register_0 */
	GPON_TX_INTERRUPT_CONTROLLER_TXISR0 txisr0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_status_register_1 */
	GPON_TX_INTERRUPT_CONTROLLER_TXISR1 txisr1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_status_register_2 */
	GPON_TX_INTERRUPT_CONTROLLER_TXISR2 txisr2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_register_0 */
	GPON_TX_INTERRUPT_CONTROLLER_TXIER0 txier0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_register_1 */
	GPON_TX_INTERRUPT_CONTROLLER_TXIER1 txier1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_enable_register_2 */
	GPON_TX_INTERRUPT_CONTROLLER_TXIER2 txier2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_test_register_0 */
	GPON_TX_INTERRUPT_CONTROLLER_TXITR0 txitr0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_test_register_1 */
	GPON_TX_INTERRUPT_CONTROLLER_TXITR1 txitr1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_test_register_2 */
	GPON_TX_INTERRUPT_CONTROLLER_TXITR2 txitr2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_INTERRUPT_CONTROLLER ;

/*****************************************************************************************/
/* The following registers specify the transceiver I/F signals, frame structures and par */
/* ameters.                                                                              */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_TX_GENERAL_CONFIGURATION_PROD_NUMBER ( 16 )
typedef struct
{
	/* ONU_ID */
	GPON_TX_GENERAL_CONFIGURATION_ONUID onuid __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Indication_field */
	GPON_TX_GENERAL_CONFIGURATION_IND ind __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Preamble_overhead */
	GPON_TX_GENERAL_CONFIGURATION_PROD prod [ GPON_TX_GENERAL_CONFIGURATION_PROD_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Preamble_overhead_specifications */
	GPON_TX_GENERAL_CONFIGURATION_PRODS prods __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Preamble_repetition_byte */
	GPON_TX_GENERAL_CONFIGURATION_PRRB prrb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Delimiter_content */
	GPON_TX_GENERAL_CONFIGURATION_DELC delc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Misc_access_content1 */
	GPON_TX_GENERAL_CONFIGURATION_MISCAC1 miscac1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Misc_access_content2 */
	GPON_TX_GENERAL_CONFIGURATION_MISCAC2 miscac2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved6 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Enable_short_allocations */
	GPON_TX_GENERAL_CONFIGURATION_ESALL esall __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved7 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tcont_to_counter_group_association */
	GPON_TX_GENERAL_CONFIGURATION_QFORCNTR qforcntr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved8 [ 92 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLS_specification */
	GPON_TX_GENERAL_CONFIGURATION_PLSS plss __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved9 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLS_repetition_specifications */
	GPON_TX_GENERAL_CONFIGURATION_PLSRS plsrs __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved10 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BIP_specifications */
	GPON_TX_GENERAL_CONFIGURATION_BIPS bips __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved11 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_offset */
	GPON_TX_GENERAL_CONFIGURATION_CRCOFF crcoff __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* single_TCONT_flush */
	GPON_TX_GENERAL_CONFIGURATION_FLUSH flush __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush_done */
	GPON_TX_GENERAL_CONFIGURATION_FLSHDN flshdn __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* buffer_ready_indications_update_set */
	GPON_TX_GENERAL_CONFIGURATION_RDYIND rdyind __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_specifications_polarity_and_extension_enable */
	GPON_TX_GENERAL_CONFIGURATION_DVSLP dvslp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_specifications_setup_pattern */
	GPON_TX_GENERAL_CONFIGURATION_DVSTP dvstp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DV_specifications_hold_pattern */
	GPON_TX_GENERAL_CONFIGURATION_DVHLD dvhld __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved12 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_pattern_enable */
	GPON_TX_GENERAL_CONFIGURATION_DPEN dpen __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_setup_pattern */
	GPON_TX_GENERAL_CONFIGURATION_DSTP dstp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_hold_pattern */
	GPON_TX_GENERAL_CONFIGURATION_DHLD dhld __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved13 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_onu_en */
	GPON_TX_GENERAL_CONFIGURATION_ROGUE_ONU_EN rogue_onu_en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_onu_level_threshold */
	GPON_TX_GENERAL_CONFIGURATION_ROGUE_LEVEL_TIME rogue_level_time __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rogue_diff_threshold */
	GPON_TX_GENERAL_CONFIGURATION_ROGUE_DIFF_TIME rogue_diff_time __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_GENERAL_CONFIGURATION ;

/*****************************************************************************************/
/* The following registers define the memory structure for storing the PLOAM and DBA buf */
/* fers to be transmitted. These buffers are written by software, and read by the transm */
/* itter. The handshake mechanism is described above, in TPVLD register description. Whe */
/* n a PLOAM access is received, the transmitter looks for ranging PLOAM if ranging acce */
/* ss and ranging valid bit is asserted. If not, the transmitter looks for an urgent PLO */
/* AM buffer. If not available, then the normal PLOAM is looked for, and last, the idle  */
/* PLOAM is sent.                                                                        */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_NUMBER ( 13 )
#define GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_NUMBER ( 32 )
typedef struct
{
	/* Ranging_PLOAM */
	GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM rplm [ GPON_TX_PLOAM_AND_DBA_MEMORY_RPLM_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_PLOAM */
	GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM iplm [ GPON_TX_PLOAM_AND_DBA_MEMORY_IPLM_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_PLOAM */
	GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM uplm [ GPON_TX_PLOAM_AND_DBA_MEMORY_UPLM_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM3 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3 nplm3 [ GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM3_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM2 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2 nplm2 [ GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM2_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM1 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1 nplm1 [ GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM1_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved6 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_PLOAM0 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0 nplm0 [ GPON_TX_PLOAM_AND_DBA_MEMORY_NPLM0_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved7 [ 76 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Idle_DBR */
	GPON_TX_PLOAM_AND_DBA_MEMORY_IDBR idbr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* idle_DBR_last_byte */
	GPON_TX_PLOAM_AND_DBA_MEMORY_IDBRBYTE5 idbrbyte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR0 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0 ndbr0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR0 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR0BYTE5 ndbr0byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR1 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1 ndbr1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR1 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR1BYTE5 ndbr1byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR2 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2 ndbr2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR2 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR2BYTE5 ndbr2byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR3 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3 ndbr3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR3 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR3BYTE5 ndbr3byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR4 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4 ndbr4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR4 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR4BYTE5 ndbr4byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR5 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5 ndbr5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR5 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR5BYTE5 ndbr5byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR6 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6 ndbr6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR6 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR6BYTE5 ndbr6byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR7 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7 ndbr7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR7 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR7BYTE5 ndbr7byte5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_DBR_registers_for_TCONTS_8_to_39 */
	GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39 ndbr8to39 [ GPON_TX_PLOAM_AND_DBA_MEMORY_NDBR8TO39_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_PLOAM_AND_DBA_MEMORY ;

/*****************************************************************************************/
/* The TX FIFO supports 8 FIFO queues, one per TCONT for upstream buffer storage. The ov */
/* erall FIFO size is 8Kbytes. The TX FIFO is accompanied with 128 entries packet descri */
/* ptor memory. It is assumed that PD size is sufficient as in the normal case packets w */
/* hich reside in the queue are at least 8 bytes each                                    */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_TX_TX_FIFO_CONFIGURATION_PDP_NUMBER ( 8 )
#define GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_NUMBER ( 4 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TQP_NUMBER ( 8 )
#define GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_NUMBER ( 4 )
typedef struct
{
	/* Packet_descriptor_parameters */
	GPON_TX_TX_FIFO_CONFIGURATION_PDP pdp [ GPON_TX_TX_FIFO_CONFIGURATION_PDP_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Packet_descriptor_parameters_for_TCONT_groups_0-3 */
	GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP pdpgrp [ GPON_TX_TX_FIFO_CONFIGURATION_PDPGRP_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_FIFO_parameter_array */
	GPON_TX_TX_FIFO_CONFIGURATION_TQP tqp [ GPON_TX_TX_FIFO_CONFIGURATION_TQP_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_queues_parameters_for_TCONT_groups_0-3 */
	GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP tdqpgrp [ GPON_TX_TX_FIFO_CONFIGURATION_TDQPGRP_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Tx_FIFO_TDM_queue_parameters */
	GPON_TX_TX_FIFO_CONFIGURATION_TDQP tdqp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LoopBack_parameters */
	GPON_TX_TX_FIFO_CONFIGURATION_LBP lbp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_threshold */
	GPON_TX_TX_FIFO_CONFIGURATION_TTH tth __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_CONFIGURATION ;

/*****************************************************************************************/
/* TX FIFO supports 40 FIFO queues. The TX FIFO statistics function details each of the  */
/* queue status                                                                          */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_TX_TX_FIFO_STATISTICS_TQCNTR_NUMBER ( 40 )
#define GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_NUMBER ( 40 )
typedef struct
{
	/* TX_queue_counters */
	GPON_TX_TX_FIFO_STATISTICS_TQCNTR tqcntr [ GPON_TX_TX_FIFO_STATISTICS_TQCNTR_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 96 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_PD_queue_counters */
	GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR tqpdcntr [ GPON_TX_TX_FIFO_STATISTICS_TQPDCNTR_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_TX_FIFO_STATISTICS ;

/*****************************************************************************************/
/* The following Registers are a set of statistic counters of the transmitted packets an */
/* d GEM fragments                                                                       */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_NUMBER ( 4 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_NUMBER ( 4 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_NUMBER ( 4 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_NUMBER ( 4 )
#define GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_NUMBER ( 4 )
typedef struct
{
	/* Illegal_access_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_IAC iac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Received_access_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC rac [ GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RAC_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_DBR_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC rdbc [ GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RDBC_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitted_packet_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC tpc [ GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TPC_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitted_gem_fragments_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC tgc [ GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TGC_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Transmitted_idle_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC tic [ GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_TIC_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_idle_PLOAM_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RIPC ripc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_normal_PLOAM_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RNPC rnpc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Requested_special_PLOAM_counter */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS_RSPC rspc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX_STATISTICS_COUNTERS_FUNCTIONS ;

typedef struct
{
	/* general_config function */
	GPON_RX_GENERAL_CONFIG general_config __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* irq function */
	GPON_RX_IRQ irq __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved0 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ploam function */
	GPON_RX_PLOAM ploam __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_id function */
	GPON_RX_ALLOC_ID alloc_id __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* clk_8khz function */
	GPON_RX_CLK_8KHZ clk_8khz __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* congestion function */
	GPON_RX_CONGESTION congestion __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 204 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* port_id function */
	GPON_RX_PORT_ID port_id __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 216 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* encryption function */
	GPON_RX_ENCRYPTION encryption __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved6 [ 232 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* amd2 function */
	GPON_RX_AMD2 amd2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved7 [ 488 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pm_counter function */
	GPON_RX_PM_COUNTER pm_counter __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved8 [ 40 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bwmap_record function */
	GPON_RX_BWMAP_RECORD bwmap_record __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved9 [ 104 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* grx_debug function */
	GPON_RX_GRX_DEBUG grx_debug __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_RX ;

typedef struct
{
	/* general_transmitter_control function */
	GPON_TX_GENERAL_TRANSMITTER_CONTROL general_transmitter_control __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved0 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* interrupt_controller function */
	GPON_TX_INTERRUPT_CONTROLLER interrupt_controller __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* general_configuration function */
	GPON_TX_GENERAL_CONFIGURATION general_configuration __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 268 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ploam_and_dba_memory function */
	GPON_TX_PLOAM_AND_DBA_MEMORY ploam_and_dba_memory __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 204 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx_fifo_configuration function */
	GPON_TX_TX_FIFO_CONFIGURATION tx_fifo_configuration __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 660 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* tx_fifo_statistics function */
	GPON_TX_TX_FIFO_STATISTICS tx_fifo_statistics __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 192 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* statistics_counters_functions function */
	GPON_TX_STATISTICS_COUNTERS_FUNCTIONS statistics_counters_functions __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
GPON_TX ;

typedef struct
{
	/* RX */
	GPON_RX rx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 2588 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX */
	GPON_TX tx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
GPON_FOR_ALL ;
#endif /* GPON_H_INCLUDED */

