/*
 * <:copyright-BRCM:2013:DUAL/GPL:standard
 *
 *    Copyright (c) 2013 Broadcom Corporation
 *    All Rights Reserved
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed
 * to you under the terms of the GNU General Public License version 2
 * (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 * with the following added to such license:
 *
 *    As a special exception, the copyright holders of this software give
 *    you permission to link this software with independent modules, and
 *    to copy and distribute the resulting executable under terms of your
 *    choice, provided that you also meet, for each linked independent
 *    module, the terms and conditions of the license of that module.
 *    An independent module is a module which is not derived from this
 *    software.  The special exception does not apply to any modifications
 *    of the software.
 *
 * Not withstanding the above, under no circumstances may you combine
 * this software in any way with any other Broadcom software provided
 * under a license other than the GPL, without Broadcom's express prior
 * written consent.
 *
 * :>
 */

// FORMAT: notabs uncrustify:bcm_minimal_i4.cfg

#include "boardparms.h"

#ifdef _CFE_
#include "lib_types.h"
#include "lib_printf.h"
#include "lib_string.h"
#include "bcm_map.h"
#define printk  printf
#else // Linux
#include <linux/kernel.h>
#include <linux/module.h>
#include <bcm_map_part.h>
#include <linux/string.h>
#endif

#include "bcm_misc_hw_init.h"

void bcm_misc_hw_init(void)
{
    {
        unsigned short PhyBaseAddr;
        if( BpGetEphyBaseAddress(&PhyBaseAddr) == BP_SUCCESS ) {
            MISC_REG->EphyPhyAd &= ~EPHY_PHYAD_MASK;
            MISC_REG->EphyPhyAd |= (EPHY_PHYAD_MASK & PhyBaseAddr);
        }
    }

}



#ifndef _CFE_
arch_initcall(bcm_misc_hw_init);
#endif

