/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.rtf.RtfAddableElement;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfShapeProperty
extends RtfAddableElement {
    public static final String PROPERTY_VERTICIES = "pVerticies";
    public static final String PROPERTY_GEO_TOP = "geoTop";
    public static final String PROPERTY_GEO_LEFT = "geoLeft";
    public static final String PROPERTY_GEO_RIGHT = "geoRight";
    public static final String PROPERTY_GEO_BOTTOM = "geoBottom";
    public static final String PROPERTY_LAYOUT_IN_CELL = "fLayoutInCell";
    public static final String PROPERTY_FLIP_V = "fFlipV";
    public static final String PROPERTY_FLIP_H = "fFlipH";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    public static final String PROPERTY_ADJUST_VALUE = "adjustValue";
    private static final int PROPERTY_TYPE_LONG = 1;
    private static final int PROPERTY_TYPE_BOOLEAN = 2;
    private static final int PROPERTY_TYPE_DOUBLE = 3;
    private static final int PROPERTY_TYPE_COLOR = 4;
    private static final int PROPERTY_TYPE_ARRAY = 5;
    private int type = 0;
    private String name = "";
    private Object value = null;

    private RtfShapeProperty(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public RtfShapeProperty(String name, long value) {
        this(name, new Long(value));
        this.type = 1;
    }

    public RtfShapeProperty(String name, double value) {
        this(name, new Double(value));
        this.type = 3;
    }

    public RtfShapeProperty(String name, boolean value) {
        this(name, new Boolean(value));
        this.type = 2;
    }

    public RtfShapeProperty(String name, Color value) {
        this(name, (Object)value);
        this.type = 4;
    }

    public RtfShapeProperty(String name, int[] value) {
        this(name, (Object)value);
        this.type = 5;
    }

    public RtfShapeProperty(String name, Point[] value) {
        this(name, (Object)value);
        this.type = 5;
    }

    public String getName() {
        return this.name;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(OPEN_GROUP);
            result.write("\\sp".getBytes());
            result.write(OPEN_GROUP);
            result.write("\\sn".getBytes());
            result.write(DELIMITER);
            result.write(this.name.getBytes());
            result.write(CLOSE_GROUP);
            result.write(OPEN_GROUP);
            result.write("\\sv".getBytes());
            result.write(DELIMITER);
            switch (this.type) {
                case 1: 
                case 3: {
                    result.write(this.value.toString().getBytes());
                    break;
                }
                case 2: {
                    if (((Boolean)this.value).booleanValue()) {
                        result.write("1".getBytes());
                        break;
                    }
                    result.write("0".getBytes());
                    break;
                }
                case 4: {
                    result.write(this.intToByteArray(((Color)this.value).getRGB()));
                    break;
                }
                case 5: {
                    if (this.value instanceof int[]) {
                        int[] values = (int[])this.value;
                        result.write("4;".getBytes());
                        result.write(this.intToByteArray(values.length));
                        result.write(COMMA_DELIMITER);
                        for (int i = 0; i < values.length; ++i) {
                            result.write(this.intToByteArray(values[i]));
                            if (i >= values.length - 1) continue;
                            result.write(COMMA_DELIMITER);
                        }
                    } else {
                        if (!(this.value instanceof Point[])) break;
                        Point[] values = (Point[])this.value;
                        result.write("8;".getBytes());
                        result.write(this.intToByteArray(values.length));
                        result.write(COMMA_DELIMITER);
                        for (int i = 0; i < values.length; ++i) {
                            result.write("(".getBytes());
                            result.write(this.intToByteArray(values[i].x));
                            result.write(",".getBytes());
                            result.write(this.intToByteArray(values[i].y));
                            result.write(")".getBytes());
                            if (i >= values.length - 1) continue;
                            result.write(COMMA_DELIMITER);
                        }
                    }
                    break;
                }
            }
            result.write(CLOSE_GROUP);
            result.write(CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

