/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.kotlin.io.vavr.collection.AbstractIterator;
import org.jetbrains.kotlin.io.vavr.collection.LinearSeq;
import org.jetbrains.kotlin.io.vavr.collection.Queue;
import org.jetbrains.kotlin.io.vavr.collection.Stream;

interface StreamModule {

    public static final class StreamIterator<T>
    extends AbstractIterator<T> {
        private Supplier<Stream<T>> current = () -> stream;

        StreamIterator(Stream.Cons<T> stream) {
        }

        @Override
        public boolean hasNext() {
            return !this.current.get().isEmpty();
        }

        @Override
        public T getNext() {
            Stream<T> stream = this.current.get();
            this.current = stream::tail;
            return stream.head();
        }
    }

    public static interface StreamFactory {
        public static <T> Stream<T> create(Iterator<? extends T> iterator2) {
            return iterator2.hasNext() ? Stream.cons(iterator2.next(), () -> StreamFactory.create(iterator2)) : Stream.Empty.instance();
        }
    }

    public static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Stream.Cons<T> stream;

        SerializationProxy(Stream.Cons<T> stream) {
            this.stream = stream;
        }

        private void writeObject(ObjectOutputStream s2) throws IOException {
            s2.defaultWriteObject();
            s2.writeInt(this.stream.length());
            LinearSeq<T> l2 = this.stream;
            while (!l2.isEmpty()) {
                s2.writeObject(l2.head());
                l2 = l2.tail();
            }
        }

        private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
            s2.defaultReadObject();
            int size = s2.readInt();
            if (size <= 0) {
                throw new InvalidObjectException("No elements");
            }
            LinearSeq temp = Stream.Empty.instance();
            for (int i2 = 0; i2 < size; ++i2) {
                Object element = s2.readObject();
                temp = temp.append(element);
            }
            this.stream = (Stream.Cons)temp;
        }

        private Object readResolve() {
            return this.stream;
        }
    }

    public static final class AppendElements<T>
    extends Stream.Cons<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Queue<T> queue;

        AppendElements(T head, Queue<T> queue, Supplier<Stream<T>> tail) {
            super(head, tail);
            this.queue = queue;
        }

        @Override
        public Stream<T> append(T element) {
            return new AppendElements<Object>(this.head, (Queue<Object>)this.queue.append((Object)element), this.tail);
        }

        @Override
        public Stream<T> appendAll(Iterable<? extends T> elements) {
            Objects.requireNonNull(elements, "elements is null");
            return this.isEmpty() ? Stream.ofAll(this.queue) : new AppendElements<Object>(this.head, (Queue<Object>)this.queue.appendAll((Iterable)elements), this.tail);
        }

        @Override
        public Stream<T> tail() {
            Stream t2 = (Stream)this.tail.get();
            if (t2.isEmpty()) {
                return Stream.ofAll(this.queue);
            }
            if (t2 instanceof ConsImpl) {
                ConsImpl c2 = (ConsImpl)t2;
                return new AppendElements(c2.head(), this.queue, c2.tail);
            }
            AppendElements a2 = (AppendElements)t2;
            return new AppendElements(a2.head(), a2.queue.appendAll((Iterable)this.queue), a2.tail);
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }

    public static final class ConsImpl<T>
    extends Stream.Cons<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ConsImpl(T head, Supplier<Stream<T>> tail) {
            super(head, tail);
        }

        @Override
        public Stream<T> tail() {
            return (Stream)this.tail.get();
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }
}

