/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultParameterContext
implements ParameterContext {
    private final Parameter parameter;
    private final int index;
    private final Optional<Object> target;

    DefaultParameterContext(Parameter parameter, int index, Optional<Object> target) {
        Preconditions.condition((index >= 0 ? 1 : 0) != 0, (String)"index must be greater than or equal to zero");
        this.parameter = (Parameter)Preconditions.notNull((Object)parameter, (String)"parameter must not be null");
        this.index = index;
        this.target = (Optional)Preconditions.notNull(target, (String)"target must not be null");
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public int getIndex() {
        return this.index;
    }

    public Optional<Object> getTarget() {
        return this.target;
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotated((Parameter)this.parameter, (int)this.index, annotationType);
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return AnnotationUtils.findAnnotation((Parameter)this.parameter, (int)this.index, annotationType);
    }

    public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType) {
        return AnnotationUtils.findRepeatableAnnotations((Parameter)this.parameter, (int)this.index, annotationType);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("parameter", (Object)this.parameter).append("index", (Object)this.index).append("target", this.target).toString();
    }
}

