/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Method;
import org.junit.runner.Description;
import org.testng.internal.ConstructorOrMethod;

public class JUnit4SpockMethod
extends ConstructorOrMethod {
    private static final Class<?> SPOCK_SPEC_CLASS = JUnit4SpockMethod.getSpockSpecClass();
    private final Class<?> declaringClass;
    private final String description;

    private static Class<?> getSpockSpecClass() {
        try {
            return Class.forName("spock.lang.Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean isSpockClass(Class<?> clazz) {
        return SPOCK_SPEC_CLASS != null && SPOCK_SPEC_CLASS.isAssignableFrom(clazz);
    }

    public JUnit4SpockMethod(Description description) {
        super((Method)null);
        this.declaringClass = description.getTestClass();
        this.description = description.getDisplayName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.description;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

