/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class RoseTree<T> {
    private final T value;
    private List<RoseTree<T>> children;

    public RoseTree(T value, List<RoseTree<T>> children) {
        this.value = value;
        this.children = children != null ? new ArrayList<RoseTree<T>>(children) : null;
    }

    public RoseTree(T value) {
        this.value = value;
        this.children = null;
    }

    public synchronized void addChild(RoseTree<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<RoseTree<T>>();
        }
        this.children.add(child);
    }

    public T getValue() {
        return this.value;
    }

    public List<RoseTree<T>> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public Stream<T> flatten() {
        if (this.children == null) {
            return Stream.of(this.value);
        }
        return Stream.concat(Stream.of(this.value), this.children.stream().flatMap(RoseTree::flatten));
    }
}

