/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

import com.vladsch.flexmark.util.misc.Paired;
import java.util.Map;
import java.util.Objects;

public final class Pair<K, V>
implements Paired<K, V> {
    private final K first;
    private final V second;

    public static <K1, V1> Pair<K1, V1> of(K1 first, V1 second) {
        return new Pair<K1, V1>(first, second);
    }

    public Pair(K first, V second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public K getFirst() {
        return this.first;
    }

    @Override
    public V getSecond() {
        return this.second;
    }

    @Override
    public K getKey() {
        return this.first;
    }

    @Override
    public V getValue() {
        return this.second;
    }

    @Override
    public V setValue(V value) {
        throw new IllegalStateException("setValue not supported");
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('(');
        if (this.first == null) {
            out.append("null");
        } else {
            out.append(this.first);
        }
        out.append(", ");
        if (this.second == null) {
            out.append("null");
        } else {
            out.append(this.second);
        }
        out.append(')');
        return out.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry pair = (Map.Entry)o;
        if (!Objects.equals(this.first, pair.getKey())) {
            return false;
        }
        return Objects.equals(this.second, pair.getValue());
    }

    @Override
    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }
}

