/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "getLocalClassLikeDeclarationIdReplacement", "Lorg/jetbrains/kotlin/name/ClassId;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmElementAwareStringTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1915#2,2:80\n*S KotlinDebug\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n*L\n72#1:80,2\n*E\n"})
public final class FirJvmElementAwareStringTable
extends JvmStringTable
implements FirElementAwareStringTable {
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final Fir2IrComponents components;

    public FirJvmElementAwareStringTable(@NotNull IrTypeMapper typeMapper2, @NotNull Fir2IrComponents components, @Nullable JvmNameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(typeMapper2, "typeMapper");
        Intrinsics.checkNotNullParameter(components, "components");
        super(nameResolver);
        this.typeMapper = typeMapper2;
        this.components = components;
    }

    public /* synthetic */ FirJvmElementAwareStringTable(IrTypeMapper irTypeMapper, Fir2IrComponents fir2IrComponents, JvmNameResolver jvmNameResolver, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            jvmNameResolver = null;
        }
        this(irTypeMapper, fir2IrComponents, jvmNameResolver);
    }

    @Override
    @NotNull
    public ClassId getLocalClassLikeDeclarationIdReplacement(@NotNull FirClassLikeDeclaration declaration) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.components.getConfiguration().getSkipBodies()) {
            Object object;
            FirClassLikeDeclaration firClassLikeDeclaration = declaration;
            if (firClassLikeDeclaration instanceof FirClass) {
                object = CollectionsKt.firstOrNull(FirDeclarationUtilKt.getSuperConeTypes((FirClass)declaration));
                if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                    object = StandardClassIds.INSTANCE.getAny();
                }
            } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
                object = StandardClassIds.INSTANCE.getAny();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }
        FirClassLikeDeclaration firClassLikeDeclaration = declaration;
        if (firClassLikeDeclaration instanceof FirClass) {
            irElement = this.components.getClassifierStorage().getIrClass((FirClass)declaration);
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            irElement = (IrElement)this.components.getClassifierStorage().getIrTypeAliasSymbol(((FirTypeAlias)declaration).getSymbol()).getOwner();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrElement irClassLikeDeclaration = irElement;
        return this.getLocalClassLikeDeclarationIdReplacement((IrDeclarationBase)irClassLikeDeclaration);
    }

    private final ClassId getLocalClassLikeDeclarationIdReplacement(IrDeclarationBase $this$getLocalClassLikeDeclarationIdReplacement) {
        String thisClassLikeDeclarationName = StringsKt.replace$default(this.typeMapper.classLikeDeclarationInternalName($this$getLocalClassLikeDeclarationIdReplacement), '/', '.', false, 4, null);
        if (JvmIrAttributesKt.isEnclosedInConstructor($this$getLocalClassLikeDeclarationIdReplacement)) {
            FqName thisClassLikeDeclarationFqName = new FqName(thisClassLikeDeclarationName);
            return new ClassId(thisClassLikeDeclarationFqName.parent(), FqName.Companion.topLevel(thisClassLikeDeclarationFqName.shortName()), true);
        }
        IrDeclarationBase topmostClassParent = SequencesKt.last(SequencesKt.generateSequence($this$getLocalClassLikeDeclarationIdReplacement, FirJvmElementAwareStringTable::getLocalClassLikeDeclarationIdReplacement$lambda$0));
        String topmostClassParentName = StringsKt.replace$default(this.typeMapper.classLikeDeclarationInternalName(topmostClassParent), '/', '.', false, 4, null);
        FqName prefixFqName = new FqName(topmostClassParentName);
        ClassId classId = null;
        classId = new ClassId(prefixFqName.parent(), FqName.Companion.topLevel(prefixFqName.shortName()), true);
        if (thisClassLikeDeclarationName.length() == topmostClassParentName.length()) {
            return classId;
        }
        String string = thisClassLikeDeclarationName.substring(topmostClassParentName.length() + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        char[] cArray = new char[]{'$'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Name name2 = Name.identifier(it);
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            classId = classId.createNestedClassId(name2);
        }
        return classId;
    }

    private static final IrDeclarationBase getLocalClassLikeDeclarationIdReplacement$lambda$0(IrDeclarationBase it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IrDeclarationParent irDeclarationParent = it.getParent();
        return irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
    }
}

